/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cm.descriptor;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.knox.gateway.ClouderaManagerIntegrationMessages;
import org.apache.knox.gateway.cm.descriptor.ClouderaManagerDescriptorParser;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.topology.discovery.advanced.AdvancedServiceDiscoveryConfig;
import org.apache.knox.gateway.topology.discovery.advanced.AdvancedServiceDiscoveryConfigChangeListener;
import org.apache.knox.gateway.util.JsonUtils;

public class ClouderaManagerDescriptorMonitor
implements AdvancedServiceDiscoveryConfigChangeListener {
    private static final String CM_DESCRIPTOR_FILE_EXTENSION = ".cm";
    private static final ClouderaManagerIntegrationMessages LOG = (ClouderaManagerIntegrationMessages)MessagesFactory.get(ClouderaManagerIntegrationMessages.class);
    private final String descriptorsDir;
    private final long monitoringInterval;
    private final ClouderaManagerDescriptorParser cmDescriptorParser;
    private FileTime lastReloadTime;

    public ClouderaManagerDescriptorMonitor(GatewayConfig gatewayConfig, ClouderaManagerDescriptorParser cmDescriptorParser) {
        this.cmDescriptorParser = cmDescriptorParser;
        this.descriptorsDir = gatewayConfig.getGatewayDescriptorsDir();
        this.monitoringInterval = gatewayConfig.getClouderaManagerDescriptorsMonitoringInterval();
    }

    public void setupMonitor() {
        if (this.monitoringInterval > 0L) {
            ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("ClouderaManagerDescriptorMonitor-%d").build());
            executorService.scheduleAtFixedRate(() -> this.monitorClouderaManagerDescriptors(null), 0L, this.monitoringInterval, TimeUnit.MILLISECONDS);
            LOG.monitoringClouderaManagerDescriptor(this.descriptorsDir);
        } else {
            LOG.disableMonitoringClouderaManagerDescriptor();
        }
    }

    private void monitorClouderaManagerDescriptors(String topologyName) {
        File[] clouderaManagerDescriptorFiles;
        for (File clouderaManagerDescriptorFile : clouderaManagerDescriptorFiles = new File(this.descriptorsDir).listFiles((FileFilter)new SuffixFileFilter(CM_DESCRIPTOR_FILE_EXTENSION))) {
            this.monitorClouderaManagerDescriptor(Paths.get(clouderaManagerDescriptorFile.getAbsolutePath(), new String[0]), topologyName);
        }
    }

    private void monitorClouderaManagerDescriptor(Path clouderaManagerDescriptorFile, String topologyName) {
        try {
            if (Files.isReadable(clouderaManagerDescriptorFile)) {
                FileTime lastModifiedTime = Files.getLastModifiedTime(clouderaManagerDescriptorFile, new LinkOption[0]);
                if (topologyName != null || this.lastReloadTime == null || this.lastReloadTime.compareTo(lastModifiedTime) < 0) {
                    this.lastReloadTime = lastModifiedTime;
                    this.processClouderaManagerDescriptor(clouderaManagerDescriptorFile.toString(), topologyName);
                }
            } else {
                LOG.failedToMonitorClouderaManagerDescriptor(clouderaManagerDescriptorFile.toString(), "File is not readable!", null);
            }
        }
        catch (IOException e) {
            LOG.failedToMonitorClouderaManagerDescriptor(clouderaManagerDescriptorFile.toString(), e.getMessage(), e);
        }
    }

    private void processClouderaManagerDescriptor(String descriptorFilePath, String topologyName) {
        this.cmDescriptorParser.parse(descriptorFilePath, topologyName).forEach(simpleDescriptor -> {
            try {
                File knoxDescriptorFile = new File(this.descriptorsDir, simpleDescriptor.getName() + ".json");
                String simpleDescriptorJsonString = JsonUtils.renderAsJsonString((Object)simpleDescriptor);
                if (this.isDescriptorChangedOrNew(knoxDescriptorFile, simpleDescriptorJsonString)) {
                    FileUtils.writeStringToFile((File)knoxDescriptorFile, (String)JsonUtils.renderAsJsonString((Object)simpleDescriptor), (Charset)StandardCharsets.UTF_8);
                    LOG.savedSimpleDescriptorDescriptor(knoxDescriptorFile.getAbsolutePath());
                } else {
                    LOG.descriptorDidNotChange(simpleDescriptor.getName());
                }
            }
            catch (IOException e) {
                LOG.failedToProduceKnoxDescriptor(e.getMessage(), e);
            }
        });
    }

    private boolean isDescriptorChangedOrNew(File knoxDescriptorFile, String simpleDescriptorJsonString) throws IOException {
        if (knoxDescriptorFile.exists()) {
            String currentContent = FileUtils.readFileToString((File)knoxDescriptorFile, (Charset)StandardCharsets.UTF_8);
            return !simpleDescriptorJsonString.equals(currentContent);
        }
        return true;
    }

    @Override
    public void onAdvancedServiceDiscoveryConfigurationChange(Properties newConfiguration) {
        String topologyName = new AdvancedServiceDiscoveryConfig(newConfiguration).getTopologyName();
        if (StringUtils.isBlank((CharSequence)topologyName)) {
            throw new IllegalArgumentException("Invalid advanced service discovery configuration: topology name is missing!");
        }
        this.monitorClouderaManagerDescriptors(topologyName);
    }
}

