/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.github.scribejava.apis.LinkedInApi20;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.redirect.RedirectAction;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.profile.linkedin2.LinkedIn2Configuration;
import org.pac4j.oauth.profile.linkedin2.LinkedIn2Profile;
import org.pac4j.oauth.profile.linkedin2.LinkedIn2ProfileCreator;
import org.pac4j.oauth.profile.linkedin2.LinkedIn2ProfileDefinition;

public class LinkedIn2Client
extends OAuth20Client<LinkedIn2Profile> {
    public LinkedIn2Client() {
        this.configuration = new LinkedIn2Configuration();
    }

    public LinkedIn2Client(String key, String secret) {
        this();
        this.setKey(key);
        this.setSecret(secret);
    }

    @Override
    protected void clientInit() {
        CommonHelper.assertNotBlank((String)"scope", (String)this.getConfiguration().getScope());
        this.configuration.setApi(LinkedInApi20.instance());
        this.configuration.setProfileDefinition(new LinkedIn2ProfileDefinition());
        this.configuration.setWithState(true);
        this.configuration.setHasBeenCancelledFactory(ctx -> {
            String error = ctx.getRequestParameter("error");
            String errorDescription = ctx.getRequestParameter("error_description");
            if ("access_denied".equals(error) && ("the+user+denied+your+request".equals(errorDescription) || "the user denied your request".equals(errorDescription))) {
                return true;
            }
            return false;
        });
        this.defaultLogoutActionBuilder((ctx, profile, targetUrl) -> RedirectAction.redirect((String)"https://www.linkedin.com/uas/logout"));
        this.defaultProfileCreator(new LinkedIn2ProfileCreator(this.configuration, (IndirectClient)this));
        super.clientInit();
    }

    @Override
    public LinkedIn2Configuration getConfiguration() {
        return (LinkedIn2Configuration)this.configuration;
    }

    public String getScope() {
        return this.getConfiguration().getScope();
    }

    public void setScope(String scope) {
        this.getConfiguration().setScope(scope);
    }
}

