/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import jdbm.recman.BlockIo;
import jdbm.recman.BlockView;
import jdbm.recman.PageHeader;
import jdbm.recman.PhysicalRowId;

class FreeLogicalRowIdPage
extends PageHeader {
    private static final short O_COUNT = 18;
    static final short O_FREE = 20;
    static final short ELEMS_PER_PAGE = 407;
    final PhysicalRowId[] slots = new PhysicalRowId[407];

    FreeLogicalRowIdPage(BlockIo blockIo) {
        super(blockIo);
    }

    static FreeLogicalRowIdPage getFreeLogicalRowIdPageView(BlockIo blockIo) {
        BlockView view = blockIo.getView();
        if (view != null && view instanceof FreeLogicalRowIdPage) {
            return (FreeLogicalRowIdPage)view;
        }
        return new FreeLogicalRowIdPage(blockIo);
    }

    short getCount() {
        return this.blockIo.readShort(18);
    }

    private void setCount(short i) {
        this.blockIo.writeShort(18, i);
    }

    void free(int slot) {
        this.get(slot).setBlock(0L);
        this.setCount((short)(this.getCount() - 1));
    }

    PhysicalRowId alloc(int slot) {
        this.setCount((short)(this.getCount() + 1));
        this.get(slot).setBlock(-1L);
        return this.get(slot);
    }

    private boolean isAllocated(int slot) {
        return this.get(slot).getBlock() > 0L;
    }

    private boolean isFree(int slot) {
        return !this.isAllocated(slot);
    }

    PhysicalRowId get(int slot) {
        if (this.slots[slot] == null) {
            this.slots[slot] = new PhysicalRowId(this.blockIo, this.slotToOffset(slot));
        }
        return this.slots[slot];
    }

    private short slotToOffset(int slot) {
        return (short)(20 + slot * 10);
    }

    int getFirstFree() {
        for (int i = 0; i < 407; ++i) {
            if (!this.isFree(i)) continue;
            return i;
        }
        return -1;
    }

    int getFirstAllocated() {
        for (int i = 0; i < 407; ++i) {
            if (!this.isAllocated(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FreeLogRowIdPage ( ");
        sb.append(super.toString()).append(", ");
        sb.append("count: ").append(this.getCount());
        for (int i = 0; i < 407; ++i) {
            if (this.slots[i] == null) continue;
            sb.append(", [").append(i).append("]=<").append(this.slots[i].getBlock()).append(", ").append(this.slots[i].getOffset()).append(">");
        }
        sb.append(")");
        return sb.toString();
    }
}

