/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.xml;

import org.apache.commons.digester3.Rule;
import org.apache.commons.digester3.binder.AbstractRulesModule;
import org.apache.knox.gateway.service.definition.CustomDispatch;
import org.apache.knox.gateway.service.definition.DispatchParam;
import org.apache.knox.gateway.topology.Application;
import org.apache.knox.gateway.topology.Param;
import org.apache.knox.gateway.topology.Provider;
import org.apache.knox.gateway.topology.Service;
import org.apache.knox.gateway.topology.Version;
import org.apache.knox.gateway.topology.builder.BeanPropertyTopologyBuilder;
import org.xml.sax.Attributes;

public class KnoxFormatXmlTopologyRules
extends AbstractRulesModule {
    private static final String ROOT_TAG = "topology";
    private static final String NAME_TAG = "name";
    private static final String VERSION_TAG = "version";
    private static final String DEFAULT_SERVICE_TAG = "path";
    private static final String GENERATED_TAG = "generated";
    private static final String APPLICATION_TAG = "application";
    private static final String SERVICE_TAG = "service";
    private static final String ROLE_TAG = "role";
    private static final String URL_TAG = "url";
    private static final String PROVIDER_TAG = "gateway/provider";
    private static final String ENABLED_TAG = "enabled";
    private static final String PARAM_TAG = "param";
    private static final String VALUE_TAG = "value";
    private static final String DISPATCH_TAG = "dispatch";
    private static final String CONTRIBUTOR_NAME = "contributor-name";
    private static final String HA_CONTRIBUTOR_NAME = "ha-contributor-name";
    private static final String CLASSNAME = "classname";
    private static final String HA_CLASSNAME = "ha-classname";
    private static final String HTTP_CLIENT_FACTORY = "http-client-factory";
    private static final String USE_TWO_WAY_SSL = "use-two-way-ssl";
    private static final Rule paramRule = new ParamRule();
    private static final Rule dispatchParamRule = new DispatchParamRule();

    protected void configure() {
        this.forPattern(ROOT_TAG).createObject().ofType(BeanPropertyTopologyBuilder.class);
        this.forPattern("topology/name").callMethod(NAME_TAG).usingElementBodyAsArgument();
        this.forPattern("topology/version").callMethod(VERSION_TAG).usingElementBodyAsArgument();
        this.forPattern("topology/path").callMethod("defaultService").usingElementBodyAsArgument();
        this.forPattern("topology/generated").callMethod(GENERATED_TAG).usingElementBodyAsArgument();
        this.forPattern("topology/application").createObject().ofType(Application.class).then().setNext("addApplication");
        this.forPattern("topology/application/role").setBeanProperty();
        this.forPattern("topology/application/name").setBeanProperty();
        this.forPattern("topology/application/version").createObject().ofType(Version.class).then().setBeanProperty().then().setNext("setVersion");
        this.forPattern("topology/application/url").callMethod("addUrl").usingElementBodyAsArgument();
        this.forPattern("topology/application/param").createObject().ofType(Param.class).then().addRule(paramRule).then().setNext("addParam");
        this.forPattern("topology/application/param/name").setBeanProperty();
        this.forPattern("topology/application/param/value").setBeanProperty();
        this.forPattern("topology/service").createObject().ofType(Service.class).then().setNext("addService");
        this.forPattern("topology/service/role").setBeanProperty();
        this.forPattern("topology/service/name").setBeanProperty();
        this.forPattern("topology/service/version").createObject().ofType(Version.class).then().setBeanProperty().then().setNext("setVersion");
        this.forPattern("topology/service/url").callMethod("addUrl").usingElementBodyAsArgument();
        this.forPattern("topology/service/param").createObject().ofType(Param.class).then().addRule(paramRule).then().setNext("addParam");
        this.forPattern("topology/service/param/name").setBeanProperty();
        this.forPattern("topology/service/param/value").setBeanProperty();
        this.forPattern("topology/service/dispatch").createObject().ofType(CustomDispatch.class).then().setNext("addDispatch");
        this.forPattern("topology/service/dispatch/contributor-name").callMethod("setContributorName").usingElementBodyAsArgument();
        this.forPattern("topology/service/dispatch/ha-contributor-name").callMethod("setHaContributorName").usingElementBodyAsArgument();
        this.forPattern("topology/service/dispatch/classname").callMethod("setClassName").usingElementBodyAsArgument();
        this.forPattern("topology/service/dispatch/ha-classname").callMethod("setHaClassName").usingElementBodyAsArgument();
        this.forPattern("topology/service/dispatch/http-client-factory").callMethod("setHttpClientFactory").usingElementBodyAsArgument();
        this.forPattern("topology/service/dispatch/use-two-way-ssl").callMethod("setUseTwoWaySsl").usingElementBodyAsArgument();
        this.forPattern("topology/service/dispatch/param").createObject().ofType(DispatchParam.class).then().addRule(dispatchParamRule).then().setNext("addParam");
        this.forPattern("topology/service/dispatch/param/name").setBeanProperty();
        this.forPattern("topology/service/dispatch/param/value").setBeanProperty();
        this.forPattern("topology/gateway/provider").createObject().ofType(Provider.class).then().setNext("addProvider");
        this.forPattern("topology/gateway/provider/role").setBeanProperty();
        this.forPattern("topology/gateway/provider/enabled").setBeanProperty();
        this.forPattern("topology/gateway/provider/name").setBeanProperty();
        this.forPattern("topology/gateway/provider/param").createObject().ofType(Param.class).then().addRule(paramRule).then().setNext("addParam");
        this.forPattern("topology/gateway/provider/param/name").setBeanProperty();
        this.forPattern("topology/gateway/provider/param/value").setBeanProperty();
    }

    private static class DispatchParamRule
    extends Rule {
        private DispatchParamRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) {
            DispatchParam param = (DispatchParam)this.getDigester().peek();
            String paramName = attributes.getValue(KnoxFormatXmlTopologyRules.NAME_TAG);
            if (paramName != null) {
                param.setName(paramName);
                param.setValue(attributes.getValue(KnoxFormatXmlTopologyRules.VALUE_TAG));
            }
        }
    }

    private static class ParamRule
    extends Rule {
        private ParamRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) {
            Param param = (Param)this.getDigester().peek();
            String paramName = attributes.getValue(KnoxFormatXmlTopologyRules.NAME_TAG);
            if (paramName != null) {
                param.setName(paramName);
                param.setValue(attributes.getValue(KnoxFormatXmlTopologyRules.VALUE_TAG));
            }
        }
    }
}

