/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.kdcRep.actions;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.shared.kerberos.codec.kdcRep.KdcRepContainer;
import org.apache.directory.shared.kerberos.codec.ticket.TicketContainer;
import org.apache.directory.shared.kerberos.components.KdcRep;
import org.apache.directory.shared.kerberos.messages.Ticket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreTicket
extends GrammarAction<KdcRepContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreTicket.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreTicket() {
        super("KDC-REP Store Ticket");
    }

    public void action(KdcRepContainer kdcRepContainer) throws DecoderException {
        TLV tlv = kdcRepContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err((I18n)I18n.ERR_01308_ZERO_LENGTH_TLV, (Object[])new Object[0]));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_01309_EMPTY_TLV, (Object[])new Object[0]));
        }
        TicketContainer ticketContainer = new TicketContainer(kdcRepContainer.getStream());
        Asn1Decoder.decode((ByteBuffer)kdcRepContainer.getStream(), (Asn1Container)ticketContainer);
        tlv.setExpectedLength(tlv.getExpectedLength() - tlv.getLength());
        kdcRepContainer.updateParent();
        Ticket ticket = ticketContainer.getTicket();
        KdcRep kdcRep = kdcRepContainer.getKdcRep();
        kdcRep.setTicket(ticket);
        if (IS_DEBUG) {
            LOG.debug("Stored ticket:  {}", (Object)ticket);
        }
    }
}

