/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.hadoopauth.filter;

import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.util.HttpExceptionUtils;
import org.apache.knox.gateway.GatewayServer;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.hadoopauth.HadoopAuthMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;

public class HadoopAuthFilter
extends AuthenticationFilter {
    private static final String QUERY_PARAMETER_DOAS = "doAs";
    private static final String PROXYUSER_PREFIX = "hadoop.proxyuser";
    private static final HadoopAuthMessages LOG = (HadoopAuthMessages)MessagesFactory.get(HadoopAuthMessages.class);
    private final Set<String> ignoreDoAs = new HashSet<String>();

    protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
        GatewayServices services = GatewayServer.getGatewayServices();
        AliasService aliasService = (AliasService)services.getService(ServiceType.ALIAS_SERVICE);
        return this.getConfiguration(aliasService, configPrefix, filterConfig);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        Object attributeValue;
        Configuration conf = this.getProxyuserConfiguration(filterConfig);
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf, (String)PROXYUSER_PREFIX);
        Collection<String> ignoredServices = null;
        String configValue = filterConfig.getInitParameter("gateway.proxyuser.services.ignore.doas");
        if (configValue != null && !(configValue = configValue.trim()).isEmpty()) {
            ignoredServices = Arrays.asList(configValue.toLowerCase(Locale.ROOT).split("\\s*,\\s*"));
        }
        if (ignoredServices == null && (attributeValue = filterConfig.getServletContext().getAttribute("org.apache.knox.gateway.config")) instanceof GatewayConfig) {
            ignoredServices = ((GatewayConfig)attributeValue).getServicesToIgnoreDoAs();
        }
        if (ignoredServices != null) {
            this.ignoreDoAs.addAll(ignoredServices);
        }
        super.init(filterConfig);
    }

    protected void doFilter(FilterChain filterChain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String doAsUser;
        if (!this.ignoreDoAs(request.getRemoteUser()) && (doAsUser = request.getParameter(QUERY_PARAMETER_DOAS)) != null && !doAsUser.equals(request.getRemoteUser())) {
            UserGroupInformation requestUgi;
            LOG.hadoopAuthDoAsUser(doAsUser, request.getRemoteUser(), request.getRemoteAddr());
            UserGroupInformation userGroupInformation = requestUgi = request.getUserPrincipal() != null ? UserGroupInformation.createRemoteUser((String)request.getRemoteUser()) : null;
            if (requestUgi != null) {
                requestUgi = UserGroupInformation.createProxyUser((String)doAsUser, (UserGroupInformation)requestUgi);
                try {
                    ProxyUsers.authorize((UserGroupInformation)requestUgi, (String)request.getRemoteAddr());
                    final UserGroupInformation ugiF = requestUgi;
                    request = new HttpServletRequestWrapper((HttpServletRequest)request){

                        public String getRemoteUser() {
                            return ugiF.getShortUserName();
                        }

                        public Principal getUserPrincipal() {
                            return () -> ((UserGroupInformation)ugiF).getUserName();
                        }
                    };
                    LOG.hadoopAuthProxyUserSuccess();
                }
                catch (AuthorizationException ex) {
                    HttpExceptionUtils.createServletExceptionResponse((HttpServletResponse)response, (int)403, (Throwable)ex);
                    LOG.hadoopAuthProxyUserFailed(ex);
                    return;
                }
            }
        }
        super.doFilter(filterChain, request, response);
    }

    boolean ignoreDoAs(String userName) {
        return userName == null || userName.isEmpty() || this.ignoreDoAs.contains(userName.toLowerCase(Locale.ROOT));
    }

    private Configuration getProxyuserConfiguration(FilterConfig filterConfig) {
        Configuration conf = new Configuration(false);
        Enumeration names = filterConfig.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith("hadoop.proxyuser.")) continue;
            String value = filterConfig.getInitParameter(name);
            conf.set(name, value);
        }
        return conf;
    }

    Properties getConfiguration(AliasService aliasService, String configPrefix, FilterConfig filterConfig) throws ServletException {
        String clusterName = filterConfig.getInitParameter("clusterName");
        Properties props = new Properties();
        Enumeration names = filterConfig.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith(configPrefix)) continue;
            String value = filterConfig.getInitParameter(name);
            if (value.startsWith("${ALIAS=") && value.endsWith("}")) {
                String alias = value.substring("${ALIAS=".length(), value.length() - 1);
                try {
                    value = String.valueOf(aliasService.getPasswordFromAliasForCluster(clusterName, alias));
                }
                catch (AliasServiceException e) {
                    throw new ServletException("Unable to retrieve alias for config: " + name, (Throwable)e);
                }
            }
            props.put(name.substring(configPrefix.length()), value);
        }
        return props;
    }
}

