/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.erasurecode.CodecRegistry;
import org.apache.hadoop.io.erasurecode.ErasureCodecOptions;
import org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import org.apache.hadoop.io.erasurecode.codec.ErasureCodec;
import org.apache.hadoop.io.erasurecode.codec.HHXORErasureCodec;
import org.apache.hadoop.io.erasurecode.codec.RSErasureCodec;
import org.apache.hadoop.io.erasurecode.codec.XORErasureCodec;
import org.apache.hadoop.io.erasurecode.coder.ErasureDecoder;
import org.apache.hadoop.io.erasurecode.coder.ErasureEncoder;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureCoderFactory;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class CodecUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CodecUtil.class);
    public static final String IO_ERASURECODE_CODEC = "io.erasurecode.codec.";
    public static final String IO_ERASURECODE_CODEC_XOR_KEY = "io.erasurecode.codec.xor";
    public static final String IO_ERASURECODE_CODEC_XOR = XORErasureCodec.class.getCanonicalName();
    public static final String IO_ERASURECODE_CODEC_RS_KEY = "io.erasurecode.codec.rs";
    public static final String IO_ERASURECODE_CODEC_RS = RSErasureCodec.class.getCanonicalName();
    public static final String IO_ERASURECODE_CODEC_HHXOR_KEY = "io.erasurecode.codec.hhxor";
    public static final String IO_ERASURECODE_CODEC_HHXOR = HHXORErasureCodec.class.getCanonicalName();
    public static final String IO_ERASURECODE_CODEC_RS_LEGACY_RAWCODERS_KEY = "io.erasurecode.codec.rs-legacy.rawcoders";
    public static final String IO_ERASURECODE_CODEC_RS_RAWCODERS_KEY = "io.erasurecode.codec.rs.rawcoders";
    public static final String IO_ERASURECODE_CODEC_XOR_RAWCODERS_KEY = "io.erasurecode.codec.xor.rawcoders";

    private CodecUtil() {
    }

    public static ErasureEncoder createEncoder(Configuration conf, ErasureCodecOptions options) {
        Preconditions.checkNotNull((Object)conf);
        Preconditions.checkNotNull((Object)options);
        String codecKey = CodecUtil.getCodecClassName(conf, options.getSchema().getCodecName());
        ErasureCodec codec = CodecUtil.createCodec(conf, codecKey, options);
        return codec.createEncoder();
    }

    public static ErasureDecoder createDecoder(Configuration conf, ErasureCodecOptions options) {
        Preconditions.checkNotNull((Object)conf);
        Preconditions.checkNotNull((Object)options);
        String codecKey = CodecUtil.getCodecClassName(conf, options.getSchema().getCodecName());
        ErasureCodec codec = CodecUtil.createCodec(conf, codecKey, options);
        return codec.createDecoder();
    }

    public static RawErasureEncoder createRawEncoder(Configuration conf, String codec, ErasureCoderOptions coderOptions) {
        Preconditions.checkNotNull((Object)conf);
        Preconditions.checkNotNull((Object)codec);
        return CodecUtil.createRawEncoderWithFallback(conf, codec, coderOptions);
    }

    public static RawErasureDecoder createRawDecoder(Configuration conf, String codec, ErasureCoderOptions coderOptions) {
        Preconditions.checkNotNull((Object)conf);
        Preconditions.checkNotNull((Object)codec);
        return CodecUtil.createRawDecoderWithFallback(conf, codec, coderOptions);
    }

    private static RawErasureCoderFactory createRawCoderFactory(String coderName, String codecName) {
        RawErasureCoderFactory fact = CodecRegistry.getInstance().getCoderByName(codecName, coderName);
        return fact;
    }

    public static boolean hasCodec(String codecName) {
        return CodecRegistry.getInstance().getCoderNames(codecName) != null;
    }

    private static String[] getRawCoderNames(Configuration conf, String codecName) {
        return conf.getStrings(IO_ERASURECODE_CODEC + codecName + ".rawcoders", CodecRegistry.getInstance().getCoderNames(codecName));
    }

    private static RawErasureEncoder createRawEncoderWithFallback(Configuration conf, String codecName, ErasureCoderOptions coderOptions) {
        String[] rawCoderNames;
        for (String rawCoderName : rawCoderNames = CodecUtil.getRawCoderNames(conf, codecName)) {
            try {
                if (rawCoderName == null) continue;
                RawErasureCoderFactory fact = CodecUtil.createRawCoderFactory(rawCoderName, codecName);
                return fact.createEncoder(coderOptions);
            }
            catch (Exception | LinkageError e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Failed to create raw erasure encoder " + rawCoderName + ", fallback to next codec if possible", e);
            }
        }
        throw new IllegalArgumentException("Fail to create raw erasure encoder with given codec: " + codecName);
    }

    private static RawErasureDecoder createRawDecoderWithFallback(Configuration conf, String codecName, ErasureCoderOptions coderOptions) {
        String[] coders;
        for (String rawCoderName : coders = CodecUtil.getRawCoderNames(conf, codecName)) {
            try {
                if (rawCoderName == null) continue;
                RawErasureCoderFactory fact = CodecUtil.createRawCoderFactory(rawCoderName, codecName);
                return fact.createDecoder(coderOptions);
            }
            catch (Exception | LinkageError e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Failed to create raw erasure decoder " + rawCoderName + ", fallback to next codec if possible", e);
            }
        }
        throw new IllegalArgumentException("Fail to create raw erasure decoder with given codec: " + codecName);
    }

    private static ErasureCodec createCodec(Configuration conf, String codecClassName, ErasureCodecOptions options) {
        ErasureCodec codec = null;
        try {
            Class<ErasureCodec> codecClass = conf.getClassByName(codecClassName).asSubclass(ErasureCodec.class);
            Constructor<ErasureCodec> constructor = codecClass.getConstructor(Configuration.class, ErasureCodecOptions.class);
            codec = constructor.newInstance(conf, options);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to create erasure codec", e);
        }
        if (codec == null) {
            throw new RuntimeException("Failed to create erasure codec");
        }
        return codec;
    }

    private static String getCodecClassName(Configuration conf, String codec) {
        switch (codec) {
            case "rs": {
                return conf.get(IO_ERASURECODE_CODEC_RS_KEY, IO_ERASURECODE_CODEC_RS);
            }
            case "rs-legacy": {
                return conf.get(IO_ERASURECODE_CODEC_RS_KEY, IO_ERASURECODE_CODEC_RS);
            }
            case "xor": {
                return conf.get(IO_ERASURECODE_CODEC_XOR_KEY, IO_ERASURECODE_CODEC_XOR);
            }
            case "hhxor": {
                return conf.get(IO_ERASURECODE_CODEC_HHXOR_KEY, IO_ERASURECODE_CODEC_HHXOR);
            }
        }
        String codecKey = IO_ERASURECODE_CODEC + codec + ".coder";
        String codecClass = conf.get(codecKey);
        if (codecClass == null) {
            throw new IllegalArgumentException("Codec not configured for custom codec " + codec);
        }
        return codecClass;
    }
}

