/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.swaps;

import java.io.Reader;
import org.apache.juneau.BeanSession;
import org.apache.juneau.common.internal.IOUtils;
import org.apache.juneau.html.HtmlParser;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.swap.ObjectSwap;
import org.apache.juneau.uon.UonParser;
import org.apache.juneau.urlencoding.UrlEncodingParser;
import org.apache.juneau.xml.XmlParser;

public class ParsedReaderSwap
extends ObjectSwap<Reader, Object> {
    private ReaderParser parser;

    public ParsedReaderSwap(ReaderParser parser) {
        this.parser = parser;
    }

    @Override
    public Object swap(BeanSession session, Reader o) throws Exception {
        if (this.parser == null) {
            return IOUtils.read(o);
        }
        return this.parser.parse((Object)o, Object.class);
    }

    public static class UrlEncoding
    extends ParsedReaderSwap {
        public UrlEncoding() {
            super(UrlEncodingParser.DEFAULT);
        }
    }

    public static class Uon
    extends ParsedReaderSwap {
        public Uon() {
            super(UonParser.DEFAULT);
        }
    }

    public static class PlainText
    extends ParsedReaderSwap {
        public PlainText() {
            super(null);
        }
    }

    public static class Html
    extends ParsedReaderSwap {
        public Html() {
            super(HtmlParser.DEFAULT);
        }
    }

    public static class Xml
    extends ParsedReaderSwap {
        public Xml() {
            super(XmlParser.DEFAULT);
        }
    }

    public static class Json
    extends ParsedReaderSwap {
        public Json() {
            super(JsonParser.DEFAULT);
        }
    }
}

