/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config.store;

import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.Context;
import org.apache.juneau.config.internal.ConfigMap;
import org.apache.juneau.config.store.ConfigStoreListener;
import org.apache.juneau.internal.Cache;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.utils.HashKey;

public abstract class ConfigStore
extends Context
implements Closeable {
    private final ConcurrentHashMap<String, Set<ConfigStoreListener>> listeners = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConfigMap> configMaps = new ConcurrentHashMap();

    protected ConfigStore(Builder builder) {
        super((Context.Builder)builder);
    }

    public abstract String read(String var1) throws IOException;

    public abstract String write(String var1, String var2, String var3) throws IOException;

    public abstract boolean exists(String var1);

    public synchronized ConfigStore register(String name, ConfigStoreListener l) {
        Set s = this.listeners.get(name = this.resolveName(name));
        if (s == null) {
            s = CollectionUtils.synced(Collections.newSetFromMap(new IdentityHashMap()));
            this.listeners.put(name, s);
        }
        s.add((ConfigStoreListener)l);
        return this;
    }

    public synchronized ConfigStore unregister(String name, ConfigStoreListener l) {
        Set<ConfigStoreListener> s = this.listeners.get(name = this.resolveName(name));
        if (s != null) {
            s.remove(l);
        }
        return this;
    }

    public synchronized ConfigMap getMap(String name) throws IOException {
        ConfigMap cm = this.configMaps.get(name = this.resolveName(name));
        if (cm != null) {
            return cm;
        }
        cm = new ConfigMap(this, name);
        ConfigMap cm2 = this.configMaps.putIfAbsent(name, cm);
        if (cm2 != null) {
            return cm2;
        }
        this.register(name, cm);
        return cm;
    }

    public synchronized ConfigStore update(String name, String contents) {
        Set<ConfigStoreListener> s = this.listeners.get(name = this.resolveName(name));
        if (s != null) {
            this.listeners.get(name).forEach(x -> x.onChange(contents));
        }
        return this;
    }

    public synchronized ConfigStore update(String name, String ... contentLines) {
        name = this.resolveName(name);
        StringBuilder sb = new StringBuilder();
        for (String l : contentLines) {
            sb.append(l).append('\n');
        }
        return this.update(name, sb.toString());
    }

    protected String resolveName(String name) {
        return name;
    }

    @FluentSetters
    public static abstract class Builder
    extends Context.Builder {
        protected Builder() {
        }

        protected Builder(ConfigStore copyFrom) {
            super((Context)copyFrom);
        }

        protected Builder(Builder copyFrom) {
            super((Context.Builder)copyFrom);
        }

        public abstract Builder copy();

        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        public Builder applyAnnotations(Class<?> ... fromClasses) {
            super.applyAnnotations((Class[])fromClasses);
            return this;
        }

        public Builder applyAnnotations(Method ... fromMethods) {
            super.applyAnnotations(fromMethods);
            return this;
        }

        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache(value);
            return this;
        }

        public Builder debug() {
            super.debug();
            return this;
        }

        public Builder debug(boolean value) {
            super.debug(value);
            return this;
        }

        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        public Builder type(Class<? extends Context> value) {
            super.type(value);
            return this;
        }
    }
}

