/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice.jetty;

import java.io.File;
import java.io.FileWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Objects;
import org.apache.juneau.common.internal.IOUtils;
import org.apache.juneau.internal.FileUtils;
import org.apache.juneau.microservice.jetty.JettyServerFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.XmlConfiguration;

public class BasicJettyServerFactory
implements JettyServerFactory {
    @Override
    public Server create(String jettyXml) throws Exception {
        Objects.requireNonNull(jettyXml, "jetty.xml file location was not specified in the configuration file (Jetty/config) or manifest file (Jetty-Config) or found on the file system or classpath.");
        File f = FileUtils.createTempFile((String)"jetty.xml");
        try (StringReader r = new StringReader(jettyXml);
             FileWriter w = new FileWriter(f);){
            IOUtils.pipe((Reader)r, (Writer)w);
            ((Writer)w).flush();
        }
        XmlConfiguration xmlConfiguration = new XmlConfiguration(Resource.newResource((File)f));
        return (Server)xmlConfiguration.configure();
    }
}

