/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transform;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.MatchResult;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.transforms.ClassSwap;
import org.apache.juneau.transforms.EnumerationSwap;
import org.apache.juneau.transforms.IteratorSwap;
import org.apache.juneau.transforms.LocaleSwap;
import org.apache.juneau.transforms.MatchResultSwap;
import org.apache.juneau.transforms.StackTraceElementSwap;
import org.apache.juneau.transforms.TemporalCalendarSwap;
import org.apache.juneau.transforms.TemporalDateSwap;
import org.apache.juneau.transforms.TemporalSwap;
import org.apache.juneau.transforms.TimeZoneSwap;
import org.apache.juneau.transforms.XMLGregorianCalendarSwap;
import org.apache.juneau.transforms.ZoneIdSwap;

public class DefaultSwaps {
    private static final Map<Class<?>, PojoSwap<?, ?>> POJO_SWAPS = new ConcurrentHashMap();

    public static PojoSwap<?, ?> find(ClassInfo ci) {
        for (ClassInfo ci2 : ci.getAllParentsChildFirst()) {
            PojoSwap<?, ?> ps = POJO_SWAPS.get(ci2.inner());
            if (ps == null) continue;
            return ps;
        }
        return null;
    }

    static {
        POJO_SWAPS.put(Enumeration.class, new EnumerationSwap());
        POJO_SWAPS.put(Iterator.class, new IteratorSwap());
        POJO_SWAPS.put(Locale.class, new LocaleSwap());
        POJO_SWAPS.put(Class.class, new ClassSwap());
        POJO_SWAPS.put(Calendar.class, new TemporalCalendarSwap.IsoOffsetDateTime());
        POJO_SWAPS.put(Date.class, new TemporalDateSwap.IsoLocalDateTime());
        POJO_SWAPS.put(Instant.class, new TemporalSwap.IsoInstant());
        POJO_SWAPS.put(ZonedDateTime.class, new TemporalSwap.IsoOffsetDateTime());
        POJO_SWAPS.put(LocalDate.class, new TemporalSwap.IsoLocalDate());
        POJO_SWAPS.put(LocalDateTime.class, new TemporalSwap.IsoLocalDateTime());
        POJO_SWAPS.put(LocalTime.class, new TemporalSwap.IsoLocalTime());
        POJO_SWAPS.put(OffsetDateTime.class, new TemporalSwap.IsoOffsetDateTime());
        POJO_SWAPS.put(OffsetTime.class, new TemporalSwap.IsoOffsetTime());
        POJO_SWAPS.put(StackTraceElement.class, new StackTraceElementSwap());
        POJO_SWAPS.put(Year.class, new TemporalSwap.IsoYear());
        POJO_SWAPS.put(YearMonth.class, new TemporalSwap.IsoYearMonth());
        POJO_SWAPS.put(Temporal.class, new TemporalSwap.IsoInstant());
        POJO_SWAPS.put(TimeZone.class, new TimeZoneSwap());
        POJO_SWAPS.put(XMLGregorianCalendar.class, new XMLGregorianCalendarSwap());
        POJO_SWAPS.put(ZoneId.class, new ZoneIdSwap());
        POJO_SWAPS.put(MatchResult.class, new MatchResultSwap());
    }
}

