/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.juneau.cp.RecursiveResourceFinder;
import org.apache.juneau.cp.ResourceFinder;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.http.exception.InternalServerError;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.rest.BasicRestCallLogger;
import org.apache.juneau.rest.BasicRestInfoProvider;
import org.apache.juneau.rest.BasicRestResourceResolver;
import org.apache.juneau.rest.HttpRuntimeException;
import org.apache.juneau.rest.RestCallLogger;
import org.apache.juneau.rest.RestCallLoggerConfig;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestContextBuilder;
import org.apache.juneau.rest.RestContextProperties;
import org.apache.juneau.rest.RestInfoProvider;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResourceResolver;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.annotation.HookEvent;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.annotation.RestHook;
import org.apache.juneau.rest.annotation.RestResource;

public abstract class RestServlet
extends HttpServlet
implements RestInfoProvider,
RestCallLogger,
RestResourceResolver,
ResourceFinder {
    private static final long serialVersionUID = 1L;
    private RestContextBuilder builder;
    private volatile RestContext context;
    private volatile Exception initException;
    private boolean isInitialized = false;
    private volatile RestResourceResolver resourceResolver = new BasicRestResourceResolver();
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private RestInfoProvider infoProvider;
    private RestCallLogger callLogger;
    private ResourceFinder resourceFinder;

    public final synchronized void init(ServletConfig servletConfig) throws ServletException {
        try {
            if (this.context != null) {
                return;
            }
            this.builder = RestContext.create(servletConfig, this.getClass(), null);
            if (this.resourceResolver != null) {
                this.builder.resourceResolver(this.resourceResolver);
            }
            this.builder.init(this);
            super.init(servletConfig);
            this.builder.servletContext(this.getServletContext());
            this.setContext(this.builder.build());
            this.context.postInitChildFirst();
        }
        catch (ServletException e) {
            this.initException = e;
            this.log(Level.SEVERE, e, "Servlet init error on class ''{0}''", this.getClass().getName());
            throw e;
        }
        catch (Throwable e) {
            this.initException = HttpRuntimeException.toHttpException(e, InternalServerError.class);
            this.log(Level.SEVERE, e, "Servlet init error on class ''{0}''", this.getClass().getName());
        }
    }

    synchronized void innerInit(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    public synchronized void setContext(RestContext context) throws ServletException {
        this.builder = context.builder;
        this.context = context;
        this.isInitialized = true;
        this.infoProvider = new BasicRestInfoProvider(context);
        this.callLogger = new BasicRestCallLogger(context);
        this.resourceFinder = new RecursiveResourceFinder();
        context.postInit();
    }

    public synchronized boolean isInitialized() {
        return this.isInitialized;
    }

    public synchronized RestServlet setRestResourceResolver(RestResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
        return this;
    }

    public synchronized String getPath() {
        if (this.context != null) {
            return this.context.getPath();
        }
        ClassInfo ci = ClassInfo.of(this.getClass());
        String path = "";
        for (Rest rest : ci.getAnnotations(Rest.class)) {
            if (rest.path().isEmpty()) continue;
            path = StringUtils.trimSlashes(rest.path());
        }
        if (!path.isEmpty()) {
            return path;
        }
        for (RestResource restResource : ci.getAnnotations(RestResource.class)) {
            if (restResource.path().isEmpty()) continue;
            path = StringUtils.trimSlashes(restResource.path());
        }
        return "";
    }

    public synchronized RestContextBuilder getServletConfig() {
        return this.builder;
    }

    public synchronized RestContext getContext() {
        if (this.context == null) {
            throw new InternalServerError("RestContext object not set on resource.");
        }
        return this.context;
    }

    public RestContextProperties getProperties() {
        return this.getContext().getProperties();
    }

    public void log(String msg) {
        this.doLog(Level.INFO, null, () -> msg);
    }

    public void log(String msg, Throwable cause) {
        this.doLog(Level.INFO, null, () -> msg);
    }

    public void log(Level level, String msg, Object ... args) {
        this.doLog(level, null, () -> StringUtils.format(msg, args));
    }

    public void log(Level level, Throwable cause, String msg, Object ... args) {
        this.doLog(level, cause, () -> StringUtils.format(msg, args));
    }

    protected void doLog(Level level, Throwable cause, Supplier<String> msg) {
        this.logger.log(level, cause, msg);
    }

    public void service(HttpServletRequest r1, HttpServletResponse r2) throws ServletException, InternalServerError, IOException {
        try {
            if (!this.isInitialized) {
                if (this.initException != null) {
                    throw this.initException;
                }
                if (this.context == null) {
                    throw new InternalServerError("Servlet {0} not initialized.  init(ServletConfig) was not called.  This can occur if you've overridden this method but didn't call super.init(RestConfig).", this.getClass().getName());
                }
                this.isInitialized = true;
            }
            this.context.execute(r1, r2);
        }
        catch (Throwable e) {
            r2.sendError(500, e.getLocalizedMessage());
        }
    }

    public synchronized void destroy() {
        if (this.context != null) {
            this.context.destroy();
        }
        super.destroy();
    }

    @RestHook(value=HookEvent.INIT)
    public void onInit(RestContextBuilder builder) throws Exception {
    }

    @RestHook(value=HookEvent.POST_INIT)
    public void onPostInit(RestContext context) throws Exception {
    }

    @RestHook(value=HookEvent.POST_INIT_CHILD_FIRST)
    public void onPostInitChildFirst(RestContext context) throws Exception {
    }

    @RestHook(value=HookEvent.DESTROY)
    public void onDestroy(RestContext context) throws Exception {
    }

    @RestHook(value=HookEvent.START_CALL)
    public void onStartCall(HttpServletRequest req, HttpServletResponse res) throws Exception {
    }

    @RestHook(value=HookEvent.PRE_CALL)
    public void onPreCall(RestRequest req, RestResponse res) throws Exception {
    }

    @RestHook(value=HookEvent.POST_CALL)
    public void onPostCall(RestRequest req, RestResponse res) throws Exception {
    }

    @RestHook(value=HookEvent.END_CALL)
    public void onEndCall(HttpServletRequest req, HttpServletResponse res) throws Exception {
    }

    public synchronized RestRequest getRequest() {
        return this.getContext().getRequest();
    }

    public synchronized RestResponse getResponse() {
        return this.getContext().getResponse();
    }

    @Override
    public Swagger getSwagger(RestRequest req) throws Exception {
        return this.infoProvider.getSwagger(req);
    }

    @Override
    public String getSiteName(RestRequest req) throws Exception {
        return this.infoProvider.getSiteName(req);
    }

    @Override
    public String getTitle(RestRequest req) throws Exception {
        return this.infoProvider.getTitle(req);
    }

    @Override
    public String getDescription(RestRequest req) throws Exception {
        return this.infoProvider.getDescription(req);
    }

    @Override
    public String getMethodSummary(Method method, RestRequest req) throws Exception {
        return this.infoProvider.getMethodSummary(method, req);
    }

    @Override
    public String getMethodDescription(Method method, RestRequest req) throws Exception {
        return this.infoProvider.getMethodDescription(method, req);
    }

    @Override
    public void log(RestCallLoggerConfig config, HttpServletRequest req, HttpServletResponse res) {
        this.callLogger.log(config, req, res);
    }

    @Override
    public InputStream findResource(Class<?> baseClass, String name, Locale locale) throws IOException {
        return this.resourceFinder.findResource(baseClass, name, locale);
    }

    @Override
    public <T> T resolve(Object parent, Class<T> c, Object ... args) {
        return this.resourceResolver.resolve(parent, c, args);
    }

    @Override
    public <T> T resolve(Object parent, Class<T> c, RestContextBuilder builder, Object ... args) throws Exception {
        return this.resourceResolver.resolve(parent, c, builder, args);
    }
}

