/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.setup;

import org.apache.jena.tdb1.base.file.FileFactory;
import org.apache.jena.tdb1.base.file.FileSet;
import org.apache.jena.tdb1.base.objectfile.ObjectFile;
import org.apache.jena.tdb1.base.record.RecordFactory;
import org.apache.jena.tdb1.index.RangeIndex;
import org.apache.jena.tdb1.index.RangeIndexBuilder;
import org.apache.jena.tdb1.lib.ColumnMap;
import org.apache.jena.tdb1.setup.ObjectFileBuilder;
import org.apache.jena.tdb1.setup.StoreParams;
import org.apache.jena.tdb1.setup.TupleIndexBuilder;
import org.apache.jena.tdb1.store.tupletable.TupleIndex;
import org.apache.jena.tdb1.store.tupletable.TupleIndexRecord;

public class BuilderStdDB {

    public static class ObjectFileBuilderStd
    implements ObjectFileBuilder {
        @Override
        public ObjectFile buildObjectFile(FileSet fileSet, String ext) {
            String filename = fileSet.filename(ext);
            if (fileSet.isMem()) {
                return FileFactory.createObjectFileMem(filename);
            }
            return FileFactory.createObjectFileDisk(filename);
        }
    }

    public static class TupleIndexBuilderStd
    implements TupleIndexBuilder {
        private final RangeIndexBuilder rangeIndexBuilder;

        public TupleIndexBuilderStd(RangeIndexBuilder rangeIndexBuilder) {
            this.rangeIndexBuilder = rangeIndexBuilder;
        }

        @Override
        public TupleIndex buildTupleIndex(FileSet fileSet, ColumnMap colMap, String name, StoreParams params) {
            RecordFactory recordFactory = new RecordFactory(8 * colMap.length(), 0);
            RangeIndex rIdx = this.rangeIndexBuilder.buildRangeIndex(fileSet, recordFactory, params);
            TupleIndexRecord tIdx = new TupleIndexRecord(colMap.length(), colMap, name, recordFactory, rIdx);
            return tIdx;
        }
    }
}

