/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.spark.launcher.ChildProcAppHandle;

class OutputRedirector {
    private final BufferedReader reader;
    private final Logger sink;
    private final Thread thread;
    private final ChildProcAppHandle callback;
    private volatile boolean active = true;

    OutputRedirector(InputStream in, String loggerName, ThreadFactory tf) {
        this(in, loggerName, tf, null);
    }

    OutputRedirector(InputStream in, String loggerName, ThreadFactory tf, ChildProcAppHandle callback) {
        this.reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        this.thread = tf.newThread(this::redirect);
        this.sink = Logger.getLogger(loggerName);
        this.callback = callback;
        this.thread.start();
    }

    private void redirect() {
        try {
            String line;
            while ((line = this.reader.readLine()) != null) {
                if (!this.active) continue;
                this.sink.info(line.replaceFirst("\\s*$", ""));
            }
        }
        catch (IOException e) {
            this.sink.log(Level.FINE, "Error reading child process output.", e);
        }
        finally {
            if (this.callback != null) {
                this.callback.monitorChild();
            }
        }
    }

    void stop() {
        this.active = false;
    }

    boolean isAlive() {
        return this.thread.isAlive();
    }
}

