/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.server.interactive;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.livy.LivyClientBuilder;
import org.apache.livy.LivyConf;
import org.apache.livy.LivyConf$;
import org.apache.livy.Logging;
import org.apache.livy.client.common.ClientConf;
import org.apache.livy.rsc.RSCClient;
import org.apache.livy.rsc.RSCConf;
import org.apache.livy.server.AccessManager;
import org.apache.livy.server.interactive.CreateInteractiveRequest;
import org.apache.livy.server.interactive.InteractiveRecoveryMetadata;
import org.apache.livy.server.interactive.InteractiveSession;
import org.apache.livy.server.recovery.SessionStore;
import org.apache.livy.sessions.Kind;
import org.apache.livy.sessions.Session$;
import org.apache.livy.sessions.SessionState;
import org.apache.livy.utils.LivySparkUtils$;
import org.apache.livy.utils.SparkApp;
import org.apache.livy.utils.SparkApp$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.util.Random$;
import scala.util.matching.Regex;

public final class InteractiveSession$
implements Logging {
    public static InteractiveSession$ MODULE$;
    private final String SPARK_YARN_IS_PYTHON;
    private final String RECOVERY_SESSION_TYPE;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new InteractiveSession$();
    }

    public void trace(Function0<Object> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        InteractiveSession$ interactiveSession$ = this;
        synchronized (interactiveSession$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String SPARK_YARN_IS_PYTHON() {
        return this.SPARK_YARN_IS_PYTHON;
    }

    public String RECOVERY_SESSION_TYPE() {
        return this.RECOVERY_SESSION_TYPE;
    }

    public InteractiveSession create(int id, Option<String> name, String owner, Option<String> proxyUser, LivyConf livyConf, AccessManager accessManager, CreateInteractiveRequest request, SessionStore sessionStore, Option<String> ttl, Option<SparkApp> mockApp, Option<RSCClient> mockClient) {
        String appTag = new StringBuilder(14).append("livy-session-").append(id).append("-").append(Random$.MODULE$.alphanumeric().take(8).mkString()).toString();
        Option<String> impersonatedUser = accessManager.checkImpersonation(proxyUser, owner);
        Option client = mockClient.orElse((Function0 & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Map<String, String> conf = SparkApp$.MODULE$.prepareSparkConf(appTag, livyConf, Session$.MODULE$.prepareConf(request.conf(), (Seq<String>)request.jars(), (Seq<String>)request.files(), (Seq<String>)request.archives(), (Seq<String>)request.pyFiles(), livyConf));
            scala.collection.mutable.Map<String, String> builderProperties = MODULE$.prepareBuilderProp(conf, request.kind(), livyConf);
            scala.collection.immutable.Map userOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.driver.cores"), (Object)request.driverCores().map((Function1 & Serializable & scala.Serializable)x$1 -> InteractiveSession$.$anonfun$create$2(BoxesRunTime.unboxToInt((Object)x$1)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.driver.memory"), (Object)request.driverMemory().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executor.cores"), (Object)request.executorCores().map((Function1 & Serializable & scala.Serializable)x$3 -> InteractiveSession$.$anonfun$create$4(BoxesRunTime.unboxToInt((Object)x$3)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executor.memory"), (Object)request.executorMemory().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executor.instances"), (Object)request.numExecutors().map((Function1 & Serializable & scala.Serializable)x$5 -> InteractiveSession$.$anonfun$create$6(BoxesRunTime.unboxToInt((Object)x$5)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.app.name"), (Object)request.name().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.queue"), request.queue())}));
            userOpts.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                InteractiveSession$.$anonfun$create$8(builderProperties, x0$1);
                return BoxedUnit.UNIT;
            });
            builderProperties.getOrElseUpdate((Object)"spark.app.name", (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("livy-session-").append(id).toString());
            MODULE$.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Creating Interactive session ").append(id).append(": [owner: ").append(owner).append(", request: ").append(request).append("]").toString());
            LivyClientBuilder builder = new LivyClientBuilder().setAll((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(builderProperties).asJava()).setConf("livy.client.session-id", Integer.toString(id)).setConf(RSCConf.Entry.DRIVER_CLASS.key(), "org.apache.livy.repl.ReplDriver").setConf(RSCConf.Entry.PROXY_USER.key(), (String)impersonatedUser.orNull(Predef$.MODULE$.$conforms())).setURI(new URI("rsc:/"));
            return Option$.MODULE$.apply((Object)((RSCClient)builder.build()));
        });
        return new InteractiveSession(id, name, (Option<String>)None$.MODULE$, appTag, (Option<RSCClient>)client, (SessionState)SessionState.Starting$.MODULE$, request.kind(), request.heartbeatTimeoutInSecond(), livyConf, owner, impersonatedUser, ttl, sessionStore, request.driverMemory(), request.driverCores(), request.executorMemory(), request.executorCores(), request.conf(), request.archives(), request.files(), request.jars(), request.numExecutors(), request.pyFiles(), request.queue(), mockApp);
    }

    public Option<SparkApp> create$default$10() {
        return None$.MODULE$;
    }

    public Option<RSCClient> create$default$11() {
        return None$.MODULE$;
    }

    public InteractiveSession recover(InteractiveRecoveryMetadata metadata, LivyConf livyConf, SessionStore sessionStore, Option<SparkApp> mockApp, Option<RSCClient> mockClient) {
        Option client = mockClient.orElse((Function0 & Serializable & scala.Serializable)() -> metadata.rscDriverUri().map((Function1 & Serializable & scala.Serializable)uri -> {
            LivyClientBuilder builder = new LivyClientBuilder().setURI(uri);
            return (RSCClient)builder.build();
        }));
        return new InteractiveSession(metadata.id(), metadata.name(), metadata.appId(), metadata.appTag(), (Option<RSCClient>)client, (SessionState)SessionState.Recovering$.MODULE$, metadata.kind(), metadata.heartbeatTimeoutS(), livyConf, metadata.owner(), metadata.proxyUser(), metadata.ttl(), sessionStore, metadata.driverMemory(), metadata.driverCores(), metadata.executorMemory(), metadata.executorCores(), metadata.conf(), metadata.archives(), metadata.files(), metadata.jars(), metadata.numExecutors(), metadata.pyFiles(), metadata.queue(), mockApp);
    }

    public Option<SparkApp> recover$default$4() {
        return None$.MODULE$;
    }

    public Option<RSCClient> recover$default$5() {
        return None$.MODULE$;
    }

    public scala.collection.mutable.Map<String, String> prepareBuilderProp(scala.collection.immutable.Map<String, String> conf, Kind kind, LivyConf livyConf) {
        int sparkMajorVersion;
        scala.collection.mutable.Map builderProperties = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        builderProperties.$plus$plus$eq(conf);
        Nil$ pySparkFiles = !LivyConf$.MODULE$.TEST_MODE() ? InteractiveSession$.findPySparkArchives$1(livyConf) : Nil$.MODULE$;
        Object object = pySparkFiles.nonEmpty() ? builderProperties.put((Object)this.SPARK_YARN_IS_PYTHON(), (Object)"true") : BoxedUnit.UNIT;
        InteractiveSession$.mergeConfList$1((Seq)pySparkFiles, LivyConf$.MODULE$.SPARK_PY_FILES(), builderProperties);
        None$ sparkRArchive = !LivyConf$.MODULE$.TEST_MODE() ? InteractiveSession$.findSparkRArchive$1(livyConf) : None$.MODULE$;
        sparkRArchive.foreach((Function1 & Serializable & scala.Serializable)archive -> builderProperties.put((Object)RSCConf.Entry.SPARKR_PACKAGE.key(), (Object)new StringBuilder(7).append((String)archive).append("#sparkr").toString()));
        builderProperties.put((Object)RSCConf.Entry.SESSION_KIND.key(), (Object)kind.toString());
        Option$.MODULE$.apply((Object)livyConf.get(LivyConf$.MODULE$.RSC_JARS())).foreach((Function1 & Serializable & scala.Serializable)x$15 -> (String)builderProperties.getOrElseUpdate((Object)RSCConf.Entry.LIVY_JARS.key(), (Function0 & Serializable & scala.Serializable)() -> x$15));
        Predef$.MODULE$.require(livyConf.get(LivyConf$.MODULE$.LIVY_SPARK_VERSION()) != null);
        Predef$.MODULE$.require(livyConf.get(LivyConf$.MODULE$.LIVY_SPARK_SCALA_VERSION()) != null);
        Tuple2<Object, Object> tuple2 = LivySparkUtils$.MODULE$.formatSparkVersion(livyConf.get(LivyConf$.MODULE$.LIVY_SPARK_VERSION()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int n = sparkMajorVersion = tuple2._1$mcI$sp();
        int sparkMajorVersion2 = n;
        String scalaVersion = livyConf.get(LivyConf$.MODULE$.LIVY_SPARK_SCALA_VERSION());
        InteractiveSession$.mergeConfList$1((Seq)InteractiveSession$.livyJars$1(livyConf, scalaVersion), LivyConf$.MODULE$.SPARK_JARS(), builderProperties);
        boolean enableHiveContext = livyConf.getBoolean(LivyConf$.MODULE$.ENABLE_HIVE_CONTEXT());
        builderProperties.put((Object)"spark.livy.spark_major_version", (Object)Integer.toString(sparkMajorVersion2));
        String confVal = enableHiveContext ? "hive" : "in-memory";
        builderProperties.put((Object)"spark.sql.catalogImplementation", (Object)confVal);
        if (enableHiveContext) {
            this.mergeHiveSiteAndHiveDeps$1(sparkMajorVersion2, conf, livyConf, builderProperties);
        }
        ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(livyConf.iterator()).asScala()).foreach((Function1 & Serializable & scala.Serializable)e -> {
            InteractiveSession$.$anonfun$prepareBuilderProp$30(builderProperties, e);
            return BoxedUnit.UNIT;
        });
        return builderProperties;
    }

    public static final /* synthetic */ String $anonfun$create$2(int x$1) {
        return Integer.toString(x$1);
    }

    public static final /* synthetic */ String $anonfun$create$4(int x$3) {
        return Integer.toString(x$3);
    }

    public static final /* synthetic */ String $anonfun$create$6(int x$5) {
        return Integer.toString(x$5);
    }

    public static final /* synthetic */ void $anonfun$create$8(scala.collection.mutable.Map builderProperties$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        Option opt = (Option)tuple2._2();
        opt.foreach((Function1 & Serializable & scala.Serializable)value -> builderProperties$1.put((Object)key, value));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$prepareBuilderProp$2(Regex regex$1, String scalaVersion$1, String name) {
        boolean bl;
        String string = new Path(name).getName();
        Option option = regex$1.unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String ver;
            String string2 = ver = (String)((LinearSeqOptimized)option.get()).apply(0);
            String string3 = scalaVersion$1;
            bl = !(string2 != null ? !string2.equals(string3) : string3 != null);
        } else {
            bl = name.endsWith(".jar");
        }
        return bl;
    }

    private static final List livyJars$1(LivyConf livyConf, String scalaVersion) {
        return (List)Option$.MODULE$.apply((Object)livyConf.get(LivyConf$.MODULE$.REPL_JARS())).map((Function1 & Serializable & scala.Serializable)jars -> {
            Regex regex = new StringOps(Predef$.MODULE$.augmentString("[\\w-]+_(\\d\\.\\d\\d).*\\.jar")).r();
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])jars.split(","))).filter((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)InteractiveSession$.$anonfun$prepareBuilderProp$2(regex, scalaVersion, name))))).toList();
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String home = (String)package$.MODULE$.env().apply((Object)"LIVY_HOME");
            File jars = (File)Option$.MODULE$.apply((Object)new File(home, new StringBuilder(10).append("repl_").append(scalaVersion).append("-jars").toString())).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isDirectory())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new File(home, new StringBuilder(23).append("repl/scala-").append(scalaVersion).append("/target/jars").toString()));
            Predef$.MODULE$.require(jars.isDirectory(), (Function0 & Serializable & scala.Serializable)() -> "Cannot find Livy REPL jars.");
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])jars.listFiles())).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getAbsolutePath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toList();
        });
    }

    private static final Option findSparkRArchive$1(LivyConf livyConf$2) {
        return Option$.MODULE$.apply((Object)livyConf$2.get(RSCConf.Entry.SPARKR_PACKAGE.key())).orElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.env().get((Object)"SPARK_HOME").flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Some some;
            String string = x0$1;
            String path = ((TraversableOnce)new .colon.colon((Object)string, (List)new .colon.colon((Object)"R", (List)new .colon.colon((Object)"lib", (List)new .colon.colon((Object)"sparkr.zip", (List)Nil$.MODULE$))))).mkString(File.separator);
            File rArchivesFile = new File(path);
            if (rArchivesFile.exists()) {
                some = new Some((Object)rArchivesFile.getAbsolutePath());
            } else {
                MODULE$.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "sparkr.zip not found; cannot start R interpreter.");
                some = None$.MODULE$;
            }
            Some some2 = some;
            return some2;
        }));
    }

    public static final /* synthetic */ boolean $anonfun$prepareBuilderProp$12(File x$9) {
        return x$9.getName().startsWith("datanucleus-");
    }

    private final Seq datanucleusJars$1(LivyConf livyConf, int sparkMajorVersion) {
        Seq seq;
        if (new StringOps(Predef$.MODULE$.augmentString((String)package$.MODULE$.env().getOrElse((Object)"LIVY_INTEGRATION_TEST", (Function0 & Serializable & scala.Serializable)() -> "false"))).toBoolean()) {
            seq = (Seq)Nil$.MODULE$;
        } else {
            Seq jars;
            File file;
            String sparkHome = (String)livyConf.sparkHome().get();
            int n = sparkMajorVersion;
            switch (n) {
                case 2: 
                case 3: {
                    if (new File(sparkHome, "RELEASE").isFile()) {
                        file = new File(sparkHome, "jars");
                        break;
                    }
                    if (new File(sparkHome, "assembly/target/scala-2.11/jars").isDirectory()) {
                        file = new File(sparkHome, "assembly/target/scala-2.11/jars");
                        break;
                    }
                    file = new File(sparkHome, "assembly/target/scala-2.12/jars");
                    break;
                }
                default: {
                    throw new RuntimeException(new StringBuilder(33).append("Unsupported Spark major version: ").append(sparkMajorVersion).toString());
                }
            }
            File libdir = file;
            Seq seq2 = jars = !libdir.isDirectory() ? (Seq)Nil$.MODULE$ : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])libdir.listFiles())).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)InteractiveSession$.$anonfun$prepareBuilderProp$12(x$9))))).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.getAbsolutePath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSeq();
            if (jars.isEmpty()) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "datanucleus jars can not be found");
            }
            seq = jars;
        }
        return seq;
    }

    public static final /* synthetic */ boolean $anonfun$prepareBuilderProp$15(String x$11) {
        Object object = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$11.split("/"))).last();
        String string = "hive-site.xml";
        return !(object != null ? !object.equals(string) : string != null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Tuple2 hiveSiteFile$1(String[] sparkFiles, LivyConf livyConf) {
        Tuple2 tuple2;
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkFiles)).exists((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)InteractiveSession$.$anonfun$prepareBuilderProp$15(x$11)))) {
            tuple2 = new Tuple2((Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)true));
            return tuple2;
        }
        URL hiveSiteURL = this.getClass().getResource("/hive-site.xml");
        if (hiveSiteURL != null) {
            String string = hiveSiteURL.getProtocol();
            String string2 = "file";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                tuple2 = new Tuple2((Object)new Some((Object)new File(hiveSiteURL.toURI())), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                return tuple2;
            }
        }
        tuple2 = new Tuple2((Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        return tuple2;
    }

    private static final Seq findPySparkArchives$1(LivyConf livyConf$2) {
        return (Seq)Option$.MODULE$.apply((Object)livyConf$2.get((ClientConf.ConfEntry)RSCConf.Entry.PYSPARK_ARCHIVES)).map((Function1 & Serializable & scala.Serializable)x$12 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$12.split(","))).toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)package$.MODULE$.env().get((Object)"SPARK_HOME").map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Seq seq;
            String string = x0$1;
            String pyLibPath = ((TraversableOnce)new .colon.colon((Object)string, (List)new .colon.colon((Object)"python", (List)new .colon.colon((Object)"lib", (List)Nil$.MODULE$)))).mkString(File.separator);
            File pyArchivesFile = new File(pyLibPath, "pyspark.zip");
            File py4jFile = null;
            try (DirectoryStream<java.nio.file.Path> py4jZip = null;){
                py4jZip = Files.newDirectoryStream(Paths.get(pyLibPath, new String[0]), "py4j-*-src.zip");
                py4jFile = py4jZip.iterator().next().toFile();
            }
            if (!pyArchivesFile.exists()) {
                MODULE$.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "pyspark.zip not found; cannot start pyspark interpreter.");
                seq = (Seq)Nil$.MODULE$;
            } else if (!py4jFile.exists()) {
                MODULE$.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "py4j-*-src.zip not found; can start pyspark interpreter.");
                seq = (Seq)Nil$.MODULE$;
            } else {
                seq = (Seq)new .colon.colon((Object)pyArchivesFile.getAbsolutePath(), (List)new .colon.colon((Object)py4jFile.getAbsolutePath(), (List)Nil$.MODULE$));
            }
            Seq seq2 = seq;
            return seq2;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$));
    }

    private static final void mergeConfList$1(Seq list, String key, scala.collection.mutable.Map builderProperties$2) {
        if (list.nonEmpty()) {
            Option option = builderProperties$2.get((Object)key);
            if (None$.MODULE$.equals(option)) {
                builderProperties$2.put((Object)key, (Object)list.mkString(","));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (option instanceof Some) {
                String oldList;
                Some some = (Some)option;
                String string = oldList = (String)some.value();
                String newList = list.toList().$colon$colon((Object)string).mkString(",");
                builderProperties$2.put((Object)key, (Object)newList);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void mergeHiveSiteAndHiveDeps$1(int sparkMajorVersion, scala.collection.immutable.Map conf$1, LivyConf livyConf$2, scala.collection.mutable.Map builderProperties$2) {
        boolean bl;
        String[] sparkFiles = (String[])conf$1.get((Object)"spark.files").map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.split(",")).getOrElse((Function0 & Serializable & scala.Serializable)() -> (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
        Tuple2 tuple2 = this.hiveSiteFile$1(sparkFiles, livyConf$2);
        if (tuple2 != null && (bl = tuple2._2$mcZ$sp())) {
            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Enable HiveContext because hive-site.xml is found in user request.");
            InteractiveSession$.mergeConfList$1(this.datanucleusJars$1(livyConf$2, sparkMajorVersion), LivyConf$.MODULE$.SPARK_JARS(), builderProperties$2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            boolean bl2 = tuple2._2$mcZ$sp();
            if (option instanceof Some) {
                Some some = (Some)option;
                File file = (File)some.value();
                if (!bl2) {
                    this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Enable HiveContext because hive-site.xml is found under classpath, ").append(file.getAbsolutePath()).toString());
                    InteractiveSession$.mergeConfList$1((Seq)new .colon.colon((Object)file.getAbsolutePath(), (List)Nil$.MODULE$), LivyConf$.MODULE$.SPARK_FILES(), builderProperties$2);
                    InteractiveSession$.mergeConfList$1(this.datanucleusJars$1(livyConf$2, sparkMajorVersion), LivyConf$.MODULE$.SPARK_JARS(), builderProperties$2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Option option = (Option)tuple2._1();
        boolean bl3 = tuple2._2$mcZ$sp();
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple2);
        if (false != bl3) throw new MatchError((Object)tuple2);
        this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Enable HiveContext but no hive-site.xml found under classpath or user request.");
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$prepareBuilderProp$30(scala.collection.mutable.Map builderProperties$2, Map.Entry e) {
        block1: {
            Tuple2 tuple2 = new Tuple2(e.getKey(), e.getValue());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)key, (Object)value);
            Tuple2 tuple23 = tuple22;
            String key2 = (String)tuple23._1();
            String value2 = (String)tuple23._2();
            if (!key2.startsWith("livy.rsc.") || builderProperties$2.contains((Object)key2)) break block1;
            builderProperties$2.update((Object)key2, (Object)value2);
        }
    }

    private InteractiveSession$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.SPARK_YARN_IS_PYTHON = "spark.yarn.isPython";
        this.RECOVERY_SESSION_TYPE = "interactive";
    }
}

