/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.test;

import java.io.PrintStream;
import org.apache.ignite.internal.util.test.GridTestPrintStream;

public final class GridTestPrintStreamFactory {
    private static final PrintStream sysOut = System.out;
    private static final PrintStream sysErr = System.err;
    private static GridTestPrintStream testOut;
    private static GridTestPrintStream testErr;
    private static long outCnt;
    private static long errCnt;

    private GridTestPrintStreamFactory() {
    }

    public static synchronized PrintStream getStdOut() {
        return sysOut;
    }

    public static synchronized PrintStream getStdErr() {
        return sysErr;
    }

    public static synchronized GridTestPrintStream acquireOut() {
        if (testOut == null) {
            testOut = new GridTestPrintStream(sysOut);
        }
        if (outCnt == 0L) {
            System.setOut(testOut);
        }
        ++outCnt;
        return testOut;
    }

    public static synchronized GridTestPrintStream acquireErr() {
        if (testErr == null) {
            testErr = new GridTestPrintStream(sysErr);
        }
        if (errCnt == 0L) {
            System.setErr(testErr);
        }
        ++errCnt;
        return testErr;
    }

    public static synchronized void releaseOut() {
        if (--outCnt == 0L) {
            System.setOut(sysOut);
        }
    }

    public static synchronized void releaseErr() {
        if (--errCnt == 0L) {
            System.setErr(sysErr);
        }
    }

    static {
        outCnt = 0L;
        errCnt = 0L;
    }
}

