/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.eventlog.event;

import java.util.Map;
import org.apache.ignite3.internal.eventlog.api.Event;
import org.apache.ignite3.internal.eventlog.event.EventImpl;
import org.apache.ignite3.internal.eventlog.event.EventTypeRegistry;
import org.apache.ignite3.internal.eventlog.event.EventUser;
import org.apache.ignite3.internal.eventlog.event.exception.InvalidEventTypeException;
import org.apache.ignite3.internal.eventlog.event.exception.InvalidProductVersionException;
import org.apache.ignite3.internal.eventlog.event.exception.MissingEventTypeException;
import org.apache.ignite3.internal.eventlog.event.exception.MissingEventUserException;
import org.apache.ignite3.internal.properties.IgniteProductVersion;

public class EventBuilder {
    private static final String DEFAULT_VERSION = IgniteProductVersion.CURRENT_VERSION.toString();
    private String type;
    private long timestamp;
    private String productVersion;
    private EventUser user;
    private Map<String, Object> fields;

    public EventBuilder type(String type) {
        this.type = type;
        return this;
    }

    public EventBuilder timestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public EventBuilder productVersion(String productVersion) {
        this.productVersion = productVersion;
        return this;
    }

    public EventBuilder user(EventUser user) {
        this.user = user;
        return this;
    }

    public EventBuilder fields(Map<String, Object> fields) {
        this.fields = fields;
        return this;
    }

    public Event build() {
        if (this.type == null) {
            throw new MissingEventTypeException();
        }
        if (!EventTypeRegistry.contains(this.type)) {
            throw new InvalidEventTypeException(this.type);
        }
        if (this.user == null) {
            throw new MissingEventUserException();
        }
        if (this.productVersion == null) {
            this.productVersion = DEFAULT_VERSION;
        }
        if (!IgniteProductVersion.VERSION_PATTERN.matcher(this.productVersion).matches()) {
            throw new InvalidProductVersionException(this.productVersion);
        }
        if (this.fields == null) {
            this.fields = Map.of();
        }
        if (this.timestamp == 0L) {
            this.timestamp = System.currentTimeMillis();
        }
        return new EventImpl(this.type, this.timestamp, this.productVersion, this.user, this.fields);
    }
}

