/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.trait;

import java.util.List;
import java.util.Set;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.trait.Destination;

public class Identity<RowT>
implements Destination<RowT> {
    private final RowHandler<RowT> rowHandler;
    private final Set<String> nodes;
    private final int columnIndex;

    public Identity(RowHandler<RowT> rowHandler, int columnIndex, List<String> nodes) {
        this.rowHandler = rowHandler;
        this.columnIndex = columnIndex;
        this.nodes = Set.copyOf(nodes);
    }

    @Override
    public List<String> targets(RowT row) {
        Object node = this.rowHandler.get(this.columnIndex, row);
        if (node instanceof String && this.nodes.contains(node)) {
            return List.of((String)node);
        }
        throw new IllegalStateException("No target found.");
    }

    public Set<String> targets() {
        return this.nodes;
    }
}

