/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.apache.ignite.internal.network.LocalIpAddresses;
import org.apache.ignite.network.NetworkAddress;
import org.jetbrains.annotations.Nullable;

class RecipientInetAddress {
    private static final RecipientInetAddress SELF = new RecipientInetAddress(null);
    @Nullable
    private final InetSocketAddress address;

    private RecipientInetAddress(@Nullable InetSocketAddress address) {
        this.address = address;
    }

    @Nullable
    InetSocketAddress address() {
        return this.address;
    }

    static RecipientInetAddress create(InetSocketAddress localBindAddress, NetworkAddress recipientAddress, LocalIpAddresses localIpAddresses) {
        if (localBindAddress.getPort() != recipientAddress.port()) {
            return new RecipientInetAddress(RecipientInetAddress.createResolved(recipientAddress));
        }
        if (Objects.equals(localBindAddress.getHostName(), recipientAddress.host())) {
            return SELF;
        }
        InetSocketAddress resolvedRecipientAddress = RecipientInetAddress.createResolved(recipientAddress);
        InetAddress recipientInetAddress = resolvedRecipientAddress.getAddress();
        if (Objects.equals(localBindAddress.getAddress(), recipientInetAddress)) {
            return SELF;
        }
        if (recipientInetAddress.isAnyLocalAddress() || recipientInetAddress.isLoopbackAddress()) {
            return SELF;
        }
        if (localIpAddresses.isLocal(recipientInetAddress)) {
            return SELF;
        }
        return new RecipientInetAddress(resolvedRecipientAddress);
    }

    private static InetSocketAddress createResolved(NetworkAddress address) {
        return new InetSocketAddress(address.host(), address.port());
    }
}

