/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.sql;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlDrop;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;

public class IgniteSqlDropIndex
extends SqlDrop {
    private final SqlIdentifier name;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("DROP INDEX", SqlKind.DROP_INDEX);

    public IgniteSqlDropIndex(SqlParserPos pos, boolean ifExists, SqlIdentifier idxName) {
        super(OPERATOR, pos, ifExists);
        this.name = Objects.requireNonNull(idxName, "index name");
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword(this.getOperator().getName());
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
    }

    public SqlIdentifier name() {
        return this.name;
    }

    public boolean ifExists() {
        return this.ifExists;
    }
}

