/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.NoSuchElementException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.lang.GridIteratorAdapter;

public abstract class GridCloseableIteratorAdapter<T>
extends GridIteratorAdapter<T>
implements GridCloseableIterator<T> {
    private static final long serialVersionUID = 0L;
    private boolean closed;

    @Override
    public final T nextX() throws IgniteCheckedException {
        if (!this.hasNextX()) {
            this.checkClosed();
            throw new NoSuchElementException();
        }
        return this.onNext();
    }

    protected abstract T onNext() throws IgniteCheckedException;

    @Override
    public final boolean hasNextX() throws IgniteCheckedException {
        return !this.closed && this.onHasNext();
    }

    protected abstract boolean onHasNext() throws IgniteCheckedException;

    @Override
    public final void removeX() throws IgniteCheckedException {
        this.checkClosed();
        this.onRemove();
    }

    protected void onRemove() throws IgniteCheckedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void close() throws IgniteCheckedException {
        if (!this.closed) {
            this.onClose();
            this.closed = true;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    protected void onClose() throws IgniteCheckedException {
    }

    protected final void checkClosed() throws NoSuchElementException {
        if (this.closed) {
            throw new NoSuchElementException("Iterator has been closed.");
        }
    }
}

