/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat.config;

import java.io.Serializable;
import java.util.Objects;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsColumnOverrides;
import org.apache.ignite.internal.util.typedef.internal.S;

public class StatisticsColumnConfiguration
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final String name;
    private final long ver;
    private final boolean tombstone;
    private final StatisticsColumnOverrides overrides;

    public StatisticsColumnConfiguration(String name, StatisticsColumnOverrides overrides) {
        this(name, 1L, false, overrides);
    }

    private StatisticsColumnConfiguration(String name, long ver, boolean tombstone, StatisticsColumnOverrides overrides) {
        this.name = name;
        this.ver = ver;
        this.tombstone = tombstone;
        this.overrides = overrides;
    }

    private StatisticsColumnConfiguration(StatisticsColumnConfiguration cfg, long ver, boolean tombstone, StatisticsColumnOverrides overrides) {
        this.name = cfg.name;
        this.ver = ver;
        this.tombstone = tombstone;
        this.overrides = overrides;
    }

    public String name() {
        return this.name;
    }

    public long version() {
        return this.ver;
    }

    public boolean tombstone() {
        return this.tombstone;
    }

    public StatisticsColumnOverrides overrides() {
        return this.overrides;
    }

    public static StatisticsColumnConfiguration merge(StatisticsColumnConfiguration oldCfg, StatisticsColumnConfiguration newCfg) {
        if (oldCfg == null) {
            return newCfg;
        }
        return new StatisticsColumnConfiguration(newCfg, oldCfg.ver + 1L, false, newCfg.overrides);
    }

    public StatisticsColumnConfiguration createTombstone() {
        if (this.tombstone) {
            return this;
        }
        return new StatisticsColumnConfiguration(this, this.ver + 1L, true, this.overrides);
    }

    public StatisticsColumnConfiguration refresh() {
        return new StatisticsColumnConfiguration(this, this.tombstone ? this.ver : this.ver + 1L, this.tombstone, this.overrides);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatisticsColumnConfiguration that = (StatisticsColumnConfiguration)o;
        return this.ver == that.ver && this.tombstone == that.tombstone && Objects.equals(this.name, that.name) && Objects.equals(this.overrides, that.overrides);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.ver, this.tombstone, this.overrides);
    }

    public String toString() {
        return S.toString(StatisticsColumnConfiguration.class, this);
    }
}

