/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.HashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.text.similarity.IntersectionResult;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class IntersectionResultTest {
    IntersectionResultTest() {
    }

    @Test
    void testEquals() {
        IntersectionResult[] results = new IntersectionResult[]{new IntersectionResult(0, 0, 0), new IntersectionResult(10, 0, 0), new IntersectionResult(10, 10, 0), new IntersectionResult(10, 10, 10)};
        Assertions.assertEquals((Object)results[0], (Object)new IntersectionResult(0, 0, 0));
        Object something = new Object();
        for (int i = 0; i < results.length; ++i) {
            Assertions.assertNotEquals((Object)results[i], (Object)something);
            Assertions.assertNotEquals(null, (Object)results[i]);
            for (int j = 0; j < results.length; ++j) {
                Assertions.assertEquals((Object)results[i].equals((Object)results[j]), (Object)(i == j ? 1 : 0));
            }
        }
    }

    @Test
    void testHashCode() {
        int i;
        IntersectionResult[] results = new IntersectionResult[]{new IntersectionResult(10, 0, 0), new IntersectionResult(10, 10, 0), new IntersectionResult(10, 10, 10)};
        HashMap<IntersectionResult, Integer> map = new HashMap<IntersectionResult, Integer>();
        int offset = 123;
        for (i = 0; i < results.length; ++i) {
            map.put(results[i], i + 123);
        }
        for (i = 0; i < results.length; ++i) {
            Assertions.assertEquals((int)(i + 123), (Integer)((Integer)map.get(results[i])));
        }
    }

    @Test
    void testNewIntersectionResult_WithIntersectionAboveSizeAorB() {
        boolean sizeA = true;
        int sizeB = 2;
        int intersection = Math.max(1, 2) + 1;
        Assertions.assertThrows(IllegalArgumentException.class, () -> new IntersectionResult(1, 2, intersection));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new IntersectionResult(2, 1, intersection));
    }

    @Test
    void testNewIntersectionResult_WithNegativeIntersection() {
        boolean sizeA = false;
        boolean sizeB = false;
        int intersection = -1;
        Assertions.assertThrows(IllegalArgumentException.class, () -> new IntersectionResult(0, 0, -1));
    }

    @Test
    void testNewIntersectionResult_WithNegativeSizeA() {
        int sizeA = -1;
        boolean sizeB = false;
        boolean intersection = false;
        Assertions.assertThrows(IllegalArgumentException.class, () -> new IntersectionResult(-1, 0, 0));
    }

    @Test
    void testNewIntersectionResult_WithNegativeSizeB() {
        boolean sizeA = false;
        int sizeB = -1;
        boolean intersection = false;
        Assertions.assertThrows(IllegalArgumentException.class, () -> new IntersectionResult(0, -1, 0));
    }

    @Test
    void testNewIntersectionResult_WithZeros() {
        boolean sizeA = false;
        boolean sizeB = false;
        boolean intersection = false;
        new IntersectionResult(0, 0, 0);
    }

    @Test
    void testProperties() {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        int max = 1024;
        for (int i = 0; i < 5; ++i) {
            int sizeA = rand.nextInt(1024) + 1;
            int sizeB = rand.nextInt(1024) + 1;
            int intersection = rand.nextInt(Math.min(sizeA, sizeB));
            IntersectionResult result = new IntersectionResult(sizeA, sizeB, intersection);
            Assertions.assertEquals((int)sizeA, (int)result.getSizeA());
            Assertions.assertEquals((int)sizeB, (int)result.getSizeB());
            Assertions.assertEquals((int)intersection, (int)result.getIntersection());
        }
    }

    @Test
    void testToString() {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        int max = 9;
        for (int i = 0; i < 5; ++i) {
            int sizeA = rand.nextInt(9) + 1;
            int sizeB = rand.nextInt(9) + 1;
            int intersection = rand.nextInt(Math.min(sizeA, sizeB));
            IntersectionResult result = new IntersectionResult(sizeA, sizeB, intersection);
            String string = result.toString();
            Assertions.assertTrue((boolean)string.contains(String.valueOf(sizeA)));
            Assertions.assertTrue((boolean)string.contains(String.valueOf(sizeB)));
            Assertions.assertTrue((boolean)string.contains(String.valueOf(intersection)));
        }
    }
}

