/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.jxpath.NodeSet;
import org.apache.commons.jxpath.Pointer;

public class BasicNodeSet
implements NodeSet {
    private final List<Pointer> pointers = new ArrayList<Pointer>();
    private List<Pointer> readOnlyPointers;
    private List nodes;
    private List values;

    public void add(NodeSet nodeSet) {
        if (this.pointers.addAll(nodeSet.getPointers())) {
            this.clear();
        }
    }

    public void add(Pointer pointer) {
        if (this.pointers.add(pointer)) {
            this.clear();
        }
    }

    private synchronized void clear() {
        this.readOnlyPointers = null;
        this.nodes = null;
        this.values = null;
    }

    @Override
    public synchronized List getNodes() {
        if (this.nodes == null) {
            this.nodes = Collections.unmodifiableList(this.pointers.stream().map(Pointer::getNode).collect(Collectors.toList()));
        }
        return this.nodes;
    }

    @Override
    public synchronized List<Pointer> getPointers() {
        if (this.readOnlyPointers == null) {
            this.readOnlyPointers = Collections.unmodifiableList(this.pointers);
        }
        return this.readOnlyPointers;
    }

    @Override
    public synchronized List getValues() {
        if (this.values == null) {
            this.values = Collections.unmodifiableList(this.pointers.stream().map(Pointer::getValue).collect(Collectors.toList()));
        }
        return this.values;
    }

    public void remove(Pointer pointer) {
        if (this.pointers.remove(pointer)) {
            this.clear();
        }
    }

    public String toString() {
        return this.pointers.toString();
    }
}

