/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni;

import java.io.IOException;
import java.util.Arrays;
import org.apache.trevni.BlockDescriptor;
import org.apache.trevni.Checksum;
import org.apache.trevni.ColumnMetaData;
import org.apache.trevni.Input;
import org.apache.trevni.InputBuffer;

class ColumnDescriptor<T extends Comparable> {
    final Input file;
    final ColumnMetaData metaData;
    long start;
    long dataStart;
    BlockDescriptor[] blocks;
    long[] blockStarts;
    long[] firstRows;
    T[] firstValues;

    public ColumnDescriptor(Input file, ColumnMetaData metaData) {
        this.file = file;
        this.metaData = metaData;
    }

    public int findBlock(long row) {
        int block = Arrays.binarySearch(this.firstRows, row);
        if (block < 0) {
            block = -block - 2;
        }
        return block;
    }

    public int findBlock(T value) {
        int block = Arrays.binarySearch(this.firstValues, value);
        if (block < 0) {
            block = -block - 2;
        }
        return block;
    }

    public int blockCount() {
        return this.blocks.length;
    }

    public long lastRow(int block) {
        if (this.blocks.length == 0 || block < 0) {
            return 0L;
        }
        return this.firstRows[block] + (long)this.blocks[block].rowCount;
    }

    public void ensureBlocksRead() throws IOException {
        if (this.blocks != null) {
            return;
        }
        InputBuffer in = new InputBuffer(this.file, this.start);
        int blockCount = in.readFixed32();
        BlockDescriptor[] blocks = new BlockDescriptor[blockCount];
        if (this.metaData.hasIndexValues()) {
            this.firstValues = new Comparable[blockCount];
        }
        for (int i = 0; i < blockCount; ++i) {
            blocks[i] = BlockDescriptor.read(in);
            if (!this.metaData.hasIndexValues()) continue;
            this.firstValues[i] = in.readValue(this.metaData.getType());
        }
        this.dataStart = in.tell();
        Checksum checksum = Checksum.get(this.metaData);
        this.blockStarts = new long[blocks.length];
        this.firstRows = new long[blocks.length];
        long startPosition = this.dataStart;
        long row = 0L;
        for (int i = 0; i < blockCount; ++i) {
            BlockDescriptor b = blocks[i];
            this.blockStarts[i] = startPosition;
            this.firstRows[i] = row;
            startPosition += (long)(b.compressedSize + checksum.size());
            row += (long)b.rowCount;
        }
        this.blocks = blocks;
    }
}

