/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sns.model.SetEndpointAttributesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Map;

public class SetEndpointAttributesRequestMarshaller
implements Marshaller<Request<SetEndpointAttributesRequest>, SetEndpointAttributesRequest> {
    public Request<SetEndpointAttributesRequest> marshall(SetEndpointAttributesRequest setEndpointAttributesRequest) {
        if (setEndpointAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setEndpointAttributesRequest, "AmazonSNS");
        request.addParameter("Action", "SetEndpointAttributes");
        request.addParameter("Version", "2010-03-31");
        if (setEndpointAttributesRequest.getEndpointArn() != null) {
            request.addParameter("EndpointArn", StringUtils.fromString((String)setEndpointAttributesRequest.getEndpointArn()));
        }
        if (setEndpointAttributesRequest != null && setEndpointAttributesRequest.getAttributes() != null) {
            int attributesListIndex = 1;
            for (Map.Entry<String, String> attributesListValue : setEndpointAttributesRequest.getAttributes().entrySet()) {
                if (attributesListValue.getKey() != null) {
                    request.addParameter("Attributes.entry." + attributesListIndex + ".key", StringUtils.fromString((String)attributesListValue.getKey()));
                }
                if (attributesListValue.getValue() != null) {
                    request.addParameter("Attributes.entry." + attributesListIndex + ".value", StringUtils.fromString((String)attributesListValue.getValue()));
                }
                ++attributesListIndex;
            }
        }
        return request;
    }
}

