/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.mapping.xsem;

import org.compass.core.converter.ConversionException;
import org.compass.core.mapping.xsem.XPathEnabledMapping;
import org.compass.core.xml.XmlObject;
import org.compass.core.xml.XmlXPathExpression;

public abstract class XmlConverterUtils {
    public static XmlObject[] select(XmlObject xmlObject, XPathEnabledMapping xpathMapping) throws ConversionException {
        if (xpathMapping.getXPathExpression() != null) {
            try {
                return xpathMapping.getXPathExpression().select(xmlObject);
            }
            catch (Exception e) {
                throw new ConversionException("Failed to select xpath [" + xpathMapping.getXPath() + "]", e);
            }
        }
        if (xmlObject.canCompileXpath()) {
            XmlXPathExpression xPathExpression;
            try {
                xPathExpression = xmlObject.compile(xpathMapping.getXPath());
            }
            catch (Exception e) {
                throw new ConversionException("Failed to compile xpath [" + xpathMapping.getXPath() + "]", e);
            }
            xpathMapping.setXPathExpression(xPathExpression);
            try {
                return xPathExpression.select(xmlObject);
            }
            catch (Exception e) {
                throw new ConversionException("Failed to select xpath [" + xpathMapping.getXPath() + "]", e);
            }
        }
        try {
            return xmlObject.selectPath(xpathMapping.getXPath());
        }
        catch (Exception e) {
            throw new ConversionException("Failed to select xpath [" + xpathMapping.getXPath() + "]", e);
        }
    }
}

