/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core;

import java.io.Serializable;
import org.compass.core.util.Parameter;

public interface Property
extends Serializable {
    public String getName();

    public String getStringValue();

    public Object getObjectValue();

    public byte[] getBinaryValue();

    public float getBoost();

    public void setBoost(float var1);

    public boolean isIndexed();

    public boolean isStored();

    public boolean isCompressed();

    public boolean isTokenized();

    public boolean isTermVectorStored();

    public boolean isBinary();

    public boolean isOmitNorms();

    public void setOmitNorms(boolean var1);

    public static final class TermVector
    extends Parameter {
        private static final long serialVersionUID = 3256728372590948921L;
        public static final TermVector NO = new TermVector("NO");
        public static final TermVector YES = new TermVector("YES");
        public static final TermVector WITH_POSITIONS = new TermVector("WITH_POSITIONS");
        public static final TermVector WITH_OFFSETS = new TermVector("WITH_OFFSETS");
        public static final TermVector WITH_POSITIONS_OFFSETS = new TermVector("WITH_POSITIONS_OFFSETS");

        private TermVector(String name) {
            super(name);
        }

        public static String toString(TermVector propertyTermVector) {
            if (propertyTermVector == NO) {
                return "no";
            }
            if (propertyTermVector == YES) {
                return "yes";
            }
            if (propertyTermVector == WITH_POSITIONS) {
                return "positions";
            }
            if (propertyTermVector == WITH_OFFSETS) {
                return "offsets";
            }
            if (propertyTermVector == WITH_POSITIONS_OFFSETS) {
                return "positions_offsets";
            }
            throw new IllegalArgumentException("Can't find property term vector for [" + propertyTermVector + "]");
        }

        public static TermVector fromString(String propertyTermVector) {
            if (propertyTermVector == null || "na".equalsIgnoreCase(propertyTermVector)) {
                return null;
            }
            if ("no".equalsIgnoreCase(propertyTermVector)) {
                return NO;
            }
            if ("yes".equalsIgnoreCase(propertyTermVector)) {
                return YES;
            }
            if ("positions".equalsIgnoreCase(propertyTermVector)) {
                return WITH_POSITIONS;
            }
            if ("offsets".equalsIgnoreCase(propertyTermVector)) {
                return WITH_OFFSETS;
            }
            if ("positions_offsets".equalsIgnoreCase(propertyTermVector)) {
                return WITH_POSITIONS_OFFSETS;
            }
            throw new IllegalArgumentException("Can't find property term vector for [" + propertyTermVector + "]");
        }
    }

    public static final class Index
    extends Parameter {
        private static final long serialVersionUID = 3761973756863985718L;
        public static final Index NO = new Index("NO");
        public static final Index TOKENIZED = new Index("TOKENIZED");
        public static final Index UN_TOKENIZED = new Index("UN_TOKENIZED");

        private Index(String name) {
            super(name);
        }

        public static String toString(Index propertyIndex) {
            if (propertyIndex == NO) {
                return "no";
            }
            if (propertyIndex == TOKENIZED) {
                return "tokenized";
            }
            if (propertyIndex == UN_TOKENIZED) {
                return "un_tokenized";
            }
            throw new IllegalArgumentException("Can't find property index for [" + propertyIndex + "]");
        }

        public static Index fromString(String propertyIndex) {
            if (propertyIndex == null || "na".equalsIgnoreCase(propertyIndex)) {
                return null;
            }
            if ("no".equalsIgnoreCase(propertyIndex)) {
                return NO;
            }
            if ("tokenized".equalsIgnoreCase(propertyIndex)) {
                return TOKENIZED;
            }
            if ("un_tokenized".equalsIgnoreCase(propertyIndex)) {
                return UN_TOKENIZED;
            }
            throw new IllegalArgumentException("Can't find property index for [" + propertyIndex + "]");
        }
    }

    public static final class Store
    extends Parameter {
        private static final long serialVersionUID = 3833746603143278642L;
        public static final Store NO = new Store("NO");
        public static final Store YES = new Store("YES");
        public static final Store COMPRESS = new Store("COMPRESS");

        private Store(String name) {
            super(name);
        }

        public static String toString(Store propertyStore) {
            if (propertyStore == NO) {
                return "no";
            }
            if (propertyStore == YES) {
                return "yes";
            }
            if (propertyStore == COMPRESS) {
                return "compress";
            }
            throw new IllegalArgumentException("Can't find property store for [" + propertyStore + "]");
        }

        public static Store fromString(String propertyStore) {
            if (propertyStore == null || "na".equalsIgnoreCase(propertyStore)) {
                return null;
            }
            if ("no".equalsIgnoreCase(propertyStore)) {
                return NO;
            }
            if ("yes".equalsIgnoreCase(propertyStore)) {
                return YES;
            }
            if ("compress".equalsIgnoreCase(propertyStore)) {
                return COMPRESS;
            }
            throw new IllegalArgumentException("Can't find property store for [" + propertyStore + "]");
        }
    }
}

