/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.canl;

import eu.emi.security.authn.x509.CrlCheckingMode;
import eu.emi.security.authn.x509.NamespaceCheckingMode;
import eu.emi.security.authn.x509.OCSPCheckingMode;
import eu.emi.security.authn.x509.OCSPParametes;
import eu.emi.security.authn.x509.ProxySupport;
import eu.emi.security.authn.x509.RevocationParameters;
import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import eu.emi.security.authn.x509.impl.CRLParameters;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.DirectoryCertChainValidator;
import eu.emi.security.authn.x509.impl.KeystoreCertChainValidator;
import eu.emi.security.authn.x509.impl.KeystoreCredential;
import eu.emi.security.authn.x509.impl.OpensslCertChainValidator;
import eu.emi.security.authn.x509.impl.RevocationParametersExt;
import eu.emi.security.authn.x509.impl.ValidatorParams;
import eu.emi.security.authn.x509.impl.ValidatorParamsExt;
import eu.unicore.security.canl.PasswordCallback;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.PropertiesHelper;
import eu.unicore.util.configuration.PropertyChangeListener;
import eu.unicore.util.configuration.PropertyMD;
import java.io.File;
import java.io.IOException;
import java.security.KeyStoreException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class TrustedIssuersProperties
extends PropertiesHelper {
    private static final Logger log = Log.getLogger("unicore.configuration", TrustedIssuersProperties.class);
    public static final String DEFAULT_PREFIX = "trustedIssuers.";
    public static final String PROP_TYPE = "type";
    public static final String PROP_UPDATE = "updateInterval";
    public static final String PROP_KS_PATH = "keystorePath";
    public static final String PROP_KS_PASSWORD = "keystorePassword";
    public static final String PROP_KS_TYPE = "keystoreFormat";
    public static final String PROP_OPENSSL_DIR = "opensslPath";
    public static final String PROP_OPENSSL_NEW_STORE_FORMAT = "opensslNewStoreFormat";
    public static final String PROP_DIRECTORY_LOCATIONS = "directoryLocations.";
    public static final String PROP_DIRECTORY_ENCODING = "directoryEncoding";
    public static final String PROP_DIRECTORY_CONNECTION_TIMEOUT = "directoryConnectionTimeout";
    public static final String PROP_DIRECTORY_CACHE_PATH = "directoryDiskCachePath";
    private static final String[] UPDATEABLE_PROPS = new String[]{"updateInterval", "directoryLocations."};
    protected Collection<? extends StoreUpdateListener> initialListeners;
    protected OpensslCertChainValidator opensslValidator = null;
    protected DirectoryCertChainValidator directoryValidator = null;
    protected KeystoreCertChainValidator ksValidator = null;
    public static final Map<String, PropertyMD> META = new HashMap<String, PropertyMD>();
    protected TruststoreType type;
    protected long storeUpdateInterval;
    protected String opensslDir;
    protected boolean opensslNewStoreFormat;
    protected CertificateUtils.Encoding directoryEncoding;
    protected List<String> directoryLocations;
    protected int caConnectionTimeout;
    protected String caDiskCache;
    protected String ksPath;
    protected String ksType;
    protected PasswordCallback passwordCallback;

    public TrustedIssuersProperties(Properties properties, Collection<? extends StoreUpdateListener> initialListeners) throws ConfigurationException {
        this(properties, initialListeners, null, DEFAULT_PREFIX);
    }

    public TrustedIssuersProperties(Properties properties, Collection<? extends StoreUpdateListener> initialListeners, PasswordCallback callback) throws ConfigurationException {
        this(properties, initialListeners, callback, DEFAULT_PREFIX);
    }

    public TrustedIssuersProperties(Properties properties, Collection<? extends StoreUpdateListener> initialListeners, String pfx) throws ConfigurationException {
        this(properties, initialListeners, null, pfx);
    }

    public TrustedIssuersProperties(Properties properties, Collection<? extends StoreUpdateListener> initialListeners, PasswordCallback callback, String pfx) throws ConfigurationException {
        this(META, log, properties, initialListeners, callback, pfx);
    }

    protected TrustedIssuersProperties(Map<String, PropertyMD> META, Logger log, Properties properties, Collection<? extends StoreUpdateListener> initialListeners, PasswordCallback callback, String pfx) throws ConfigurationException {
        super(pfx, properties, META, log);
        this.initialListeners = initialListeners;
        this.passwordCallback = callback;
        this.createValidatorSafe();
        this.addPropertyChangeListener(new PropertyChangeListenerImpl());
    }

    public X509CertChainValidatorExt getValidator() {
        if (this.type.equals((Object)TruststoreType.keystore)) {
            return this.ksValidator;
        }
        if (this.type.equals((Object)TruststoreType.openssl)) {
            return this.opensslValidator;
        }
        if (this.type.equals((Object)TruststoreType.directory)) {
            return this.directoryValidator;
        }
        throw new RuntimeException("BUG: not all truststore types are handled in the code");
    }

    protected void update(String property) throws ConfigurationException {
        List<String> newDirectoryLocations;
        long newUpdateInterval;
        if (property.equals(PROP_UPDATE) && (newUpdateInterval = this.getLongValue(PROP_UPDATE).longValue()) != this.storeUpdateInterval) {
            if (this.opensslValidator != null) {
                this.opensslValidator.setUpdateInterval(newUpdateInterval * 1000L);
            }
            if (this.directoryValidator != null) {
                this.directoryValidator.setTruststoreUpdateInterval(newUpdateInterval * 1000L);
            }
            if (this.ksValidator != null) {
                this.ksValidator.setTruststoreUpdateInterval(newUpdateInterval * 1000L);
            }
            this.storeUpdateInterval = newUpdateInterval;
            log.info("Updated " + this.prefix + PROP_UPDATE + " value to " + this.storeUpdateInterval);
        }
        if (this.opensslValidator != null) {
            return;
        }
        if (this.ksValidator != null) {
            return;
        }
        if (property.startsWith(PROP_DIRECTORY_LOCATIONS) && !(newDirectoryLocations = this.getListOfValues(PROP_DIRECTORY_LOCATIONS)).equals(this.directoryLocations)) {
            this.directoryValidator.setTruststorePaths(newDirectoryLocations);
            this.directoryLocations = newDirectoryLocations;
            log.info("Updated " + this.prefix + PROP_DIRECTORY_LOCATIONS);
        }
    }

    protected String[] getUpdateableProperties() {
        return UPDATEABLE_PROPS;
    }

    private void createValidatorSafe() throws ConfigurationException {
        try {
            this.createValidator();
        }
        catch (KeyStoreException e) {
            throw new ConfigurationException("There was a problem setting up the truststore of type " + (Object)((Object)this.type) + ": " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ConfigurationException("There was a problem setting up the truststore of type " + (Object)((Object)this.type) + ": " + e.getMessage(), e);
        }
    }

    protected void createValidator() throws ConfigurationException, KeyStoreException, IOException {
        this.type = this.getEnumValue(PROP_TYPE, TruststoreType.class);
        this.storeUpdateInterval = this.getLongValue(PROP_UPDATE);
        if (this.type.equals((Object)TruststoreType.keystore)) {
            this.ksValidator = this.getKeystoreValidator();
        } else if (this.type.equals((Object)TruststoreType.openssl)) {
            this.opensslValidator = this.getOpensslValidator();
        } else if (this.type.equals((Object)TruststoreType.directory)) {
            this.directoryValidator = this.getDirectoryValidator();
        }
    }

    protected DirectoryCertChainValidator getDirectoryValidator() throws ConfigurationException, KeyStoreException, IOException {
        this.directoryLocations = this.getListOfValues(PROP_DIRECTORY_LOCATIONS);
        this.directoryEncoding = this.getEnumValue(PROP_DIRECTORY_ENCODING, CertificateUtils.Encoding.class);
        this.caConnectionTimeout = this.getIntValue(PROP_DIRECTORY_CONNECTION_TIMEOUT);
        this.caDiskCache = this.getFileValueAsString(PROP_DIRECTORY_CACHE_PATH, true);
        ValidatorParamsExt params = this.getValidatorParamsExt();
        return new DirectoryCertChainValidator(this.directoryLocations, this.directoryEncoding, this.storeUpdateInterval * 1000L, this.caConnectionTimeout * 1000, this.caDiskCache, params);
    }

    protected OpensslCertChainValidator getOpensslValidator() throws ConfigurationException {
        this.opensslDir = this.getFileValueAsString(PROP_OPENSSL_DIR, true);
        this.opensslNewStoreFormat = this.getBooleanValue(PROP_OPENSSL_NEW_STORE_FORMAT);
        RevocationParameters revocationSettings = new RevocationParameters(CrlCheckingMode.IGNORE, this.getOCSPParameters());
        ValidatorParams params = new ValidatorParams(revocationSettings, ProxySupport.DENY, this.initialListeners);
        return new OpensslCertChainValidator(this.opensslDir, this.opensslNewStoreFormat, NamespaceCheckingMode.IGNORE, this.storeUpdateInterval * 1000L, params);
    }

    protected KeystoreCertChainValidator getKeystoreValidator() throws ConfigurationException, KeyStoreException, IOException {
        this.ksPath = this.getValue(PROP_KS_PATH);
        if (this.ksPath == null) {
            throw new ConfigurationException("Keystore path must be set, property: " + this.prefix + PROP_KS_PATH);
        }
        File ks = new File(this.ksPath);
        if (!(ks.exists() && ks.canRead() && ks.isFile())) {
            throw new ConfigurationException("Keystore specified in the property " + this.prefix + PROP_KS_PATH + " must be an EXISTING, READABLE file: " + this.ksPath);
        }
        boolean preferCallback = this.passwordCallback != null && this.passwordCallback.ignoreProperties();
        char[] ksPassword = null;
        if (!preferCallback) {
            String pass = this.getValue(PROP_KS_PASSWORD);
            char[] cArray = ksPassword = pass == null ? null : pass.toCharArray();
        }
        if (ksPassword == null && this.passwordCallback != null) {
            ksPassword = this.passwordCallback.getPassword("truststore", this.ksPath);
        }
        if (ksPassword == null) {
            throw new ConfigurationException("Keystore password must be set, property: " + this.prefix + PROP_KS_PASSWORD);
        }
        this.ksType = this.getValue(PROP_KS_TYPE);
        if (this.ksType == null) {
            this.autodetectKeystoreType(ksPassword);
        }
        ValidatorParamsExt params = this.getValidatorParamsExt();
        return new KeystoreCertChainValidator(this.ksPath, ksPassword, this.ksType, this.storeUpdateInterval * 1000L, params);
    }

    protected ValidatorParamsExt getValidatorParamsExt() {
        RevocationParametersExt revParams = new RevocationParametersExt(CrlCheckingMode.IGNORE, new CRLParameters(), this.getOCSPParameters());
        return new ValidatorParamsExt(revParams, ProxySupport.DENY, this.initialListeners);
    }

    protected OCSPParametes getOCSPParameters() {
        return new OCSPParametes(OCSPCheckingMode.IGNORE);
    }

    private void autodetectKeystoreType(char[] ksPassword) throws ConfigurationException {
        try {
            this.ksType = KeystoreCredential.autodetectType((String)this.ksPath, (char[])ksPassword);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConfigurationException("Truststore type is not set in the property " + this.prefix + PROP_KS_TYPE + " and its autodetection failed. Try to set it and also " + "review password and location - most probably those are wrong.");
        }
    }

    @Override
    public TrustedIssuersProperties clone() {
        TrustedIssuersProperties ret = new TrustedIssuersProperties(this.properties, this.initialListeners, this.passwordCallback, this.prefix);
        super.cloneTo(ret);
        return ret;
    }

    static {
        PropertyMD.DocumentationCategory dirCat = new PropertyMD.DocumentationCategory("Directory type settings", "1");
        PropertyMD.DocumentationCategory ksCat = new PropertyMD.DocumentationCategory("Keystore type settings", "2");
        PropertyMD.DocumentationCategory opensslCat = new PropertyMD.DocumentationCategory("Openssl type settings", "3");
        META.put(PROP_TYPE, new PropertyMD().setEnum(TruststoreType.directory).setMandatory().setDescription("The truststore type."));
        META.put(PROP_UPDATE, new PropertyMD("600").setLong().setUpdateable().setDescription("How often the truststore should be reloaded, in seconds. Set to negative value to disable refreshing at runtime."));
        META.put(PROP_KS_PASSWORD, new PropertyMD().setSecret().setCategory(ksCat).setDescription("The password of the keystore type truststore."));
        META.put(PROP_KS_TYPE, new PropertyMD().setCategory(ksCat).setDescription("The keystore type (jks, pkcs12) in case of truststore of keystore type."));
        META.put(PROP_KS_PATH, new PropertyMD().setCategory(ksCat).setDescription("The keystore path in case of truststore of keystore type."));
        META.put(PROP_OPENSSL_DIR, new PropertyMD("/etc/grid-security/certificates").setPath().setCategory(opensslCat).setDescription("Directory to be used for opeenssl truststore."));
        META.put(PROP_OPENSSL_NEW_STORE_FORMAT, new PropertyMD("false").setCategory(opensslCat).setDescription("In case of openssl truststore, specifies whether the trust store is in openssl 1.0.0+ format (true) or older openssl 0.x format (false)"));
        META.put(PROP_DIRECTORY_LOCATIONS, new PropertyMD().setList(false).setUpdateable().setCategory(dirCat).setDescription("List of CA certificates locations. Can contain URLs, local files and wildcard expressions."));
        META.put(PROP_DIRECTORY_ENCODING, new PropertyMD(CertificateUtils.Encoding.PEM).setCategory(dirCat).setDescription("For directory truststore controls whether certificates are encoded in PEM or DER."));
        META.put(PROP_DIRECTORY_CONNECTION_TIMEOUT, new PropertyMD("15").setCategory(dirCat).setDescription("Connection timeout for fetching the remote CA certificates in seconds."));
        META.put(PROP_DIRECTORY_CACHE_PATH, new PropertyMD().setPath().setCategory(dirCat).setDescription("Directory where CA certificates should be cached, after downloading them from a remote source. Can be left undefined if no disk cache should be used. Note that directory should be secured, i.e. normal users should not be allowed to write to it."));
    }

    private class PropertyChangeListenerImpl
    implements PropertyChangeListener {
        private PropertyChangeListenerImpl() {
        }

        @Override
        public String[] getInterestingProperties() {
            return TrustedIssuersProperties.this.getUpdateableProperties();
        }

        @Override
        public void propertyChanged(String propertyKey) {
            TrustedIssuersProperties.this.update(propertyKey);
        }
    }

    public static enum TruststoreType {
        keystore,
        openssl,
        directory;

    }
}

