/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.trust;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.samly2.SAMLUtils;
import eu.unicore.samly2.exceptions.SAMLValidationException;
import eu.unicore.samly2.trust.DsigSamlTrustCheckerBase;
import eu.unicore.security.dsig.IdAttribute;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xmlbeans.org.oasis.saml2.assertion.NameIDType;
import xmlbeans.org.w3.x2000.x09.xmldsig.SignatureType;

public class TruststoreBasedSamlTrustChecker
extends DsigSamlTrustCheckerBase {
    protected X509CertChainValidator validator;
    protected boolean allowUnsigned;

    public TruststoreBasedSamlTrustChecker(X509CertChainValidator validator, boolean allowUnsigned) {
        this.validator = validator;
        this.allowUnsigned = allowUnsigned;
    }

    public TruststoreBasedSamlTrustChecker(X509CertChainValidator validator) {
        this(validator, false);
    }

    @Override
    protected PublicKey establishKey(NameIDType issuer, SignatureType signature) throws SAMLValidationException {
        X509Certificate[] trustedIssuers;
        X509Certificate[] issuerCC = SAMLUtils.getIssuerFromSignature(signature);
        if (issuerCC == null) {
            throw new SAMLValidationException("Issuer certificate is not set - it is impossible to verify the signature.");
        }
        X509Certificate issuerC = issuerCC[0];
        for (X509Certificate trusted : trustedIssuers = this.validator.getTrustedIssuers()) {
            if (!trusted.equals(issuerC)) continue;
            return issuerC.getPublicKey();
        }
        throw new SAMLValidationException("Issuer certificate is not issued by a trusted CA: " + X500NameUtils.getReadableForm((X500Principal)issuerC.getSubjectX500Principal()));
    }

    @Override
    public boolean isSignatureRequired() {
        return !this.allowUnsigned;
    }

    @Override
    protected void isCorrectlySigned(Document doc, PublicKey key, SignatureType signature, List<Element> shallBeSigned, IdAttribute idAttribute) throws SAMLValidationException {
        if (this.allowUnsigned && (signature == null || signature.isNil())) {
            return;
        }
        super.isCorrectlySigned(doc, key, signature, shallBeSigned, idAttribute);
    }
}

