/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om;

import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.soap.SOAPFactory;

public class OMAbstractFactory {
    public static final String META_FACTORY_NAME_PROPERTY = "org.apache.axiom.om.OMMetaFactory";
    private static final String DEFAULT_META_FACTORY_CLASS_NAME = "org.apache.axiom.om.impl.llom.factory.OMLinkedListMetaFactory";
    private static OMMetaFactory defaultMetaFactory;
    private static OMMetaFactory metaFactory;

    private OMAbstractFactory() {
    }

    public static void setMetaFactory(OMMetaFactory newMetaFactory) {
        metaFactory = newMetaFactory;
    }

    public static OMMetaFactory getMetaFactory() {
        String omFactory;
        if (metaFactory != null) {
            return metaFactory;
        }
        if (defaultMetaFactory != null) {
            return defaultMetaFactory;
        }
        try {
            omFactory = System.getProperty(META_FACTORY_NAME_PROPERTY);
            if (omFactory == null || omFactory.isEmpty()) {
                omFactory = DEFAULT_META_FACTORY_CLASS_NAME;
            }
        }
        catch (SecurityException e) {
            omFactory = DEFAULT_META_FACTORY_CLASS_NAME;
        }
        try {
            defaultMetaFactory = (OMMetaFactory)Class.forName(omFactory).newInstance();
        }
        catch (InstantiationException e) {
            throw new OMException(e);
        }
        catch (IllegalAccessException e) {
            throw new OMException(e);
        }
        catch (ClassNotFoundException e) {
            throw new OMException(e);
        }
        return defaultMetaFactory;
    }

    public static OMFactory getOMFactory() {
        return OMAbstractFactory.getMetaFactory().getOMFactory();
    }

    public static SOAPFactory getSOAP11Factory() {
        return OMAbstractFactory.getMetaFactory().getSOAP11Factory();
    }

    public static SOAPFactory getSOAP12Factory() {
        return OMAbstractFactory.getMetaFactory().getSOAP12Factory();
    }
}

