/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.common;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.entitlement.common.DataPersistenceManager;
import org.wso2.carbon.identity.entitlement.common.PolicyEditorException;
import org.wso2.carbon.identity.entitlement.common.RegistryPersistenceManager;
import org.wso2.carbon.identity.entitlement.common.dto.PolicyEditorDataHolder;

public class PolicyEditorEngine {
    private int tenantId;
    private static final Object lock = new Object();
    private static ConcurrentHashMap<String, PolicyEditorEngine> policyEditorEngine = new ConcurrentHashMap();
    private Map<String, PolicyEditorDataHolder> dataHolder = new HashMap<String, PolicyEditorDataHolder>();
    private DataPersistenceManager manager;
    private static Log log = LogFactory.getLog(PolicyEditorEngine.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PolicyEditorEngine getInstance() {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (!policyEditorEngine.containsKey(Integer.toString(tenantId))) {
            Object object = lock;
            synchronized (object) {
                if (!policyEditorEngine.containsKey(Integer.toString(tenantId))) {
                    policyEditorEngine.put(Integer.toString(tenantId), new PolicyEditorEngine(tenantId));
                }
            }
        }
        return policyEditorEngine.get(Integer.toString(tenantId));
    }

    public PolicyEditorEngine(int tenantId) {
        this.tenantId = tenantId;
        this.manager = new RegistryPersistenceManager();
        try {
            this.dataHolder = this.manager.buildDataHolder();
        }
        catch (PolicyEditorException e) {
            log.error((Object)"Error while building policy editor config", (Throwable)e);
        }
    }

    public PolicyEditorDataHolder getPolicyEditorData(String policyEditorType) {
        if (this.dataHolder != null) {
            return this.dataHolder.get(policyEditorType);
        }
        return null;
    }

    public void persistConfig(String policyEditorType, String xmlConfig) throws PolicyEditorException {
        this.manager.persistConfig(policyEditorType, xmlConfig);
        this.dataHolder = this.manager.buildDataHolder();
    }

    public String getConfig(String policyEditorType) {
        Map<String, String> configs = this.manager.getConfig();
        if (configs != null) {
            return configs.get(policyEditorType);
        }
        return null;
    }
}

