/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations;

import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionRecord;
import com.hazelcast.collection.operations.CollectionBackupAwareOperation;
import com.hazelcast.collection.operations.CollectionResponse;
import com.hazelcast.collection.operations.RemoveAllBackupOperation;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.Clock;
import java.util.Collection;

public class RemoveAllOperation
extends CollectionBackupAwareOperation {
    transient Collection<CollectionRecord> coll;
    transient long begin = -1L;

    public RemoveAllOperation() {
    }

    public RemoveAllOperation(CollectionProxyId proxyId, Data dataKey, int threadId) {
        super(proxyId, dataKey, threadId);
    }

    @Override
    public void run() throws Exception {
        this.begin = Clock.currentTimeMillis();
        this.coll = this.removeCollection();
        this.response = new CollectionResponse(this.coll);
    }

    @Override
    public void afterRun() throws Exception {
        long elapsed = Math.max(0L, Clock.currentTimeMillis() - this.begin);
        if (this.coll != null) {
            this.getOrCreateContainer().update();
            for (CollectionRecord record : this.coll) {
                this.publishEvent(EntryEventType.REMOVED, this.dataKey, record.getObject());
            }
        }
    }

    @Override
    public boolean shouldBackup() {
        return this.coll != null;
    }

    @Override
    public Operation getBackupOperation() {
        return new RemoveAllBackupOperation(this.proxyId, this.dataKey);
    }

    @Override
    public void onWaitExpire() {
        this.getResponseHandler().sendResponse(new CollectionResponse(null));
    }

    @Override
    public int getId() {
        return 18;
    }
}

