/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.unicodeconvert.converter;

import net.sourceforge.unicodeconvert.converter.CompositeConverter;
import net.sourceforge.unicodeconvert.converter.Converter;
import net.sourceforge.unicodeconvert.converter.IscConverter;
import net.sourceforge.unicodeconvert.converter.NcrConverter;
import net.sourceforge.unicodeconvert.converter.Tcvn3Converter;
import net.sourceforge.unicodeconvert.converter.VietEncodings;
import net.sourceforge.unicodeconvert.converter.ViqrConverter;
import net.sourceforge.unicodeconvert.converter.VisciiConverter;
import net.sourceforge.unicodeconvert.converter.VniConverter;
import net.sourceforge.unicodeconvert.converter.VpsConverter;

public class ConverterFactory {
    public static Converter createConverter(VietEncodings vietEncodings) {
        Converter converter;
        if (vietEncodings == VietEncodings.VNI) {
            converter = new VniConverter();
        } else if (vietEncodings == VietEncodings.TCVN3) {
            converter = new Tcvn3Converter();
        } else if (vietEncodings == VietEncodings.VIQR) {
            converter = new ViqrConverter();
        } else if (vietEncodings == VietEncodings.VISCII) {
            converter = new VisciiConverter();
        } else if (vietEncodings == VietEncodings.VPS) {
            converter = new VpsConverter();
        } else if (vietEncodings == VietEncodings.ISC) {
            converter = new IscConverter();
        } else if (vietEncodings == VietEncodings.NCR) {
            converter = new NcrConverter();
        } else if (vietEncodings == VietEncodings.Unicode_Composite) {
            converter = new CompositeConverter();
        } else {
            throw new RuntimeException("Unsupported encoding: " + (Object)((Object)vietEncodings));
        }
        return converter;
    }
}

