/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.unicodeconvert;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import net.sourceforge.unicodeconvert.converter.UnicodeConversion;

public class Cmdline {
    private static String sourceEncoding;

    public static void main(String[] stringArray) {
        if (stringArray.length == 3) {
            sourceEncoding = stringArray[0];
            if (sourceEncoding.equalsIgnoreCase("UNI-COMP")) {
                sourceEncoding = "Unicode Composite";
            }
            File file = new File(stringArray[1]);
            File file2 = new File(stringArray[2]);
            new Cmdline().traverseDir(file, file2);
        } else {
            System.err.println("Usage: java  -jar UnicodeConverter.jar\n       javaw -jar UnicodeConverter.jar\n   or  UnicodeConverter.jar\n       (to launch the program in GUI mode)\n\n   or  java -jar UnicodeConverter.jar <sourceEncoding> <inputfile/dir> <outputfile/dir>\n       (to execute the program in command-line mode)\n\nwhere possible Source Encoding options are\nISC, NCR, TCVN3, UNI-COMP, VIQR, VISCII, VNI, VPS.");
        }
    }

    private void convertAFile(File file, File file2) {
        try {
            file2.getAbsoluteFile().getParentFile().mkdirs();
            System.out.println(file.getPath() + " -> " + file2.getPath());
            UnicodeConversion unicodeConversion = new UnicodeConversion(sourceEncoding);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8");
            outputStreamWriter.write(unicodeConversion.convert(file));
            outputStreamWriter.close();
        }
        catch (RuntimeException runtimeException) {
            System.err.println(runtimeException.getMessage());
        }
        catch (Exception exception) {
            System.err.println("I/O Error. Can't write to file.");
        }
    }

    private void traverseDir(File file, File file2) {
        try {
            if (!file.exists()) {
                System.out.println("File or directory does not exist!");
                return;
            }
            if (file.isFile()) {
                this.convertAFile(file, file2);
            } else {
                File[] fileArray = file.listFiles();
                if (!file2.exists()) {
                    file2.mkdir();
                }
                for (int i = 0; i < fileArray.length; ++i) {
                    File file3 = new File(file2.getPath(), fileArray[i].getName());
                    if (fileArray[i].isDirectory()) {
                        file3.mkdir();
                        this.traverseDir(fileArray[i], file3);
                        continue;
                    }
                    this.convertAFile(fileArray[i], file3);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

