<?php
/**
 * Copyright 2007 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
# Generated by the protocol buffer compiler. DO NOT EDIT!
# source: google/appengine/api/images/images_service.proto

namespace dummy {
  require_once 'google/appengine/runtime/proto/ProtocolMessage.php';
}
namespace google\appengine\ImagesServiceError {
  class ErrorCode {
    const UNSPECIFIED_ERROR = 1;
    const BAD_TRANSFORM_DATA = 2;
    const NOT_IMAGE = 3;
    const BAD_IMAGE_DATA = 4;
    const IMAGE_TOO_LARGE = 5;
    const INVALID_BLOB_KEY = 6;
    const ACCESS_DENIED = 7;
    const OBJECT_NOT_FOUND = 8;
  }
}
namespace google\appengine {
  class ImagesServiceError extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine\ImagesServiceTransform {
  class Type {
    const RESIZE = 1;
    const ROTATE = 2;
    const HORIZONTAL_FLIP = 3;
    const VERTICAL_FLIP = 4;
    const CROP = 5;
    const IM_FEELING_LUCKY = 6;
  }
}
namespace google\appengine {
  class ImagesServiceTransform extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine {
  class Transform extends \google\net\ProtocolMessage {
    public function getWidth() {
      if (!isset($this->width)) {
        return 0;
      }
      return $this->width;
    }
    public function setWidth($val) {
      $this->width = $val;
      return $this;
    }
    public function clearWidth() {
      unset($this->width);
      return $this;
    }
    public function hasWidth() {
      return isset($this->width);
    }
    public function getHeight() {
      if (!isset($this->height)) {
        return 0;
      }
      return $this->height;
    }
    public function setHeight($val) {
      $this->height = $val;
      return $this;
    }
    public function clearHeight() {
      unset($this->height);
      return $this;
    }
    public function hasHeight() {
      return isset($this->height);
    }
    public function getRotate() {
      if (!isset($this->rotate)) {
        return 0;
      }
      return $this->rotate;
    }
    public function setRotate($val) {
      $this->rotate = $val;
      return $this;
    }
    public function clearRotate() {
      unset($this->rotate);
      return $this;
    }
    public function hasRotate() {
      return isset($this->rotate);
    }
    public function getHorizontalFlip() {
      if (!isset($this->horizontal_flip)) {
        return false;
      }
      return $this->horizontal_flip;
    }
    public function setHorizontalFlip($val) {
      $this->horizontal_flip = $val;
      return $this;
    }
    public function clearHorizontalFlip() {
      unset($this->horizontal_flip);
      return $this;
    }
    public function hasHorizontalFlip() {
      return isset($this->horizontal_flip);
    }
    public function getVerticalFlip() {
      if (!isset($this->vertical_flip)) {
        return false;
      }
      return $this->vertical_flip;
    }
    public function setVerticalFlip($val) {
      $this->vertical_flip = $val;
      return $this;
    }
    public function clearVerticalFlip() {
      unset($this->vertical_flip);
      return $this;
    }
    public function hasVerticalFlip() {
      return isset($this->vertical_flip);
    }
    public function getCropLeftX() {
      if (!isset($this->crop_left_x)) {
        return 0;
      }
      return $this->crop_left_x;
    }
    public function setCropLeftX($val) {
      $this->crop_left_x = $val;
      return $this;
    }
    public function clearCropLeftX() {
      unset($this->crop_left_x);
      return $this;
    }
    public function hasCropLeftX() {
      return isset($this->crop_left_x);
    }
    public function getCropTopY() {
      if (!isset($this->crop_top_y)) {
        return 0;
      }
      return $this->crop_top_y;
    }
    public function setCropTopY($val) {
      $this->crop_top_y = $val;
      return $this;
    }
    public function clearCropTopY() {
      unset($this->crop_top_y);
      return $this;
    }
    public function hasCropTopY() {
      return isset($this->crop_top_y);
    }
    public function getCropRightX() {
      if (!isset($this->crop_right_x)) {
        return 1;
      }
      return $this->crop_right_x;
    }
    public function setCropRightX($val) {
      $this->crop_right_x = $val;
      return $this;
    }
    public function clearCropRightX() {
      unset($this->crop_right_x);
      return $this;
    }
    public function hasCropRightX() {
      return isset($this->crop_right_x);
    }
    public function getCropBottomY() {
      if (!isset($this->crop_bottom_y)) {
        return 1;
      }
      return $this->crop_bottom_y;
    }
    public function setCropBottomY($val) {
      $this->crop_bottom_y = $val;
      return $this;
    }
    public function clearCropBottomY() {
      unset($this->crop_bottom_y);
      return $this;
    }
    public function hasCropBottomY() {
      return isset($this->crop_bottom_y);
    }
    public function getAutolevels() {
      if (!isset($this->autolevels)) {
        return false;
      }
      return $this->autolevels;
    }
    public function setAutolevels($val) {
      $this->autolevels = $val;
      return $this;
    }
    public function clearAutolevels() {
      unset($this->autolevels);
      return $this;
    }
    public function hasAutolevels() {
      return isset($this->autolevels);
    }
    public function getCropToFit() {
      if (!isset($this->crop_to_fit)) {
        return false;
      }
      return $this->crop_to_fit;
    }
    public function setCropToFit($val) {
      $this->crop_to_fit = $val;
      return $this;
    }
    public function clearCropToFit() {
      unset($this->crop_to_fit);
      return $this;
    }
    public function hasCropToFit() {
      return isset($this->crop_to_fit);
    }
    public function getCropOffsetX() {
      if (!isset($this->crop_offset_x)) {
        return 0.5;
      }
      return $this->crop_offset_x;
    }
    public function setCropOffsetX($val) {
      $this->crop_offset_x = $val;
      return $this;
    }
    public function clearCropOffsetX() {
      unset($this->crop_offset_x);
      return $this;
    }
    public function hasCropOffsetX() {
      return isset($this->crop_offset_x);
    }
    public function getCropOffsetY() {
      if (!isset($this->crop_offset_y)) {
        return 0.5;
      }
      return $this->crop_offset_y;
    }
    public function setCropOffsetY($val) {
      $this->crop_offset_y = $val;
      return $this;
    }
    public function clearCropOffsetY() {
      unset($this->crop_offset_y);
      return $this;
    }
    public function hasCropOffsetY() {
      return isset($this->crop_offset_y);
    }
    public function getAllowStretch() {
      if (!isset($this->allow_stretch)) {
        return false;
      }
      return $this->allow_stretch;
    }
    public function setAllowStretch($val) {
      $this->allow_stretch = $val;
      return $this;
    }
    public function clearAllowStretch() {
      unset($this->allow_stretch);
      return $this;
    }
    public function hasAllowStretch() {
      return isset($this->allow_stretch);
    }
    public function clear() {
      $this->clearWidth();
      $this->clearHeight();
      $this->clearRotate();
      $this->clearHorizontalFlip();
      $this->clearVerticalFlip();
      $this->clearCropLeftX();
      $this->clearCropTopY();
      $this->clearCropRightX();
      $this->clearCropBottomY();
      $this->clearAutolevels();
      $this->clearCropToFit();
      $this->clearCropOffsetX();
      $this->clearCropOffsetY();
      $this->clearAllowStretch();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->width)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->width);
      }
      if (isset($this->height)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->height);
      }
      if (isset($this->rotate)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->rotate);
      }
      if (isset($this->horizontal_flip)) {
        $res += 2;
      }
      if (isset($this->vertical_flip)) {
        $res += 2;
      }
      if (isset($this->crop_left_x)) {
        $res += 5;
      }
      if (isset($this->crop_top_y)) {
        $res += 5;
      }
      if (isset($this->crop_right_x)) {
        $res += 5;
      }
      if (isset($this->crop_bottom_y)) {
        $res += 5;
      }
      if (isset($this->autolevels)) {
        $res += 2;
      }
      if (isset($this->crop_to_fit)) {
        $res += 2;
      }
      if (isset($this->crop_offset_x)) {
        $res += 5;
      }
      if (isset($this->crop_offset_y)) {
        $res += 5;
      }
      if (isset($this->allow_stretch)) {
        $res += 2;
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->width)) {
        $out->putVarInt32(8);
        $out->putVarInt32($this->width);
      }
      if (isset($this->height)) {
        $out->putVarInt32(16);
        $out->putVarInt32($this->height);
      }
      if (isset($this->rotate)) {
        $out->putVarInt32(24);
        $out->putVarInt32($this->rotate);
      }
      if (isset($this->horizontal_flip)) {
        $out->putVarInt32(32);
        $out->putBoolean($this->horizontal_flip);
      }
      if (isset($this->vertical_flip)) {
        $out->putVarInt32(40);
        $out->putBoolean($this->vertical_flip);
      }
      if (isset($this->crop_left_x)) {
        $out->putVarInt32(53);
        $out->putFloat($this->crop_left_x);
      }
      if (isset($this->crop_top_y)) {
        $out->putVarInt32(61);
        $out->putFloat($this->crop_top_y);
      }
      if (isset($this->crop_right_x)) {
        $out->putVarInt32(69);
        $out->putFloat($this->crop_right_x);
      }
      if (isset($this->crop_bottom_y)) {
        $out->putVarInt32(77);
        $out->putFloat($this->crop_bottom_y);
      }
      if (isset($this->autolevels)) {
        $out->putVarInt32(80);
        $out->putBoolean($this->autolevels);
      }
      if (isset($this->crop_to_fit)) {
        $out->putVarInt32(88);
        $out->putBoolean($this->crop_to_fit);
      }
      if (isset($this->crop_offset_x)) {
        $out->putVarInt32(101);
        $out->putFloat($this->crop_offset_x);
      }
      if (isset($this->crop_offset_y)) {
        $out->putVarInt32(109);
        $out->putFloat($this->crop_offset_y);
      }
      if (isset($this->allow_stretch)) {
        $out->putVarInt32(112);
        $out->putBoolean($this->allow_stretch);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setWidth($d->getVarInt32());
            break;
          case 16:
            $this->setHeight($d->getVarInt32());
            break;
          case 24:
            $this->setRotate($d->getVarInt32());
            break;
          case 32:
            $this->setHorizontalFlip($d->getBoolean());
            break;
          case 40:
            $this->setVerticalFlip($d->getBoolean());
            break;
          case 53:
            $this->setCropLeftX($d->getFloat());
            break;
          case 61:
            $this->setCropTopY($d->getFloat());
            break;
          case 69:
            $this->setCropRightX($d->getFloat());
            break;
          case 77:
            $this->setCropBottomY($d->getFloat());
            break;
          case 80:
            $this->setAutolevels($d->getBoolean());
            break;
          case 88:
            $this->setCropToFit($d->getBoolean());
            break;
          case 101:
            $this->setCropOffsetX($d->getFloat());
            break;
          case 109:
            $this->setCropOffsetY($d->getFloat());
            break;
          case 112:
            $this->setAllowStretch($d->getBoolean());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasWidth()) {
        $this->setWidth($x->getWidth());
      }
      if ($x->hasHeight()) {
        $this->setHeight($x->getHeight());
      }
      if ($x->hasRotate()) {
        $this->setRotate($x->getRotate());
      }
      if ($x->hasHorizontalFlip()) {
        $this->setHorizontalFlip($x->getHorizontalFlip());
      }
      if ($x->hasVerticalFlip()) {
        $this->setVerticalFlip($x->getVerticalFlip());
      }
      if ($x->hasCropLeftX()) {
        $this->setCropLeftX($x->getCropLeftX());
      }
      if ($x->hasCropTopY()) {
        $this->setCropTopY($x->getCropTopY());
      }
      if ($x->hasCropRightX()) {
        $this->setCropRightX($x->getCropRightX());
      }
      if ($x->hasCropBottomY()) {
        $this->setCropBottomY($x->getCropBottomY());
      }
      if ($x->hasAutolevels()) {
        $this->setAutolevels($x->getAutolevels());
      }
      if ($x->hasCropToFit()) {
        $this->setCropToFit($x->getCropToFit());
      }
      if ($x->hasCropOffsetX()) {
        $this->setCropOffsetX($x->getCropOffsetX());
      }
      if ($x->hasCropOffsetY()) {
        $this->setCropOffsetY($x->getCropOffsetY());
      }
      if ($x->hasAllowStretch()) {
        $this->setAllowStretch($x->getAllowStretch());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->width) !== isset($x->width)) return false;
      if (isset($this->width) && !$this->integerEquals($this->width, $x->width)) return false;
      if (isset($this->height) !== isset($x->height)) return false;
      if (isset($this->height) && !$this->integerEquals($this->height, $x->height)) return false;
      if (isset($this->rotate) !== isset($x->rotate)) return false;
      if (isset($this->rotate) && !$this->integerEquals($this->rotate, $x->rotate)) return false;
      if (isset($this->horizontal_flip) !== isset($x->horizontal_flip)) return false;
      if (isset($this->horizontal_flip) && $this->horizontal_flip !== $x->horizontal_flip) return false;
      if (isset($this->vertical_flip) !== isset($x->vertical_flip)) return false;
      if (isset($this->vertical_flip) && $this->vertical_flip !== $x->vertical_flip) return false;
      if (isset($this->crop_left_x) !== isset($x->crop_left_x)) return false;
      if (isset($this->crop_left_x) && $this->crop_left_x !== $x->crop_left_x) return false;
      if (isset($this->crop_top_y) !== isset($x->crop_top_y)) return false;
      if (isset($this->crop_top_y) && $this->crop_top_y !== $x->crop_top_y) return false;
      if (isset($this->crop_right_x) !== isset($x->crop_right_x)) return false;
      if (isset($this->crop_right_x) && $this->crop_right_x !== $x->crop_right_x) return false;
      if (isset($this->crop_bottom_y) !== isset($x->crop_bottom_y)) return false;
      if (isset($this->crop_bottom_y) && $this->crop_bottom_y !== $x->crop_bottom_y) return false;
      if (isset($this->autolevels) !== isset($x->autolevels)) return false;
      if (isset($this->autolevels) && $this->autolevels !== $x->autolevels) return false;
      if (isset($this->crop_to_fit) !== isset($x->crop_to_fit)) return false;
      if (isset($this->crop_to_fit) && $this->crop_to_fit !== $x->crop_to_fit) return false;
      if (isset($this->crop_offset_x) !== isset($x->crop_offset_x)) return false;
      if (isset($this->crop_offset_x) && $this->crop_offset_x !== $x->crop_offset_x) return false;
      if (isset($this->crop_offset_y) !== isset($x->crop_offset_y)) return false;
      if (isset($this->crop_offset_y) && $this->crop_offset_y !== $x->crop_offset_y) return false;
      if (isset($this->allow_stretch) !== isset($x->allow_stretch)) return false;
      if (isset($this->allow_stretch) && $this->allow_stretch !== $x->allow_stretch) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->width)) {
        $res .= $prefix . "width: " . $this->debugFormatInt32($this->width) . "\n";
      }
      if (isset($this->height)) {
        $res .= $prefix . "height: " . $this->debugFormatInt32($this->height) . "\n";
      }
      if (isset($this->rotate)) {
        $res .= $prefix . "rotate: " . $this->debugFormatInt32($this->rotate) . "\n";
      }
      if (isset($this->horizontal_flip)) {
        $res .= $prefix . "horizontal_flip: " . $this->debugFormatBool($this->horizontal_flip) . "\n";
      }
      if (isset($this->vertical_flip)) {
        $res .= $prefix . "vertical_flip: " . $this->debugFormatBool($this->vertical_flip) . "\n";
      }
      if (isset($this->crop_left_x)) {
        $res .= $prefix . "crop_left_x: " . $this->debugFormatFloat($this->crop_left_x) . "\n";
      }
      if (isset($this->crop_top_y)) {
        $res .= $prefix . "crop_top_y: " . $this->debugFormatFloat($this->crop_top_y) . "\n";
      }
      if (isset($this->crop_right_x)) {
        $res .= $prefix . "crop_right_x: " . $this->debugFormatFloat($this->crop_right_x) . "\n";
      }
      if (isset($this->crop_bottom_y)) {
        $res .= $prefix . "crop_bottom_y: " . $this->debugFormatFloat($this->crop_bottom_y) . "\n";
      }
      if (isset($this->autolevels)) {
        $res .= $prefix . "autolevels: " . $this->debugFormatBool($this->autolevels) . "\n";
      }
      if (isset($this->crop_to_fit)) {
        $res .= $prefix . "crop_to_fit: " . $this->debugFormatBool($this->crop_to_fit) . "\n";
      }
      if (isset($this->crop_offset_x)) {
        $res .= $prefix . "crop_offset_x: " . $this->debugFormatFloat($this->crop_offset_x) . "\n";
      }
      if (isset($this->crop_offset_y)) {
        $res .= $prefix . "crop_offset_y: " . $this->debugFormatFloat($this->crop_offset_y) . "\n";
      }
      if (isset($this->allow_stretch)) {
        $res .= $prefix . "allow_stretch: " . $this->debugFormatBool($this->allow_stretch) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class ImageData extends \google\net\ProtocolMessage {
    public function getContent() {
      if (!isset($this->content)) {
        return '';
      }
      return $this->content;
    }
    public function setContent($val) {
      $this->content = $val;
      return $this;
    }
    public function clearContent() {
      unset($this->content);
      return $this;
    }
    public function hasContent() {
      return isset($this->content);
    }
    public function getBlobKey() {
      if (!isset($this->blob_key)) {
        return '';
      }
      return $this->blob_key;
    }
    public function setBlobKey($val) {
      $this->blob_key = $val;
      return $this;
    }
    public function clearBlobKey() {
      unset($this->blob_key);
      return $this;
    }
    public function hasBlobKey() {
      return isset($this->blob_key);
    }
    public function getWidth() {
      if (!isset($this->width)) {
        return 0;
      }
      return $this->width;
    }
    public function setWidth($val) {
      $this->width = $val;
      return $this;
    }
    public function clearWidth() {
      unset($this->width);
      return $this;
    }
    public function hasWidth() {
      return isset($this->width);
    }
    public function getHeight() {
      if (!isset($this->height)) {
        return 0;
      }
      return $this->height;
    }
    public function setHeight($val) {
      $this->height = $val;
      return $this;
    }
    public function clearHeight() {
      unset($this->height);
      return $this;
    }
    public function hasHeight() {
      return isset($this->height);
    }
    public function clear() {
      $this->clearContent();
      $this->clearBlobKey();
      $this->clearWidth();
      $this->clearHeight();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->content)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->content));
      }
      if (isset($this->blob_key)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->blob_key));
      }
      if (isset($this->width)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->width);
      }
      if (isset($this->height)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->height);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->content)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->content);
      }
      if (isset($this->blob_key)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->blob_key);
      }
      if (isset($this->width)) {
        $out->putVarInt32(24);
        $out->putVarInt32($this->width);
      }
      if (isset($this->height)) {
        $out->putVarInt32(32);
        $out->putVarInt32($this->height);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setContent(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setBlobKey(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 24:
            $this->setWidth($d->getVarInt32());
            break;
          case 32:
            $this->setHeight($d->getVarInt32());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->content)) return 'content';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasContent()) {
        $this->setContent($x->getContent());
      }
      if ($x->hasBlobKey()) {
        $this->setBlobKey($x->getBlobKey());
      }
      if ($x->hasWidth()) {
        $this->setWidth($x->getWidth());
      }
      if ($x->hasHeight()) {
        $this->setHeight($x->getHeight());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->content) !== isset($x->content)) return false;
      if (isset($this->content) && $this->content !== $x->content) return false;
      if (isset($this->blob_key) !== isset($x->blob_key)) return false;
      if (isset($this->blob_key) && $this->blob_key !== $x->blob_key) return false;
      if (isset($this->width) !== isset($x->width)) return false;
      if (isset($this->width) && !$this->integerEquals($this->width, $x->width)) return false;
      if (isset($this->height) !== isset($x->height)) return false;
      if (isset($this->height) && !$this->integerEquals($this->height, $x->height)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->content)) {
        $res .= $prefix . "content: " . $this->debugFormatString($this->content) . "\n";
      }
      if (isset($this->blob_key)) {
        $res .= $prefix . "blob_key: " . $this->debugFormatString($this->blob_key) . "\n";
      }
      if (isset($this->width)) {
        $res .= $prefix . "width: " . $this->debugFormatInt32($this->width) . "\n";
      }
      if (isset($this->height)) {
        $res .= $prefix . "height: " . $this->debugFormatInt32($this->height) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\InputSettings {
  class ORIENTATION_CORRECTION_TYPE {
    const UNCHANGED_ORIENTATION = 0;
    const CORRECT_ORIENTATION = 1;
  }
}
namespace google\appengine {
  class InputSettings extends \google\net\ProtocolMessage {
    public function getCorrectExifOrientation() {
      if (!isset($this->correct_exif_orientation)) {
        return 0;
      }
      return $this->correct_exif_orientation;
    }
    public function setCorrectExifOrientation($val) {
      $this->correct_exif_orientation = $val;
      return $this;
    }
    public function clearCorrectExifOrientation() {
      unset($this->correct_exif_orientation);
      return $this;
    }
    public function hasCorrectExifOrientation() {
      return isset($this->correct_exif_orientation);
    }
    public function getParseMetadata() {
      if (!isset($this->parse_metadata)) {
        return false;
      }
      return $this->parse_metadata;
    }
    public function setParseMetadata($val) {
      $this->parse_metadata = $val;
      return $this;
    }
    public function clearParseMetadata() {
      unset($this->parse_metadata);
      return $this;
    }
    public function hasParseMetadata() {
      return isset($this->parse_metadata);
    }
    public function getTransparentSubstitutionRgb() {
      if (!isset($this->transparent_substitution_rgb)) {
        return 0;
      }
      return $this->transparent_substitution_rgb;
    }
    public function setTransparentSubstitutionRgb($val) {
      $this->transparent_substitution_rgb = $val;
      return $this;
    }
    public function clearTransparentSubstitutionRgb() {
      unset($this->transparent_substitution_rgb);
      return $this;
    }
    public function hasTransparentSubstitutionRgb() {
      return isset($this->transparent_substitution_rgb);
    }
    public function clear() {
      $this->clearCorrectExifOrientation();
      $this->clearParseMetadata();
      $this->clearTransparentSubstitutionRgb();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->correct_exif_orientation)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->correct_exif_orientation);
      }
      if (isset($this->parse_metadata)) {
        $res += 2;
      }
      if (isset($this->transparent_substitution_rgb)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->transparent_substitution_rgb);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->correct_exif_orientation)) {
        $out->putVarInt32(8);
        $out->putVarInt32($this->correct_exif_orientation);
      }
      if (isset($this->parse_metadata)) {
        $out->putVarInt32(16);
        $out->putBoolean($this->parse_metadata);
      }
      if (isset($this->transparent_substitution_rgb)) {
        $out->putVarInt32(24);
        $out->putVarInt32($this->transparent_substitution_rgb);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setCorrectExifOrientation($d->getVarInt32());
            break;
          case 16:
            $this->setParseMetadata($d->getBoolean());
            break;
          case 24:
            $this->setTransparentSubstitutionRgb($d->getVarInt32());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasCorrectExifOrientation()) {
        $this->setCorrectExifOrientation($x->getCorrectExifOrientation());
      }
      if ($x->hasParseMetadata()) {
        $this->setParseMetadata($x->getParseMetadata());
      }
      if ($x->hasTransparentSubstitutionRgb()) {
        $this->setTransparentSubstitutionRgb($x->getTransparentSubstitutionRgb());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->correct_exif_orientation) !== isset($x->correct_exif_orientation)) return false;
      if (isset($this->correct_exif_orientation) && $this->correct_exif_orientation !== $x->correct_exif_orientation) return false;
      if (isset($this->parse_metadata) !== isset($x->parse_metadata)) return false;
      if (isset($this->parse_metadata) && $this->parse_metadata !== $x->parse_metadata) return false;
      if (isset($this->transparent_substitution_rgb) !== isset($x->transparent_substitution_rgb)) return false;
      if (isset($this->transparent_substitution_rgb) && !$this->integerEquals($this->transparent_substitution_rgb, $x->transparent_substitution_rgb)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->correct_exif_orientation)) {
        $res .= $prefix . "correct_exif_orientation: " . ($this->correct_exif_orientation) . "\n";
      }
      if (isset($this->parse_metadata)) {
        $res .= $prefix . "parse_metadata: " . $this->debugFormatBool($this->parse_metadata) . "\n";
      }
      if (isset($this->transparent_substitution_rgb)) {
        $res .= $prefix . "transparent_substitution_rgb: " . $this->debugFormatInt32($this->transparent_substitution_rgb) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\OutputSettings {
  class MIME_TYPE {
    const PNG = 0;
    const JPEG = 1;
    const WEBP = 2;
  }
}
namespace google\appengine {
  class OutputSettings extends \google\net\ProtocolMessage {
    public function getMimeType() {
      if (!isset($this->mime_type)) {
        return 0;
      }
      return $this->mime_type;
    }
    public function setMimeType($val) {
      $this->mime_type = $val;
      return $this;
    }
    public function clearMimeType() {
      unset($this->mime_type);
      return $this;
    }
    public function hasMimeType() {
      return isset($this->mime_type);
    }
    public function getQuality() {
      if (!isset($this->quality)) {
        return 0;
      }
      return $this->quality;
    }
    public function setQuality($val) {
      $this->quality = $val;
      return $this;
    }
    public function clearQuality() {
      unset($this->quality);
      return $this;
    }
    public function hasQuality() {
      return isset($this->quality);
    }
    public function clear() {
      $this->clearMimeType();
      $this->clearQuality();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->mime_type)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->mime_type);
      }
      if (isset($this->quality)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->quality);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->mime_type)) {
        $out->putVarInt32(8);
        $out->putVarInt32($this->mime_type);
      }
      if (isset($this->quality)) {
        $out->putVarInt32(16);
        $out->putVarInt32($this->quality);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setMimeType($d->getVarInt32());
            break;
          case 16:
            $this->setQuality($d->getVarInt32());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasMimeType()) {
        $this->setMimeType($x->getMimeType());
      }
      if ($x->hasQuality()) {
        $this->setQuality($x->getQuality());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->mime_type) !== isset($x->mime_type)) return false;
      if (isset($this->mime_type) && $this->mime_type !== $x->mime_type) return false;
      if (isset($this->quality) !== isset($x->quality)) return false;
      if (isset($this->quality) && !$this->integerEquals($this->quality, $x->quality)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->mime_type)) {
        $res .= $prefix . "mime_type: " . ($this->mime_type) . "\n";
      }
      if (isset($this->quality)) {
        $res .= $prefix . "quality: " . $this->debugFormatInt32($this->quality) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class ImagesTransformRequest extends \google\net\ProtocolMessage {
    private $transform = array();
    public function getImage() {
      if (!isset($this->image)) {
        return new \google\appengine\ImageData();
      }
      return $this->image;
    }
    public function mutableImage() {
      if (!isset($this->image)) {
        $res = new \google\appengine\ImageData();
        $this->image = $res;
        return $res;
      }
      return $this->image;
    }
    public function clearImage() {
      if (isset($this->image)) {
        unset($this->image);
      }
    }
    public function hasImage() {
      return isset($this->image);
    }
    public function getTransformSize() {
      return sizeof($this->transform);
    }
    public function getTransformList() {
      return $this->transform;
    }
    public function mutableTransform($idx) {
      if (!isset($this->transform[$idx])) {
        $val = new \google\appengine\Transform();
        $this->transform[$idx] = $val;
        return $val;
      }
      return $this->transform[$idx];
    }
    public function getTransform($idx) {
      if (isset($this->transform[$idx])) {
        return $this->transform[$idx];
      }
      if ($idx >= end(array_keys($this->transform))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\Transform();
    }
    public function addTransform() {
      $val = new \google\appengine\Transform();
      $this->transform[] = $val;
      return $val;
    }
    public function clearTransform() {
      $this->transform = array();
    }
    public function getOutput() {
      if (!isset($this->output)) {
        return new \google\appengine\OutputSettings();
      }
      return $this->output;
    }
    public function mutableOutput() {
      if (!isset($this->output)) {
        $res = new \google\appengine\OutputSettings();
        $this->output = $res;
        return $res;
      }
      return $this->output;
    }
    public function clearOutput() {
      if (isset($this->output)) {
        unset($this->output);
      }
    }
    public function hasOutput() {
      return isset($this->output);
    }
    public function getInput() {
      if (!isset($this->input)) {
        return new \google\appengine\InputSettings();
      }
      return $this->input;
    }
    public function mutableInput() {
      if (!isset($this->input)) {
        $res = new \google\appengine\InputSettings();
        $this->input = $res;
        return $res;
      }
      return $this->input;
    }
    public function clearInput() {
      if (isset($this->input)) {
        unset($this->input);
      }
    }
    public function hasInput() {
      return isset($this->input);
    }
    public function clear() {
      $this->clearImage();
      $this->clearTransform();
      $this->clearOutput();
      $this->clearInput();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->image)) {
        $res += 1;
        $res += $this->lengthString($this->image->byteSizePartial());
      }
      $this->checkProtoArray($this->transform);
      $res += 1 * sizeof($this->transform);
      foreach ($this->transform as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->output)) {
        $res += 1;
        $res += $this->lengthString($this->output->byteSizePartial());
      }
      if (isset($this->input)) {
        $res += 1;
        $res += $this->lengthString($this->input->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->image)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->image->byteSizePartial());
        $this->image->outputPartial($out);
      }
      $this->checkProtoArray($this->transform);
      foreach ($this->transform as $value) {
        $out->putVarInt32(18);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->output)) {
        $out->putVarInt32(26);
        $out->putVarInt32($this->output->byteSizePartial());
        $this->output->outputPartial($out);
      }
      if (isset($this->input)) {
        $out->putVarInt32(34);
        $out->putVarInt32($this->input->byteSizePartial());
        $this->input->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableImage()->tryMerge($tmp);
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addTransform()->tryMerge($tmp);
            break;
          case 26:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableOutput()->tryMerge($tmp);
            break;
          case 34:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableInput()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if ((!isset($this->image)) || (!$this->image->isInitialized())) return 'image';
      foreach ($this->transform as $value) {
        if (!$value->isInitialized()) return 'transform';
      }
      if ((!isset($this->output)) || (!$this->output->isInitialized())) return 'output';
      if (isset($this->input) && (!$this->input->isInitialized())) return 'input';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasImage()) {
        $this->mutableImage()->mergeFrom($x->getImage());
      }
      foreach ($x->getTransformList() as $v) {
        $this->addTransform()->copyFrom($v);
      }
      if ($x->hasOutput()) {
        $this->mutableOutput()->mergeFrom($x->getOutput());
      }
      if ($x->hasInput()) {
        $this->mutableInput()->mergeFrom($x->getInput());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->image) !== isset($x->image)) return false;
      if (isset($this->image) && !$this->image->equals($x->image)) return false;
      if (sizeof($this->transform) !== sizeof($x->transform)) return false;
      foreach (array_map(null, $this->transform, $x->transform) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->output) !== isset($x->output)) return false;
      if (isset($this->output) && !$this->output->equals($x->output)) return false;
      if (isset($this->input) !== isset($x->input)) return false;
      if (isset($this->input) && !$this->input->equals($x->input)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->image)) {
        $res .= $prefix . "image <\n" . $this->image->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->transform as $value) {
        $res .= $prefix . "transform <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->output)) {
        $res .= $prefix . "output <\n" . $this->output->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->input)) {
        $res .= $prefix . "input <\n" . $this->input->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class ImagesTransformResponse extends \google\net\ProtocolMessage {
    public function getImage() {
      if (!isset($this->image)) {
        return new \google\appengine\ImageData();
      }
      return $this->image;
    }
    public function mutableImage() {
      if (!isset($this->image)) {
        $res = new \google\appengine\ImageData();
        $this->image = $res;
        return $res;
      }
      return $this->image;
    }
    public function clearImage() {
      if (isset($this->image)) {
        unset($this->image);
      }
    }
    public function hasImage() {
      return isset($this->image);
    }
    public function getSourceMetadata() {
      if (!isset($this->source_metadata)) {
        return '';
      }
      return $this->source_metadata;
    }
    public function setSourceMetadata($val) {
      $this->source_metadata = $val;
      return $this;
    }
    public function clearSourceMetadata() {
      unset($this->source_metadata);
      return $this;
    }
    public function hasSourceMetadata() {
      return isset($this->source_metadata);
    }
    public function clear() {
      $this->clearImage();
      $this->clearSourceMetadata();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->image)) {
        $res += 1;
        $res += $this->lengthString($this->image->byteSizePartial());
      }
      if (isset($this->source_metadata)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->source_metadata));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->image)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->image->byteSizePartial());
        $this->image->outputPartial($out);
      }
      if (isset($this->source_metadata)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->source_metadata);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableImage()->tryMerge($tmp);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setSourceMetadata(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if ((!isset($this->image)) || (!$this->image->isInitialized())) return 'image';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasImage()) {
        $this->mutableImage()->mergeFrom($x->getImage());
      }
      if ($x->hasSourceMetadata()) {
        $this->setSourceMetadata($x->getSourceMetadata());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->image) !== isset($x->image)) return false;
      if (isset($this->image) && !$this->image->equals($x->image)) return false;
      if (isset($this->source_metadata) !== isset($x->source_metadata)) return false;
      if (isset($this->source_metadata) && $this->source_metadata !== $x->source_metadata) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->image)) {
        $res .= $prefix . "image <\n" . $this->image->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->source_metadata)) {
        $res .= $prefix . "source_metadata: " . $this->debugFormatString($this->source_metadata) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine\CompositeImageOptions {
  class ANCHOR {
    const TOP_LEFT = 0;
    const TOP = 1;
    const TOP_RIGHT = 2;
    const LEFT = 3;
    const CENTER = 4;
    const RIGHT = 5;
    const BOTTOM_LEFT = 6;
    const BOTTOM = 7;
    const BOTTOM_RIGHT = 8;
  }
}
namespace google\appengine {
  class CompositeImageOptions extends \google\net\ProtocolMessage {
    public function getSourceIndex() {
      if (!isset($this->source_index)) {
        return 0;
      }
      return $this->source_index;
    }
    public function setSourceIndex($val) {
      $this->source_index = $val;
      return $this;
    }
    public function clearSourceIndex() {
      unset($this->source_index);
      return $this;
    }
    public function hasSourceIndex() {
      return isset($this->source_index);
    }
    public function getXOffset() {
      if (!isset($this->x_offset)) {
        return 0;
      }
      return $this->x_offset;
    }
    public function setXOffset($val) {
      $this->x_offset = $val;
      return $this;
    }
    public function clearXOffset() {
      unset($this->x_offset);
      return $this;
    }
    public function hasXOffset() {
      return isset($this->x_offset);
    }
    public function getYOffset() {
      if (!isset($this->y_offset)) {
        return 0;
      }
      return $this->y_offset;
    }
    public function setYOffset($val) {
      $this->y_offset = $val;
      return $this;
    }
    public function clearYOffset() {
      unset($this->y_offset);
      return $this;
    }
    public function hasYOffset() {
      return isset($this->y_offset);
    }
    public function getOpacity() {
      if (!isset($this->opacity)) {
        return 0.0;
      }
      return $this->opacity;
    }
    public function setOpacity($val) {
      $this->opacity = $val;
      return $this;
    }
    public function clearOpacity() {
      unset($this->opacity);
      return $this;
    }
    public function hasOpacity() {
      return isset($this->opacity);
    }
    public function getAnchor() {
      if (!isset($this->anchor)) {
        return 0;
      }
      return $this->anchor;
    }
    public function setAnchor($val) {
      $this->anchor = $val;
      return $this;
    }
    public function clearAnchor() {
      unset($this->anchor);
      return $this;
    }
    public function hasAnchor() {
      return isset($this->anchor);
    }
    public function clear() {
      $this->clearSourceIndex();
      $this->clearXOffset();
      $this->clearYOffset();
      $this->clearOpacity();
      $this->clearAnchor();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->source_index)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->source_index);
      }
      if (isset($this->x_offset)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->x_offset);
      }
      if (isset($this->y_offset)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->y_offset);
      }
      if (isset($this->opacity)) {
        $res += 5;
      }
      if (isset($this->anchor)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->anchor);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->source_index)) {
        $out->putVarInt32(8);
        $out->putVarInt32($this->source_index);
      }
      if (isset($this->x_offset)) {
        $out->putVarInt32(16);
        $out->putVarInt32($this->x_offset);
      }
      if (isset($this->y_offset)) {
        $out->putVarInt32(24);
        $out->putVarInt32($this->y_offset);
      }
      if (isset($this->opacity)) {
        $out->putVarInt32(37);
        $out->putFloat($this->opacity);
      }
      if (isset($this->anchor)) {
        $out->putVarInt32(40);
        $out->putVarInt32($this->anchor);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setSourceIndex($d->getVarInt32());
            break;
          case 16:
            $this->setXOffset($d->getVarInt32());
            break;
          case 24:
            $this->setYOffset($d->getVarInt32());
            break;
          case 37:
            $this->setOpacity($d->getFloat());
            break;
          case 40:
            $this->setAnchor($d->getVarInt32());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->source_index)) return 'source_index';
      if (!isset($this->x_offset)) return 'x_offset';
      if (!isset($this->y_offset)) return 'y_offset';
      if (!isset($this->opacity)) return 'opacity';
      if (!isset($this->anchor)) return 'anchor';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasSourceIndex()) {
        $this->setSourceIndex($x->getSourceIndex());
      }
      if ($x->hasXOffset()) {
        $this->setXOffset($x->getXOffset());
      }
      if ($x->hasYOffset()) {
        $this->setYOffset($x->getYOffset());
      }
      if ($x->hasOpacity()) {
        $this->setOpacity($x->getOpacity());
      }
      if ($x->hasAnchor()) {
        $this->setAnchor($x->getAnchor());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->source_index) !== isset($x->source_index)) return false;
      if (isset($this->source_index) && !$this->integerEquals($this->source_index, $x->source_index)) return false;
      if (isset($this->x_offset) !== isset($x->x_offset)) return false;
      if (isset($this->x_offset) && !$this->integerEquals($this->x_offset, $x->x_offset)) return false;
      if (isset($this->y_offset) !== isset($x->y_offset)) return false;
      if (isset($this->y_offset) && !$this->integerEquals($this->y_offset, $x->y_offset)) return false;
      if (isset($this->opacity) !== isset($x->opacity)) return false;
      if (isset($this->opacity) && $this->opacity !== $x->opacity) return false;
      if (isset($this->anchor) !== isset($x->anchor)) return false;
      if (isset($this->anchor) && $this->anchor !== $x->anchor) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->source_index)) {
        $res .= $prefix . "source_index: " . $this->debugFormatInt32($this->source_index) . "\n";
      }
      if (isset($this->x_offset)) {
        $res .= $prefix . "x_offset: " . $this->debugFormatInt32($this->x_offset) . "\n";
      }
      if (isset($this->y_offset)) {
        $res .= $prefix . "y_offset: " . $this->debugFormatInt32($this->y_offset) . "\n";
      }
      if (isset($this->opacity)) {
        $res .= $prefix . "opacity: " . $this->debugFormatFloat($this->opacity) . "\n";
      }
      if (isset($this->anchor)) {
        $res .= $prefix . "anchor: " . ($this->anchor) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class ImagesCanvas extends \google\net\ProtocolMessage {
    public function getWidth() {
      if (!isset($this->width)) {
        return 0;
      }
      return $this->width;
    }
    public function setWidth($val) {
      $this->width = $val;
      return $this;
    }
    public function clearWidth() {
      unset($this->width);
      return $this;
    }
    public function hasWidth() {
      return isset($this->width);
    }
    public function getHeight() {
      if (!isset($this->height)) {
        return 0;
      }
      return $this->height;
    }
    public function setHeight($val) {
      $this->height = $val;
      return $this;
    }
    public function clearHeight() {
      unset($this->height);
      return $this;
    }
    public function hasHeight() {
      return isset($this->height);
    }
    public function getOutput() {
      if (!isset($this->output)) {
        return new \google\appengine\OutputSettings();
      }
      return $this->output;
    }
    public function mutableOutput() {
      if (!isset($this->output)) {
        $res = new \google\appengine\OutputSettings();
        $this->output = $res;
        return $res;
      }
      return $this->output;
    }
    public function clearOutput() {
      if (isset($this->output)) {
        unset($this->output);
      }
    }
    public function hasOutput() {
      return isset($this->output);
    }
    public function getColor() {
      if (!isset($this->color)) {
        return -1;
      }
      return $this->color;
    }
    public function setColor($val) {
      $this->color = $val;
      return $this;
    }
    public function clearColor() {
      unset($this->color);
      return $this;
    }
    public function hasColor() {
      return isset($this->color);
    }
    public function clear() {
      $this->clearWidth();
      $this->clearHeight();
      $this->clearOutput();
      $this->clearColor();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->width)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->width);
      }
      if (isset($this->height)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->height);
      }
      if (isset($this->output)) {
        $res += 1;
        $res += $this->lengthString($this->output->byteSizePartial());
      }
      if (isset($this->color)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->color);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->width)) {
        $out->putVarInt32(8);
        $out->putVarInt32($this->width);
      }
      if (isset($this->height)) {
        $out->putVarInt32(16);
        $out->putVarInt32($this->height);
      }
      if (isset($this->output)) {
        $out->putVarInt32(26);
        $out->putVarInt32($this->output->byteSizePartial());
        $this->output->outputPartial($out);
      }
      if (isset($this->color)) {
        $out->putVarInt32(32);
        $out->putVarInt32($this->color);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setWidth($d->getVarInt32());
            break;
          case 16:
            $this->setHeight($d->getVarInt32());
            break;
          case 26:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableOutput()->tryMerge($tmp);
            break;
          case 32:
            $this->setColor($d->getVarInt32());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->width)) return 'width';
      if (!isset($this->height)) return 'height';
      if ((!isset($this->output)) || (!$this->output->isInitialized())) return 'output';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasWidth()) {
        $this->setWidth($x->getWidth());
      }
      if ($x->hasHeight()) {
        $this->setHeight($x->getHeight());
      }
      if ($x->hasOutput()) {
        $this->mutableOutput()->mergeFrom($x->getOutput());
      }
      if ($x->hasColor()) {
        $this->setColor($x->getColor());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->width) !== isset($x->width)) return false;
      if (isset($this->width) && !$this->integerEquals($this->width, $x->width)) return false;
      if (isset($this->height) !== isset($x->height)) return false;
      if (isset($this->height) && !$this->integerEquals($this->height, $x->height)) return false;
      if (isset($this->output) !== isset($x->output)) return false;
      if (isset($this->output) && !$this->output->equals($x->output)) return false;
      if (isset($this->color) !== isset($x->color)) return false;
      if (isset($this->color) && !$this->integerEquals($this->color, $x->color)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->width)) {
        $res .= $prefix . "width: " . $this->debugFormatInt32($this->width) . "\n";
      }
      if (isset($this->height)) {
        $res .= $prefix . "height: " . $this->debugFormatInt32($this->height) . "\n";
      }
      if (isset($this->output)) {
        $res .= $prefix . "output <\n" . $this->output->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->color)) {
        $res .= $prefix . "color: " . $this->debugFormatInt32($this->color) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class ImagesCompositeRequest extends \google\net\ProtocolMessage {
    private $image = array();
    private $options = array();
    public function getImageSize() {
      return sizeof($this->image);
    }
    public function getImageList() {
      return $this->image;
    }
    public function mutableImage($idx) {
      if (!isset($this->image[$idx])) {
        $val = new \google\appengine\ImageData();
        $this->image[$idx] = $val;
        return $val;
      }
      return $this->image[$idx];
    }
    public function getImage($idx) {
      if (isset($this->image[$idx])) {
        return $this->image[$idx];
      }
      if ($idx >= end(array_keys($this->image))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\ImageData();
    }
    public function addImage() {
      $val = new \google\appengine\ImageData();
      $this->image[] = $val;
      return $val;
    }
    public function clearImage() {
      $this->image = array();
    }
    public function getOptionsSize() {
      return sizeof($this->options);
    }
    public function getOptionsList() {
      return $this->options;
    }
    public function mutableOptions($idx) {
      if (!isset($this->options[$idx])) {
        $val = new \google\appengine\CompositeImageOptions();
        $this->options[$idx] = $val;
        return $val;
      }
      return $this->options[$idx];
    }
    public function getOptions($idx) {
      if (isset($this->options[$idx])) {
        return $this->options[$idx];
      }
      if ($idx >= end(array_keys($this->options))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine\CompositeImageOptions();
    }
    public function addOptions() {
      $val = new \google\appengine\CompositeImageOptions();
      $this->options[] = $val;
      return $val;
    }
    public function clearOptions() {
      $this->options = array();
    }
    public function getCanvas() {
      if (!isset($this->canvas)) {
        return new \google\appengine\ImagesCanvas();
      }
      return $this->canvas;
    }
    public function mutableCanvas() {
      if (!isset($this->canvas)) {
        $res = new \google\appengine\ImagesCanvas();
        $this->canvas = $res;
        return $res;
      }
      return $this->canvas;
    }
    public function clearCanvas() {
      if (isset($this->canvas)) {
        unset($this->canvas);
      }
    }
    public function hasCanvas() {
      return isset($this->canvas);
    }
    public function clear() {
      $this->clearImage();
      $this->clearOptions();
      $this->clearCanvas();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->image);
      $res += 1 * sizeof($this->image);
      foreach ($this->image as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      $this->checkProtoArray($this->options);
      $res += 1 * sizeof($this->options);
      foreach ($this->options as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->canvas)) {
        $res += 1;
        $res += $this->lengthString($this->canvas->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->image);
      foreach ($this->image as $value) {
        $out->putVarInt32(10);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      $this->checkProtoArray($this->options);
      foreach ($this->options as $value) {
        $out->putVarInt32(18);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->canvas)) {
        $out->putVarInt32(26);
        $out->putVarInt32($this->canvas->byteSizePartial());
        $this->canvas->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addImage()->tryMerge($tmp);
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addOptions()->tryMerge($tmp);
            break;
          case 26:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableCanvas()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->image as $value) {
        if (!$value->isInitialized()) return 'image';
      }
      foreach ($this->options as $value) {
        if (!$value->isInitialized()) return 'options';
      }
      if ((!isset($this->canvas)) || (!$this->canvas->isInitialized())) return 'canvas';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getImageList() as $v) {
        $this->addImage()->copyFrom($v);
      }
      foreach ($x->getOptionsList() as $v) {
        $this->addOptions()->copyFrom($v);
      }
      if ($x->hasCanvas()) {
        $this->mutableCanvas()->mergeFrom($x->getCanvas());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->image) !== sizeof($x->image)) return false;
      foreach (array_map(null, $this->image, $x->image) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (sizeof($this->options) !== sizeof($x->options)) return false;
      foreach (array_map(null, $this->options, $x->options) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->canvas) !== isset($x->canvas)) return false;
      if (isset($this->canvas) && !$this->canvas->equals($x->canvas)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->image as $value) {
        $res .= $prefix . "image <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->options as $value) {
        $res .= $prefix . "options <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->canvas)) {
        $res .= $prefix . "canvas <\n" . $this->canvas->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class ImagesCompositeResponse extends \google\net\ProtocolMessage {
    public function getImage() {
      if (!isset($this->image)) {
        return new \google\appengine\ImageData();
      }
      return $this->image;
    }
    public function mutableImage() {
      if (!isset($this->image)) {
        $res = new \google\appengine\ImageData();
        $this->image = $res;
        return $res;
      }
      return $this->image;
    }
    public function clearImage() {
      if (isset($this->image)) {
        unset($this->image);
      }
    }
    public function hasImage() {
      return isset($this->image);
    }
    public function clear() {
      $this->clearImage();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->image)) {
        $res += 1;
        $res += $this->lengthString($this->image->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->image)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->image->byteSizePartial());
        $this->image->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableImage()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if ((!isset($this->image)) || (!$this->image->isInitialized())) return 'image';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasImage()) {
        $this->mutableImage()->mergeFrom($x->getImage());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->image) !== isset($x->image)) return false;
      if (isset($this->image) && !$this->image->equals($x->image)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->image)) {
        $res .= $prefix . "image <\n" . $this->image->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class ImagesHistogramRequest extends \google\net\ProtocolMessage {
    public function getImage() {
      if (!isset($this->image)) {
        return new \google\appengine\ImageData();
      }
      return $this->image;
    }
    public function mutableImage() {
      if (!isset($this->image)) {
        $res = new \google\appengine\ImageData();
        $this->image = $res;
        return $res;
      }
      return $this->image;
    }
    public function clearImage() {
      if (isset($this->image)) {
        unset($this->image);
      }
    }
    public function hasImage() {
      return isset($this->image);
    }
    public function clear() {
      $this->clearImage();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->image)) {
        $res += 1;
        $res += $this->lengthString($this->image->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->image)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->image->byteSizePartial());
        $this->image->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableImage()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if ((!isset($this->image)) || (!$this->image->isInitialized())) return 'image';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasImage()) {
        $this->mutableImage()->mergeFrom($x->getImage());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->image) !== isset($x->image)) return false;
      if (isset($this->image) && !$this->image->equals($x->image)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->image)) {
        $res .= $prefix . "image <\n" . $this->image->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class ImagesHistogram extends \google\net\ProtocolMessage {
    private $red = array();
    private $green = array();
    private $blue = array();
    public function getRedSize() {
      return sizeof($this->red);
    }
    public function getRedList() {
      return $this->red;
    }
    public function getRed($idx) {
      return $this->red[$idx];
    }
    public function setRed($idx, $val) {
      $this->red[$idx] = $val;
      return $this;
    }
    public function addRed($val) {
      $this->red[] = $val;
      return $this;
    }
    public function clearRed() {
      $this->red = array();
    }
    public function getGreenSize() {
      return sizeof($this->green);
    }
    public function getGreenList() {
      return $this->green;
    }
    public function getGreen($idx) {
      return $this->green[$idx];
    }
    public function setGreen($idx, $val) {
      $this->green[$idx] = $val;
      return $this;
    }
    public function addGreen($val) {
      $this->green[] = $val;
      return $this;
    }
    public function clearGreen() {
      $this->green = array();
    }
    public function getBlueSize() {
      return sizeof($this->blue);
    }
    public function getBlueList() {
      return $this->blue;
    }
    public function getBlue($idx) {
      return $this->blue[$idx];
    }
    public function setBlue($idx, $val) {
      $this->blue[$idx] = $val;
      return $this;
    }
    public function addBlue($val) {
      $this->blue[] = $val;
      return $this;
    }
    public function clearBlue() {
      $this->blue = array();
    }
    public function clear() {
      $this->clearRed();
      $this->clearGreen();
      $this->clearBlue();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->red);
      $res += 1 * sizeof($this->red);
      foreach ($this->red as $value) {
        $res += $this->lengthVarInt64($value);
      }
      $this->checkProtoArray($this->green);
      $res += 1 * sizeof($this->green);
      foreach ($this->green as $value) {
        $res += $this->lengthVarInt64($value);
      }
      $this->checkProtoArray($this->blue);
      $res += 1 * sizeof($this->blue);
      foreach ($this->blue as $value) {
        $res += $this->lengthVarInt64($value);
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->red);
      foreach ($this->red as $value) {
        $out->putVarInt32(8);
        $out->putVarInt32($value);
      }
      $this->checkProtoArray($this->green);
      foreach ($this->green as $value) {
        $out->putVarInt32(16);
        $out->putVarInt32($value);
      }
      $this->checkProtoArray($this->blue);
      foreach ($this->blue as $value) {
        $out->putVarInt32(24);
        $out->putVarInt32($value);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->addRed($d->getVarInt32());
            break;
          case 16:
            $this->addGreen($d->getVarInt32());
            break;
          case 24:
            $this->addBlue($d->getVarInt32());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getRedList() as $v) {
        $this->addRed($v);
      }
      foreach ($x->getGreenList() as $v) {
        $this->addGreen($v);
      }
      foreach ($x->getBlueList() as $v) {
        $this->addBlue($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->red) !== sizeof($x->red)) return false;
      foreach (array_map(null, $this->red, $x->red) as $v) {
        if (!$this->integerEquals($v[0], $v[1])) return false;
      }
      if (sizeof($this->green) !== sizeof($x->green)) return false;
      foreach (array_map(null, $this->green, $x->green) as $v) {
        if (!$this->integerEquals($v[0], $v[1])) return false;
      }
      if (sizeof($this->blue) !== sizeof($x->blue)) return false;
      foreach (array_map(null, $this->blue, $x->blue) as $v) {
        if (!$this->integerEquals($v[0], $v[1])) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->red as $value) {
        $res .= $prefix . "red: " . $this->debugFormatInt32($value) . "\n";
      }
      foreach ($this->green as $value) {
        $res .= $prefix . "green: " . $this->debugFormatInt32($value) . "\n";
      }
      foreach ($this->blue as $value) {
        $res .= $prefix . "blue: " . $this->debugFormatInt32($value) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class ImagesHistogramResponse extends \google\net\ProtocolMessage {
    public function getHistogram() {
      if (!isset($this->histogram)) {
        return new \google\appengine\ImagesHistogram();
      }
      return $this->histogram;
    }
    public function mutableHistogram() {
      if (!isset($this->histogram)) {
        $res = new \google\appengine\ImagesHistogram();
        $this->histogram = $res;
        return $res;
      }
      return $this->histogram;
    }
    public function clearHistogram() {
      if (isset($this->histogram)) {
        unset($this->histogram);
      }
    }
    public function hasHistogram() {
      return isset($this->histogram);
    }
    public function clear() {
      $this->clearHistogram();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->histogram)) {
        $res += 1;
        $res += $this->lengthString($this->histogram->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->histogram)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->histogram->byteSizePartial());
        $this->histogram->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableHistogram()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if ((!isset($this->histogram)) || (!$this->histogram->isInitialized())) return 'histogram';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasHistogram()) {
        $this->mutableHistogram()->mergeFrom($x->getHistogram());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->histogram) !== isset($x->histogram)) return false;
      if (isset($this->histogram) && !$this->histogram->equals($x->histogram)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->histogram)) {
        $res .= $prefix . "histogram <\n" . $this->histogram->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class ImagesGetUrlBaseRequest extends \google\net\ProtocolMessage {
    public function getBlobKey() {
      if (!isset($this->blob_key)) {
        return '';
      }
      return $this->blob_key;
    }
    public function setBlobKey($val) {
      $this->blob_key = $val;
      return $this;
    }
    public function clearBlobKey() {
      unset($this->blob_key);
      return $this;
    }
    public function hasBlobKey() {
      return isset($this->blob_key);
    }
    public function getCreateSecureUrl() {
      if (!isset($this->create_secure_url)) {
        return false;
      }
      return $this->create_secure_url;
    }
    public function setCreateSecureUrl($val) {
      $this->create_secure_url = $val;
      return $this;
    }
    public function clearCreateSecureUrl() {
      unset($this->create_secure_url);
      return $this;
    }
    public function hasCreateSecureUrl() {
      return isset($this->create_secure_url);
    }
    public function clear() {
      $this->clearBlobKey();
      $this->clearCreateSecureUrl();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->blob_key)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->blob_key));
      }
      if (isset($this->create_secure_url)) {
        $res += 2;
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->blob_key)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->blob_key);
      }
      if (isset($this->create_secure_url)) {
        $out->putVarInt32(16);
        $out->putBoolean($this->create_secure_url);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setBlobKey(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 16:
            $this->setCreateSecureUrl($d->getBoolean());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->blob_key)) return 'blob_key';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasBlobKey()) {
        $this->setBlobKey($x->getBlobKey());
      }
      if ($x->hasCreateSecureUrl()) {
        $this->setCreateSecureUrl($x->getCreateSecureUrl());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->blob_key) !== isset($x->blob_key)) return false;
      if (isset($this->blob_key) && $this->blob_key !== $x->blob_key) return false;
      if (isset($this->create_secure_url) !== isset($x->create_secure_url)) return false;
      if (isset($this->create_secure_url) && $this->create_secure_url !== $x->create_secure_url) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->blob_key)) {
        $res .= $prefix . "blob_key: " . $this->debugFormatString($this->blob_key) . "\n";
      }
      if (isset($this->create_secure_url)) {
        $res .= $prefix . "create_secure_url: " . $this->debugFormatBool($this->create_secure_url) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class ImagesGetUrlBaseResponse extends \google\net\ProtocolMessage {
    public function getUrl() {
      if (!isset($this->url)) {
        return '';
      }
      return $this->url;
    }
    public function setUrl($val) {
      $this->url = $val;
      return $this;
    }
    public function clearUrl() {
      unset($this->url);
      return $this;
    }
    public function hasUrl() {
      return isset($this->url);
    }
    public function clear() {
      $this->clearUrl();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->url)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->url));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->url)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->url);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setUrl(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->url)) return 'url';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasUrl()) {
        $this->setUrl($x->getUrl());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->url) !== isset($x->url)) return false;
      if (isset($this->url) && $this->url !== $x->url) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->url)) {
        $res .= $prefix . "url: " . $this->debugFormatString($this->url) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class ImagesDeleteUrlBaseRequest extends \google\net\ProtocolMessage {
    public function getBlobKey() {
      if (!isset($this->blob_key)) {
        return '';
      }
      return $this->blob_key;
    }
    public function setBlobKey($val) {
      $this->blob_key = $val;
      return $this;
    }
    public function clearBlobKey() {
      unset($this->blob_key);
      return $this;
    }
    public function hasBlobKey() {
      return isset($this->blob_key);
    }
    public function clear() {
      $this->clearBlobKey();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->blob_key)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->blob_key));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->blob_key)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->blob_key);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setBlobKey(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->blob_key)) return 'blob_key';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasBlobKey()) {
        $this->setBlobKey($x->getBlobKey());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->blob_key) !== isset($x->blob_key)) return false;
      if (isset($this->blob_key) && $this->blob_key !== $x->blob_key) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->blob_key)) {
        $res .= $prefix . "blob_key: " . $this->debugFormatString($this->blob_key) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class ImagesDeleteUrlBaseResponse extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
