/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.FileContentsHolder;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.ConversionException;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class SuppressionCommentFilter
extends AutomaticBean
implements Filter {
    private static final String DEFAULT_OFF_FORMAT = "CHECKSTYLE\\:OFF";
    private static final String DEFAULT_ON_FORMAT = "CHECKSTYLE\\:ON";
    private static final String DEFAULT_CHECK_FORMAT = ".*";
    private boolean mCheckC = true;
    private boolean mCheckCPP = true;
    private RE mOffRegexp;
    private RE mOnRegexp;
    private String mCheckFormat;
    private RE mCheckRegexp;
    private String mMessageFormat;
    private List mTags = new ArrayList();
    private WeakReference mFileContentsReference = new WeakReference<Object>(null);

    public SuppressionCommentFilter() {
        this.setOnCommentFormat(DEFAULT_ON_FORMAT);
        this.setOffCommentFormat(DEFAULT_OFF_FORMAT);
        this.setCheckFormat(DEFAULT_CHECK_FORMAT);
    }

    public void setOffCommentFormat(String aFormat) throws ConversionException {
        try {
            this.mOffRegexp = Utils.getRE(aFormat);
        }
        catch (RESyntaxException e) {
            throw new ConversionException("unable to parse " + aFormat, e);
        }
    }

    public void setOnCommentFormat(String aFormat) throws ConversionException {
        try {
            this.mOnRegexp = Utils.getRE(aFormat);
        }
        catch (RESyntaxException e) {
            throw new ConversionException("unable to parse " + aFormat, e);
        }
    }

    public FileContents getFileContents() {
        return (FileContents)this.mFileContentsReference.get();
    }

    public void setFileContents(FileContents aFileContents) {
        this.mFileContentsReference = new WeakReference<FileContents>(aFileContents);
    }

    public void setCheckFormat(String aFormat) throws ConversionException {
        try {
            this.mCheckRegexp = Utils.getRE(aFormat);
            this.mCheckFormat = aFormat;
        }
        catch (RESyntaxException e) {
            throw new ConversionException("unable to parse " + aFormat, e);
        }
    }

    public void setMessageFormat(String aFormat) throws ConversionException {
        try {
            Utils.getRE(aFormat);
        }
        catch (RESyntaxException e) {
            throw new ConversionException("unable to parse " + aFormat, e);
        }
        this.mMessageFormat = aFormat;
    }

    public void setCheckCPP(boolean aCheckCPP) {
        this.mCheckCPP = aCheckCPP;
    }

    public void setCheckC(boolean aCheckC) {
        this.mCheckC = aCheckC;
    }

    public boolean accept(AuditEvent aEvent) {
        Tag matchTag;
        if (aEvent.getLocalizedMessage() == null) {
            return true;
        }
        FileContents currentContents = FileContentsHolder.getContents();
        if (this.getFileContents() != currentContents) {
            this.setFileContents(currentContents);
            this.tagSuppressions();
        }
        return (matchTag = this.findNearestMatch(aEvent)) == null || matchTag.isOn();
    }

    private Tag findNearestMatch(AuditEvent aEvent) {
        Tag tag;
        Tag result = null;
        Iterator iter = this.mTags.iterator();
        while (iter.hasNext() && (tag = (Tag)iter.next()).getLine() <= aEvent.getLine() && (tag.getLine() != tag.getLine() || tag.getColumn() <= aEvent.getColumn())) {
            if (!tag.isMatch(aEvent)) continue;
            result = tag;
        }
        return result;
    }

    private void tagSuppressions() {
        this.mTags.clear();
        FileContents contents = this.getFileContents();
        if (this.mCheckCPP) {
            this.tagSuppressions(contents.getCppComments().values());
        }
        if (this.mCheckC) {
            Collection cComments = contents.getCComments().values();
            Iterator iter = cComments.iterator();
            while (iter.hasNext()) {
                Collection element = (Collection)iter.next();
                this.tagSuppressions(element);
            }
        }
        Collections.sort(this.mTags);
    }

    private void tagSuppressions(Collection aComments) {
        Iterator iter = aComments.iterator();
        while (iter.hasNext()) {
            TextBlock comment = (TextBlock)iter.next();
            int startLineNo = comment.getStartLineNo();
            String[] text = comment.getText();
            this.tagCommentLine(text[0], startLineNo, comment.getStartColNo());
            for (int i = 1; i < text.length; ++i) {
                this.tagCommentLine(text[i], startLineNo + i, 0);
            }
        }
    }

    private void tagCommentLine(String aText, int aLine, int aColumn) {
        if (this.mOffRegexp.match(aText)) {
            this.addTag(this.mOffRegexp.getParen(0), aLine, aColumn, false);
        } else if (this.mOnRegexp.match(aText)) {
            this.addTag(this.mOnRegexp.getParen(0), aLine, aColumn, true);
        }
    }

    private void addTag(String aText, int aLine, int aColumn, boolean aOn) {
        Tag tag = new Tag(aLine, aColumn, aText, aOn);
        this.mTags.add(tag);
    }

    protected void finishLocalSetup() throws CheckstyleException {
        if (this.mOnRegexp.getParenCount() != this.mOffRegexp.getParenCount()) {
            throw new CheckstyleException("onCommentFormat and offCommentFormat have different paren counts.");
        }
    }

    public class Tag
    implements Comparable {
        private String mText;
        private int mLine;
        private int mColumn;
        private boolean mOn;
        private RE mTagCheckRegexp;
        private RE mTagMessageRegexp;

        public Tag(int aLine, int aColumn, String aText, boolean aOn) throws ConversionException {
            this.mLine = aLine;
            this.mColumn = aColumn;
            this.mText = aText;
            this.mOn = aOn;
            this.mTagCheckRegexp = SuppressionCommentFilter.this.mCheckRegexp;
            String format = "";
            try {
                if (aOn) {
                    format = this.expandFromComment(aText, SuppressionCommentFilter.this.mCheckFormat, SuppressionCommentFilter.this.mOnRegexp);
                    this.mTagCheckRegexp = new RE(format);
                    if (SuppressionCommentFilter.this.mMessageFormat != null) {
                        format = this.expandFromComment(aText, SuppressionCommentFilter.this.mMessageFormat, SuppressionCommentFilter.this.mOnRegexp);
                        this.mTagMessageRegexp = new RE(format);
                    }
                } else {
                    format = this.expandFromComment(aText, SuppressionCommentFilter.this.mCheckFormat, SuppressionCommentFilter.this.mOffRegexp);
                    this.mTagCheckRegexp = new RE(format);
                    if (SuppressionCommentFilter.this.mMessageFormat != null) {
                        format = this.expandFromComment(aText, SuppressionCommentFilter.this.mMessageFormat, SuppressionCommentFilter.this.mOffRegexp);
                        this.mTagMessageRegexp = new RE(format);
                    }
                }
            }
            catch (RESyntaxException e) {
                throw new ConversionException("unable to parse expanded comment " + format, e);
            }
        }

        public String getText() {
            return this.mText;
        }

        public int getLine() {
            return this.mLine;
        }

        public int getColumn() {
            return this.mColumn;
        }

        public boolean isOn() {
            return this.mOn;
        }

        public int compareTo(Object aObject) {
            Tag other = (Tag)aObject;
            if (this.mLine == other.mLine) {
                return this.mColumn - other.mColumn;
            }
            return this.mLine - other.mLine;
        }

        public boolean isMatch(AuditEvent aEvent) {
            if (this.mTagCheckRegexp.match(aEvent.getSourceName())) {
                return true;
            }
            if (this.mTagMessageRegexp != null) {
                return this.mTagMessageRegexp.match(aEvent.getMessage());
            }
            return false;
        }

        private String expandFromComment(String aComment, String aString, RE aRegexp) {
            if (!aRegexp.match(aComment)) {
                return aString;
            }
            String result = aString;
            for (int i = 1; i < aRegexp.getParenCount(); ++i) {
                result = result.replaceAll("\\$" + i, aRegexp.getParen(i));
            }
            return result;
        }
    }
}

