/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.apache.commons.beanutils.ConversionException;
import org.apache.regexp.RE;

public abstract class AbstractHeaderCheck
extends Check {
    private String[] mHeaderLines;

    protected String[] getHeaderLines() {
        return this.mHeaderLines;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setHeaderFile(String aFileName) throws ConversionException {
        if (aFileName == null) return;
        if (aFileName.trim().length() == 0) {
            return;
        }
        this.checkHeaderNotInitialized();
        FileReader headerReader = null;
        try {
            try {
                headerReader = new FileReader(aFileName);
                this.loadHeader(headerReader);
            }
            catch (IOException ex) {
                throw new ConversionException("unable to load header file " + aFileName, ex);
            }
            Object var5_3 = null;
            if (headerReader == null) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (headerReader == null) throw throwable;
            try {
                ((Reader)headerReader).close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new ConversionException("unable to close header file " + aFileName, ex);
            }
        }
        try {}
        catch (IOException ex) {
            throw new ConversionException("unable to close header file " + aFileName, ex);
        }
        ((Reader)headerReader).close();
    }

    public void setHeader(String aHeader) {
        if (aHeader == null || aHeader.trim().length() == 0) {
            return;
        }
        this.checkHeaderNotInitialized();
        RE re = Utils.getRE("\\\\n");
        String headerExpandedNewLines = re.subst(aHeader, "\n");
        StringReader headerReader = new StringReader(headerExpandedNewLines);
        try {
            this.loadHeader(headerReader);
        }
        catch (IOException ex) {
            throw new ConversionException("unable to load header", ex);
        }
        finally {
            try {
                ((Reader)headerReader).close();
            }
            catch (IOException ex) {
                throw new ConversionException("unable to close header", ex);
            }
        }
    }

    private void checkHeaderNotInitialized() {
        if (this.mHeaderLines != null) {
            throw new ConversionException("header has already been set - set either header or headerFile, not both");
        }
    }

    private void loadHeader(Reader aHeaderReader) throws IOException {
        String l;
        LineNumberReader lnr = new LineNumberReader(aHeaderReader);
        ArrayList<String> lines = new ArrayList<String>();
        while ((l = lnr.readLine()) != null) {
            lines.add(l);
        }
        this.mHeaderLines = lines.toArray(new String[0]);
    }

    protected final void finishLocalSetup() throws CheckstyleException {
        if (this.mHeaderLines == null) {
            throw new CheckstyleException("property 'headerFile' is missing or invalid in module " + this.getConfiguration().getName());
        }
    }

    public final int[] getDefaultTokens() {
        return new int[0];
    }
}

