/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.system;

public enum CpuArch {
    X86(32),
    X86_64(64),
    ARM64(64),
    OTHER(0),
    UNKNOWN(0);

    public final int width;
    public static final CpuArch CURRENT;

    private CpuArch(int width) {
        if (width == 0) {
            try {
                width = Integer.parseInt(System.getProperty("sun.arch.data.model", "32"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.width = width;
    }

    public static boolean isIntel64() {
        return CURRENT == X86_64;
    }

    public static boolean isArm64() {
        return CURRENT == ARM64;
    }

    public static boolean is32Bit() {
        return CpuArch.CURRENT.width == 32;
    }

    static {
        String arch = System.getProperty("os.arch");
        CURRENT = "x86_64".equals(arch) || "amd64".equals(arch) ? X86_64 : ("i386".equals(arch) || "x86".equals(arch) ? X86 : ("aarch64".equals(arch) || "arm64".equals(arch) ? ARM64 : (arch == null || arch.trim().isEmpty() ? UNKNOWN : OTHER)));
    }
}

