/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt.classpath;

import java.nio.file.Path;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.javacs.kt.classpath.ClassPathEntry;
import org.javacs.kt.classpath.ClassPathResolver;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\tR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\tR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\tR\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0018\u00a8\u0006\u001e"}, d2={"Lorg/javacs/kt/classpath/UnionClassPathResolver;", "Lorg/javacs/kt/classpath/ClassPathResolver;", "lhs", "rhs", "(Lorg/javacs/kt/classpath/ClassPathResolver;Lorg/javacs/kt/classpath/ClassPathResolver;)V", "buildScriptClasspath", "", "Ljava/nio/file/Path;", "getBuildScriptClasspath", "()Ljava/util/Set;", "buildScriptClasspathOrEmpty", "getBuildScriptClasspathOrEmpty", "classpath", "Lorg/javacs/kt/classpath/ClassPathEntry;", "getClasspath", "classpathOrEmpty", "getClasspathOrEmpty", "classpathWithSources", "getClasspathWithSources", "currentBuildFileVersion", "", "getCurrentBuildFileVersion", "()J", "getLhs", "()Lorg/javacs/kt/classpath/ClassPathResolver;", "resolverType", "", "getResolverType", "()Ljava/lang/String;", "getRhs", "shared"})
public final class UnionClassPathResolver
implements ClassPathResolver {
    @NotNull
    private final ClassPathResolver lhs;
    @NotNull
    private final ClassPathResolver rhs;

    public UnionClassPathResolver(@NotNull ClassPathResolver lhs, @NotNull ClassPathResolver rhs) {
        Intrinsics.checkNotNullParameter((Object)lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @NotNull
    public final ClassPathResolver getLhs() {
        return this.lhs;
    }

    @NotNull
    public final ClassPathResolver getRhs() {
        return this.rhs;
    }

    @Override
    @NotNull
    public String getResolverType() {
        return "(" + this.lhs.getResolverType() + " + " + this.rhs.getResolverType() + ")";
    }

    @Override
    @NotNull
    public Set<ClassPathEntry> getClasspath() {
        return SetsKt.plus(this.lhs.getClasspath(), (Iterable)this.rhs.getClasspath());
    }

    @Override
    @NotNull
    public Set<ClassPathEntry> getClasspathOrEmpty() {
        return SetsKt.plus(this.lhs.getClasspathOrEmpty(), (Iterable)this.rhs.getClasspathOrEmpty());
    }

    @Override
    @NotNull
    public Set<Path> getBuildScriptClasspath() {
        return SetsKt.plus(this.lhs.getBuildScriptClasspath(), (Iterable)this.rhs.getBuildScriptClasspath());
    }

    @Override
    @NotNull
    public Set<Path> getBuildScriptClasspathOrEmpty() {
        return SetsKt.plus(this.lhs.getBuildScriptClasspathOrEmpty(), (Iterable)this.rhs.getBuildScriptClasspathOrEmpty());
    }

    @Override
    @NotNull
    public Set<ClassPathEntry> getClasspathWithSources() {
        return SetsKt.plus(this.lhs.getClasspathWithSources(), (Iterable)this.rhs.getClasspathWithSources());
    }

    @Override
    public long getCurrentBuildFileVersion() {
        return Math.max(this.lhs.getCurrentBuildFileVersion(), this.rhs.getCurrentBuildFileVersion());
    }
}

