/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt.diagnostic;

import com.intellij.openapi.util.TextRange;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.DiagnosticTag;
import org.javacs.kt.position.PositionKt;
import org.javacs.kt.util.PsiUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"code", "", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "convertDiagnostic", "", "Lkotlin/Pair;", "Ljava/net/URI;", "Lorg/eclipse/lsp4j/Diagnostic;", "message", "severity", "Lorg/eclipse/lsp4j/DiagnosticSeverity;", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "server"})
@SourceDebugExtension(value={"SMAP\nConvertDiagnostic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertDiagnostic.kt\norg/javacs/kt/diagnostic/ConvertDiagnosticKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,49:1\n1549#2:50\n1620#2,3:51\n*S KotlinDebug\n*F\n+ 1 ConvertDiagnostic.kt\norg/javacs/kt/diagnostic/ConvertDiagnosticKt\n*L\n18#1:50\n18#1:51,3\n*E\n"})
public final class ConvertDiagnosticKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Pair<URI, Diagnostic>> convertDiagnostic(@NotNull org.jetbrains.kotlin.diagnostics.Diagnostic diagnostic) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        URI uri = PsiUtilsKt.toPath(diagnostic.getPsiFile()).toUri();
        String content = diagnostic.getPsiFile().getText();
        Iterable $this$map$iv = diagnostic.getTextRanges();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Diagnostic diagnostic2;
            TextRange textRange = (TextRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)content, (String)"content");
            Diagnostic $this$convertDiagnostic_u24lambda_u241_u24lambda_u240 = diagnostic2 = new Diagnostic(PositionKt.range(content, (TextRange)it), ConvertDiagnosticKt.message(diagnostic), ConvertDiagnosticKt.severity(diagnostic.getSeverity()), "kotlin", ConvertDiagnosticKt.code(diagnostic));
            boolean bl2 = false;
            String factoryName = diagnostic.getFactory().getName();
            $this$convertDiagnostic_u24lambda_u241_u24lambda_u240.setTags((List)new ArrayList());
            if (StringsKt.contains$default((CharSequence)factoryName, (CharSequence)"UNUSED_", (boolean)false, (int)2, null)) {
                $this$convertDiagnostic_u24lambda_u241_u24lambda_u240.getTags().add(DiagnosticTag.Unnecessary);
            }
            if (StringsKt.contains$default((CharSequence)factoryName, (CharSequence)"DEPRECATION", (boolean)false, (int)2, null)) {
                $this$convertDiagnostic_u24lambda_u241_u24lambda_u240.getTags().add(DiagnosticTag.Deprecated);
            }
            Diagnostic d = diagnostic2;
            collection.add(new Pair((Object)uri, (Object)d));
        }
        return (List)destination$iv$iv;
    }

    private static final String code(org.jetbrains.kotlin.diagnostics.Diagnostic diagnostic) {
        return diagnostic.getFactory().getName();
    }

    private static final String message(org.jetbrains.kotlin.diagnostics.Diagnostic diagnostic) {
        String string = DefaultErrorMessages.render((UnboundDiagnostic)((UnboundDiagnostic)diagnostic));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"render(diagnostic)");
        return string;
    }

    private static final DiagnosticSeverity severity(Severity severity) {
        DiagnosticSeverity diagnosticSeverity;
        switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
            case 1: {
                diagnosticSeverity = DiagnosticSeverity.Information;
                break;
            }
            case 2: {
                diagnosticSeverity = DiagnosticSeverity.Error;
                break;
            }
            case 3: {
                diagnosticSeverity = DiagnosticSeverity.Warning;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return diagnosticSeverity;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Severity.values().length];
            try {
                nArray[Severity.INFO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.WARNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

