/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.serialization.Interner;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.DescriptorAwareStringTable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0004H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/serialization/StringTableImpl;", "Lorg/jetbrains/kotlin/serialization/DescriptorAwareStringTable;", "()V", "isLocalClassIdReplacementKeptGeneric", "", "()Z", "qualifiedNames", "Lorg/jetbrains/kotlin/metadata/serialization/Interner;", "Lorg/jetbrains/kotlin/serialization/StringTableImpl$FqNameProto;", "strings", "", "buildProto", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$StringTable;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$QualifiedNameTable;", "getPackageFqNameIndex", "", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "getQualifiedClassNameIndex", "className", "isLocal", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getStringIndex", "string", "FqNameProto", "serialization"})
public class StringTableImpl
implements DescriptorAwareStringTable {
    @NotNull
    private final Interner<String> strings = new Interner(null, 1, null);
    @NotNull
    private final Interner<FqNameProto> qualifiedNames = new Interner(null, 1, null);

    @Override
    public int getStringIndex(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
        return this.strings.intern(string2);
    }

    @Override
    public int getQualifiedClassNameIndex(@NotNull String className2, boolean isLocal) {
        Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
        ClassId classId = ClassId.fromString(className2, isLocal);
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"fromString(className, isLocal)");
        return this.getQualifiedClassNameIndex(classId);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getQualifiedClassNameIndex(@NotNull ClassId classId) {
        int n;
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder2 = ProtoBuf.QualifiedNameTable.QualifiedName.newBuilder();
        builder2.setKind(ProtoBuf.QualifiedNameTable.QualifiedName.Kind.CLASS);
        ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder3 = builder2;
        ClassId classId2 = classId.getOuterClassId();
        if (classId2 != null) {
            void p0;
            ClassId classId3 = classId2;
            ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder4 = builder3;
            boolean bl = false;
            int n2 = this.getQualifiedClassNameIndex((ClassId)p0);
            builder3 = builder4;
            n = n2;
        } else {
            FqName fqName2 = classId.getPackageFqName();
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"classId.packageFqName");
            n = this.getPackageFqNameIndex(fqName2);
        }
        builder3.setParentQualifiedName(n);
        String string2 = classId.getShortClassName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classId.shortClassName.asString()");
        builder2.setShortName(this.getStringIndex(string2));
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"builder");
        return this.qualifiedNames.intern(new FqNameProto(builder2));
    }

    public final int getPackageFqNameIndex(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        int result2 = -1;
        for (Name segment : fqName2.pathSegments()) {
            ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder2 = ProtoBuf.QualifiedNameTable.QualifiedName.newBuilder();
            String string2 = segment.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"segment.asString()");
            builder2.setShortName(this.getStringIndex(string2));
            if (result2 != -1) {
                builder2.setParentQualifiedName(result2);
            }
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"builder");
            result2 = this.qualifiedNames.intern(new FqNameProto(builder2));
        }
        return result2;
    }

    @NotNull
    public final Pair<ProtoBuf.StringTable, ProtoBuf.QualifiedNameTable> buildProto() {
        ProtoBuf.StringTable.Builder strings2 = ProtoBuf.StringTable.newBuilder();
        for (String simpleName : this.strings.getAllInternedObjects()) {
            strings2.addString(simpleName);
        }
        ProtoBuf.QualifiedNameTable.Builder qualifiedNames = ProtoBuf.QualifiedNameTable.newBuilder();
        for (FqNameProto fqName2 : this.qualifiedNames.getAllInternedObjects()) {
            qualifiedNames.addQualifiedName(fqName2.getFqName());
        }
        return new Pair((Object)strings2.build(), (Object)qualifiedNames.build());
    }

    @Override
    public boolean isLocalClassIdReplacementKeptGeneric() {
        return false;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/serialization/StringTableImpl$FqNameProto;", "", "fqName", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$QualifiedNameTable$QualifiedName$Builder;", "(Lorg/jetbrains/kotlin/metadata/ProtoBuf$QualifiedNameTable$QualifiedName$Builder;)V", "getFqName", "()Lorg/jetbrains/kotlin/metadata/ProtoBuf$QualifiedNameTable$QualifiedName$Builder;", "equals", "", "other", "hashCode", "", "serialization"})
    private static final class FqNameProto {
        @NotNull
        private final ProtoBuf.QualifiedNameTable.QualifiedName.Builder fqName;

        public FqNameProto(@NotNull ProtoBuf.QualifiedNameTable.QualifiedName.Builder fqName2) {
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            this.fqName = fqName2;
        }

        @NotNull
        public final ProtoBuf.QualifiedNameTable.QualifiedName.Builder getFqName() {
            return this.fqName;
        }

        public int hashCode() {
            int result2 = 13;
            result2 = 31 * result2 + this.fqName.getParentQualifiedName();
            result2 = 31 * result2 + this.fqName.getShortName();
            result2 = 31 * result2 + this.fqName.getKind().hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (other == null || !(other instanceof FqNameProto)) {
                return false;
            }
            ProtoBuf.QualifiedNameTable.QualifiedName.Builder otherFqName = ((FqNameProto)other).fqName;
            return this.fqName.getParentQualifiedName() == otherFqName.getParentQualifiedName() && this.fqName.getShortName() == otherFqName.getShortName() && this.fqName.getKind() == otherFqName.getKind();
        }
    }
}

