/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.deprecation;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.resolve.calls.checkers.OperatorCallCheckerKt;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;
import org.jetbrains.kotlin.resolve.deprecation.DescriptorBasedDeprecationInfo;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0001H\u00c6\u0003J\u001d\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/resolve/deprecation/DeprecatedOperatorMod;", "Lorg/jetbrains/kotlin/resolve/deprecation/DescriptorBasedDeprecationInfo;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "currentDeprecation", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/deprecation/DescriptorBasedDeprecationInfo;)V", "getCurrentDeprecation", "()Lorg/jetbrains/kotlin/resolve/deprecation/DescriptorBasedDeprecationInfo;", "deprecationLevel", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationLevelValue;", "getDeprecationLevel", "()Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationLevelValue;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "message", "", "getMessage", "()Ljava/lang/String;", "target", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getTarget", "()Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "frontend"})
public final class DeprecatedOperatorMod
extends DescriptorBasedDeprecationInfo {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final DescriptorBasedDeprecationInfo currentDeprecation;

    public DeprecatedOperatorMod(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull DescriptorBasedDeprecationInfo currentDeprecation) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)currentDeprecation, (String)"currentDeprecation");
        this.languageVersionSettings = languageVersionSettings;
        this.currentDeprecation = currentDeprecation;
        boolean bl = OperatorCallCheckerKt.shouldWarnAboutDeprecatedModFromBuiltIns(this.languageVersionSettings);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "Deprecation created for mod that shouldn't have any deprecations; languageVersionSettings: " + this.languageVersionSettings;
            throw new AssertionError((Object)string2);
        }
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    @NotNull
    public final DescriptorBasedDeprecationInfo getCurrentDeprecation() {
        return this.currentDeprecation;
    }

    @Override
    @NotNull
    public DeprecationLevelValue getDeprecationLevel() {
        ApiVersion apiVersion = this.languageVersionSettings.getApiVersion();
        return (Intrinsics.areEqual((Object)apiVersion, (Object)ApiVersion.KOTLIN_1_1) ? true : Intrinsics.areEqual((Object)apiVersion, (Object)ApiVersion.KOTLIN_1_2)) ? DeprecationLevelValue.WARNING : (Intrinsics.areEqual((Object)apiVersion, (Object)ApiVersion.KOTLIN_1_3) ? DeprecationLevelValue.ERROR : DeprecationLevelValue.ERROR);
    }

    @Override
    @Nullable
    public String getMessage() {
        return this.currentDeprecation.getMessage();
    }

    @Override
    @NotNull
    public DeclarationDescriptor getTarget() {
        return this.currentDeprecation.getTarget();
    }

    @NotNull
    public final LanguageVersionSettings component1() {
        return this.languageVersionSettings;
    }

    @NotNull
    public final DescriptorBasedDeprecationInfo component2() {
        return this.currentDeprecation;
    }

    @NotNull
    public final DeprecatedOperatorMod copy(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull DescriptorBasedDeprecationInfo currentDeprecation) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)currentDeprecation, (String)"currentDeprecation");
        return new DeprecatedOperatorMod(languageVersionSettings, currentDeprecation);
    }

    public static /* synthetic */ DeprecatedOperatorMod copy$default(DeprecatedOperatorMod deprecatedOperatorMod, LanguageVersionSettings languageVersionSettings, DescriptorBasedDeprecationInfo descriptorBasedDeprecationInfo, int n, Object object) {
        if ((n & 1) != 0) {
            languageVersionSettings = deprecatedOperatorMod.languageVersionSettings;
        }
        if ((n & 2) != 0) {
            descriptorBasedDeprecationInfo = deprecatedOperatorMod.currentDeprecation;
        }
        return deprecatedOperatorMod.copy(languageVersionSettings, descriptorBasedDeprecationInfo);
    }

    @NotNull
    public String toString() {
        return "DeprecatedOperatorMod(languageVersionSettings=" + this.languageVersionSettings + ", currentDeprecation=" + this.currentDeprecation + ')';
    }

    public int hashCode() {
        int result2 = this.languageVersionSettings.hashCode();
        result2 = result2 * 31 + this.currentDeprecation.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DeprecatedOperatorMod)) {
            return false;
        }
        DeprecatedOperatorMod deprecatedOperatorMod = (DeprecatedOperatorMod)other;
        if (!Intrinsics.areEqual((Object)this.languageVersionSettings, (Object)deprecatedOperatorMod.languageVersionSettings)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.currentDeprecation, (Object)deprecatedOperatorMod.currentDeprecation);
    }
}

