/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.smartcasts;

import com.google.common.collect.Multimap;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueKindUtilsKt;
import org.jetbrains.kotlin.resolve.calls.smartcasts.IdentifierInfo;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ContextReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0014\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u001a(\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a*\u0010\u0013\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0012\u0010\u0016\u001a\u00020\n2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\"\u0010\u0016\u001a\u00020\n2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a*\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020!H\u0002\u00a8\u0006\""}, d2={"findReceiverByLabelOrGetDefault", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "descriptorOfThisReceiver", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "default", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "labelName", "", "getIdForImplicitReceiver", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/IdentifierInfo;", "receiverValue", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "getIdForSimpleNameExpression", "simpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "containingDeclarationOrModule", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getIdForStableIdentifier", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getIdForThisReceiver", "postfix", "argumentInfo", "op", "Lorg/jetbrains/kotlin/lexer/KtToken;", "qualified", "receiverInfo", "receiverType", "Lorg/jetbrains/kotlin/types/KotlinType;", "selectorInfo", "safe", "", "frontend"})
public final class IdentifierInfoKt {
    @NotNull
    public static final IdentifierInfo getIdForStableIdentifier(@Nullable KtExpression expression2, @NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor containingDeclarationOrModule, @NotNull LanguageVersionSettings languageVersionSettings) {
        IdentifierInfo identifierInfo;
        KtExpression deparenthesized;
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkNotNullParameter((Object)containingDeclarationOrModule, (String)"containingDeclarationOrModule");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        if (expression2 != null && expression2 != (deparenthesized = KtPsiUtil.deparenthesize(expression2))) {
            return IdentifierInfoKt.getIdForStableIdentifier(deparenthesized, bindingContext, containingDeclarationOrModule, languageVersionSettings);
        }
        KtExpression ktExpression = expression2;
        if (ktExpression instanceof KtQualifiedExpression) {
            KtExpression receiverExpression = ((KtQualifiedExpression)expression2).getReceiverExpression();
            KtExpression selectorExpression = ((KtQualifiedExpression)expression2).getSelectorExpression();
            IdentifierInfo receiverInfo = IdentifierInfoKt.getIdForStableIdentifier(receiverExpression, bindingContext, containingDeclarationOrModule, languageVersionSettings);
            IdentifierInfo selectorInfo = IdentifierInfoKt.getIdForStableIdentifier(selectorExpression, bindingContext, containingDeclarationOrModule, languageVersionSettings);
            identifierInfo = IdentifierInfoKt.qualified(receiverInfo, bindingContext.getType(receiverExpression), selectorInfo, ((KtQualifiedExpression)expression2).getOperationSign() == KtTokens.SAFE_ACCESS);
        } else if (ktExpression instanceof KtBinaryExpressionWithTypeRHS) {
            KtExpression ktExpression2 = ((KtBinaryExpressionWithTypeRHS)expression2).getLeft();
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"expression.left");
            KtExpression subjectExpression = ktExpression2;
            KtTypeReference targetTypeReference = ((KtBinaryExpressionWithTypeRHS)expression2).getRight();
            IElementType operationToken = ((KtBinaryExpressionWithTypeRHS)expression2).getOperationReference().getReferencedNameElementType();
            identifierInfo = Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.IS_KEYWORD) || Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.AS_KEYWORD) ? (IdentifierInfo)IdentifierInfo.NO.INSTANCE : (IdentifierInfo)new IdentifierInfo.SafeCast(IdentifierInfoKt.getIdForStableIdentifier(subjectExpression, bindingContext, containingDeclarationOrModule, languageVersionSettings), bindingContext.getType(subjectExpression), (KotlinType)bindingContext.get(BindingContext.TYPE, targetTypeReference));
        } else if (ktExpression instanceof KtSimpleNameExpression) {
            identifierInfo = IdentifierInfoKt.getIdForSimpleNameExpression((KtSimpleNameExpression)expression2, bindingContext, containingDeclarationOrModule, languageVersionSettings);
        } else if (ktExpression instanceof KtThisExpression) {
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)bindingContext.get(BindingContext.REFERENCE_TARGET, ((KtThisExpression)expression2).getInstanceReference());
            String labelName = ((KtThisExpression)expression2).getLabelName();
            identifierInfo = labelName == null ? IdentifierInfoKt.getIdForThisReceiver(declarationDescriptor) : IdentifierInfoKt.getIdForThisReceiver(declarationDescriptor, bindingContext, labelName);
        } else {
            IElementType operationType;
            identifierInfo = ktExpression instanceof KtPostfixExpression ? ((operationType = ((KtPostfixExpression)expression2).getOperationReference().getReferencedNameElementType()) == KtTokens.PLUSPLUS || operationType == KtTokens.MINUSMINUS ? IdentifierInfoKt.postfix(IdentifierInfoKt.getIdForStableIdentifier(((KtPostfixExpression)expression2).getBaseExpression(), bindingContext, containingDeclarationOrModule, languageVersionSettings), (KtToken)operationType) : (IdentifierInfo)IdentifierInfo.NO.INSTANCE) : (IdentifierInfo)IdentifierInfo.NO.INSTANCE;
        }
        return identifierInfo;
    }

    private static final IdentifierInfo getIdForSimpleNameExpression(KtSimpleNameExpression simpleNameExpression, BindingContext bindingContext, DeclarationDescriptor containingDeclarationOrModule, LanguageVersionSettings languageVersionSettings) {
        IdentifierInfo identifierInfo;
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)bindingContext.get(BindingContext.REFERENCE_TARGET, simpleNameExpression);
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
        if (declarationDescriptor2 instanceof VariableDescriptor) {
            ReceiverValue implicitReceiver;
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(simpleNameExpression, bindingContext);
            ModuleDescriptor usageModuleDescriptor = DescriptorUtils.getContainingModuleOrNull(containingDeclarationOrModule);
            IdentifierInfo.Variable selectorInfo = new IdentifierInfo.Variable((VariableDescriptor)declarationDescriptor, DataFlowValueKindUtilsKt.variableKind((VariableDescriptor)declarationDescriptor, usageModuleDescriptor, bindingContext, simpleNameExpression, languageVersionSettings), (DataFlowValue)bindingContext.get(BindingContext.BOUND_INITIALIZER_VALUE, declarationDescriptor));
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
            ReceiverValue receiverValue = implicitReceiver = resolvedCall3 != null ? resolvedCall3.getDispatchReceiver() : null;
            if (implicitReceiver == null) {
                identifierInfo = selectorInfo;
            } else {
                IdentifierInfo receiverInfo = IdentifierInfoKt.getIdForImplicitReceiver(implicitReceiver);
                if (receiverInfo == null) {
                    identifierInfo = selectorInfo;
                } else {
                    KotlinType kotlinType = implicitReceiver.getType();
                    IdentifierInfo identifierInfo2 = selectorInfo;
                    Call call2 = resolvedCall2.getCall();
                    Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"resolvedCall.call");
                    identifierInfo = IdentifierInfoKt.qualified(receiverInfo, kotlinType, identifierInfo2, CallUtilKt.isSafeCall(call2));
                }
            }
        } else {
            identifierInfo = declarationDescriptor2 instanceof ClassDescriptor ? (((ClassDescriptor)declarationDescriptor).getKind() == ClassKind.ENUM_ENTRY && languageVersionSettings.supportsFeature(LanguageFeature.SoundSmartcastForEnumEntries) ? (IdentifierInfo)new IdentifierInfo.EnumEntry((ClassDescriptor)declarationDescriptor) : (IdentifierInfo)new IdentifierInfo.PackageOrClass(declarationDescriptor)) : (declarationDescriptor2 instanceof PackageViewDescriptor ? (IdentifierInfo)new IdentifierInfo.PackageOrClass(declarationDescriptor) : (IdentifierInfo)IdentifierInfo.NO.INSTANCE);
        }
        return identifierInfo;
    }

    private static final IdentifierInfo getIdForImplicitReceiver(ReceiverValue receiverValue) {
        ReceiverValue receiverValue2 = receiverValue;
        return receiverValue2 instanceof ContextReceiver ? (IdentifierInfo)new IdentifierInfo.Receiver(receiverValue) : (receiverValue2 instanceof ImplicitReceiver ? IdentifierInfoKt.getIdForThisReceiver(((ImplicitReceiver)receiverValue).getDeclarationDescriptor()) : null);
    }

    private static final IdentifierInfo getIdForThisReceiver(DeclarationDescriptor descriptorOfThisReceiver) {
        IdentifierInfo identifierInfo;
        DeclarationDescriptor declarationDescriptor = descriptorOfThisReceiver;
        if (declarationDescriptor instanceof CallableDescriptor) {
            ReceiverParameterDescriptor receiverParameterDescriptor = ((CallableDescriptor)descriptorOfThisReceiver).getExtensionReceiverParameter();
            if (receiverParameterDescriptor == null) {
                throw new IllegalStateException(("'This' refers to the callable member without a receiver parameter: " + descriptorOfThisReceiver).toString());
            }
            ReceiverParameterDescriptor receiverParameter = receiverParameterDescriptor;
            ReceiverValue receiverValue = receiverParameter.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)receiverValue, (String)"receiverParameter.value");
            identifierInfo = new IdentifierInfo.Receiver(receiverValue);
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            ReceiverValue receiverValue = ((ClassDescriptor)descriptorOfThisReceiver).getThisAsReceiverParameter().getValue();
            Intrinsics.checkNotNullExpressionValue((Object)receiverValue, (String)"descriptorOfThisReceiver\u2026AsReceiverParameter.value");
            identifierInfo = new IdentifierInfo.Receiver(receiverValue);
        } else {
            identifierInfo = IdentifierInfo.NO.INSTANCE;
        }
        return identifierInfo;
    }

    private static final IdentifierInfo getIdForThisReceiver(DeclarationDescriptor descriptorOfThisReceiver, BindingContext bindingContext, String labelName) {
        IdentifierInfo identifierInfo;
        DeclarationDescriptor declarationDescriptor = descriptorOfThisReceiver;
        if (declarationDescriptor instanceof CallableDescriptor) {
            ReceiverParameterDescriptor receiverParameter = IdentifierInfoKt.findReceiverByLabelOrGetDefault(descriptorOfThisReceiver, ((CallableDescriptor)descriptorOfThisReceiver).getExtensionReceiverParameter(), bindingContext, labelName);
            ReceiverValue receiverValue = receiverParameter.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)receiverValue, (String)"receiverParameter.value");
            identifierInfo = new IdentifierInfo.Receiver(receiverValue);
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            ReceiverParameterDescriptor receiverParameter = IdentifierInfoKt.findReceiverByLabelOrGetDefault(descriptorOfThisReceiver, ((ClassDescriptor)descriptorOfThisReceiver).getThisAsReceiverParameter(), bindingContext, labelName);
            ReceiverValue receiverValue = receiverParameter.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)receiverValue, (String)"receiverParameter.value");
            identifierInfo = new IdentifierInfo.Receiver(receiverValue);
        } else {
            identifierInfo = IdentifierInfo.NO.INSTANCE;
        }
        return identifierInfo;
    }

    private static final ReceiverParameterDescriptor findReceiverByLabelOrGetDefault(DeclarationDescriptor descriptorOfThisReceiver, ReceiverParameterDescriptor receiverParameterDescriptor, BindingContext bindingContext, String labelName) {
        Multimap labelNameToReceiverMap;
        Object object;
        DeclarationDescriptor declarationDescriptor;
        ReadOnlySlice readOnlySlice = BindingContext.DESCRIPTOR_TO_CONTEXT_RECEIVER_MAP;
        if (descriptorOfThisReceiver instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)descriptorOfThisReceiver).getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"descriptorOfThisReceiver.correspondingProperty");
            declarationDescriptor = propertyDescriptor;
        } else {
            declarationDescriptor = descriptorOfThisReceiver;
        }
        if (((object = (labelNameToReceiverMap = (Multimap)bindingContext.get(readOnlySlice, declarationDescriptor))) == null || (object = object.get(labelName)) == null || (object = (ReceiverParameterDescriptor)CollectionsKt.singleOrNull((Iterable)((Iterable)object))) == null) && (object = receiverParameterDescriptor) == null) {
            throw new IllegalStateException(("'This' refers to the callable member without a receiver parameter: " + descriptorOfThisReceiver).toString());
        }
        return object;
    }

    private static final IdentifierInfo postfix(IdentifierInfo argumentInfo, KtToken op) {
        return Intrinsics.areEqual((Object)argumentInfo, (Object)IdentifierInfo.NO.INSTANCE) ? (IdentifierInfo)IdentifierInfo.NO.INSTANCE : (IdentifierInfo)new IdentifierInfo.PostfixIdentifierInfo(argumentInfo, op);
    }

    private static final IdentifierInfo qualified(IdentifierInfo receiverInfo, KotlinType receiverType, IdentifierInfo selectorInfo, boolean safe) {
        IdentifierInfo identifierInfo = receiverInfo;
        return Intrinsics.areEqual((Object)identifierInfo, (Object)IdentifierInfo.NO.INSTANCE) ? (IdentifierInfo)IdentifierInfo.NO.INSTANCE : (identifierInfo instanceof IdentifierInfo.PackageOrClass ? selectorInfo : (IdentifierInfo)new IdentifierInfo.Qualified(receiverInfo, selectorInfo, safe, receiverType));
    }
}

