/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.codegen.IrToJs;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrNamerBase;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTable;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsImport;
import org.jetbrains.kotlin.js.backend.ast.JsName;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/NewNamerImpl;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/IrNamerBase;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "unit", "Lorg/jetbrains/kotlin/ir/backend/js/codegen/IrToJs$CodegenUnit;", "exportId", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "", "stableNames", "", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;Lorg/jetbrains/kotlin/ir/backend/js/codegen/IrToJs$CodegenUnit;Lkotlin/jvm/functions/Function1;Ljava/util/Set;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "getExportId", "()Lkotlin/jvm/functions/Function1;", "internalImports", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsImport;", "getInternalImports", "()Ljava/util/Map;", "staticNames", "Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getStaticNames", "()Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;", "getUnit", "()Lorg/jetbrains/kotlin/ir/backend/js/codegen/IrToJs$CodegenUnit;", "getNameForMemberField", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getNameForMemberFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getNameForStaticDeclaration", "declaration", "backend.js"})
public final class NewNamerImpl
extends IrNamerBase {
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private final IrToJs.CodegenUnit unit;
    @NotNull
    private final Function1<IrDeclarationWithName, String> exportId;
    @NotNull
    private final NameTable<IrDeclaration> staticNames;
    @NotNull
    private final Map<String, JsImport> internalImports;

    public NewNamerImpl(@NotNull JsIrBackendContext context, @NotNull IrToJs.CodegenUnit unit2, @NotNull Function1<? super IrDeclarationWithName, String> exportId, @NotNull Set<String> stableNames) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)unit2, (String)"unit");
        Intrinsics.checkNotNullParameter(exportId, (String)"exportId");
        Intrinsics.checkNotNullParameter(stableNames, (String)"stableNames");
        this.context = context;
        this.unit = unit2;
        this.exportId = exportId;
        this.staticNames = new NameTable(null, CollectionsKt.toMutableSet((Iterable)stableNames), null, 5, null);
        this.internalImports = new LinkedHashMap();
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrToJs.CodegenUnit getUnit() {
        return this.unit;
    }

    @NotNull
    public final Function1<IrDeclarationWithName, String> getExportId() {
        return this.exportId;
    }

    @NotNull
    public final NameTable<IrDeclaration> getStaticNames() {
        return this.staticNames;
    }

    @NotNull
    public final Map<String, JsImport> getInternalImports() {
        return this.internalImports;
    }

    @Override
    @NotNull
    public JsName getNameForMemberFunction(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        if (!(function2.getDispatchReceiverParameter() != null)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        String name = NameTablesKt.jsFunctionSignature(function2, this.context);
        return IrNamerBase.toJsName$default(this, name, false, 1, null);
    }

    @Override
    @NotNull
    public JsName getNameForMemberField(@NotNull IrField field2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
        try {
            string2 = (String)this.exportId.invoke((Object)field2);
        }
        catch (IllegalStateException e) {
            string2 = field2.getName().asString() + "_LIKELY_ELIMINATED_BY_DCE";
        }
        String fieldName = NameTablesKt.sanitizeName$default(string2, false, 2, null);
        return new JsName("f_" + fieldName, false);
    }

    @Override
    @NotNull
    public JsName getNameForStaticDeclaration(@NotNull IrDeclarationWithName declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        String string2 = this.staticNames.getNames().get(declaration);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            return new JsName(it, false);
        }
        if (IrUtilsKt.isEffectivelyExternal(declaration)) {
            IrFile maybeParentFile;
            String jsModule = AnnotationUtilsKt.getJsModule(declaration);
            IrDeclarationParent it = declaration.getParent();
            IrFile irFile = maybeParentFile = it instanceof IrFile ? (IrFile)it : null;
            String fileJsModule = irFile != null ? AnnotationUtilsKt.getJsModule(irFile) : null;
            IrFile irFile2 = maybeParentFile;
            String jsQualifier = irFile2 != null ? AnnotationUtilsKt.getJsQualifier(irFile2) : null;
            if (jsModule != null) {
                String string3 = declaration.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"declaration.name.asString()");
                this.staticNames.declareFreshName(declaration, string3);
                NewNamerImpl.getNameForStaticDeclaration$registerImport(this, declaration, jsModule, "default");
            } else if (fileJsModule != null) {
                String string4 = declaration.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"declaration.name.asString()");
                this.staticNames.declareFreshName(declaration, string4);
                String string5 = AnnotationUtilsKt.getJsNameOrKotlinName(declaration).getIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"declaration.getJsNameOrKotlinName().identifier");
                NewNamerImpl.getNameForStaticDeclaration$registerImport(this, declaration, fileJsModule, string5);
            } else {
                String string6 = AnnotationUtilsKt.getJsNameOrKotlinName(declaration).getIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"declaration.getJsNameOrKotlinName().identifier");
                String name = string6;
                if (jsQualifier != null) {
                    name = jsQualifier + '.' + name;
                }
                this.staticNames.declareStableName(declaration, name);
            }
        } else {
            String string7 = NameTablesKt.nameIfPropertyAccessor(declaration);
            if (string7 == null) {
                String string8 = declaration.getName().asString();
                string7 = string8;
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"declaration.name.asString()");
            }
            String name = string7;
            this.staticNames.declareFreshName(declaration, name);
            IrToJs.CodegenUnitReference unitReference = this.unit.referenceCodegenUnitOfDeclaration(declaration);
            if (unitReference instanceof IrToJs.OtherUnitReference) {
                NewNamerImpl.getNameForStaticDeclaration$registerImport(this, declaration, ((IrToJs.OtherUnitReference)unitReference).getImportPath(), (String)this.exportId.invoke((Object)declaration));
            }
        }
        String string9 = this.staticNames.getNames().get(declaration);
        Intrinsics.checkNotNull((Object)string9);
        return new JsName(string9, false);
    }

    private static final void getNameForStaticDeclaration$registerImport(NewNamerImpl this$0, IrDeclarationWithName $declaration, String moduleId, String importedName) {
        JsImport jsImport;
        String fullModuleId = StringsKt.startsWith$default((String)moduleId, (String)".", (boolean)false, (int)2, null) ? this$0.unit.getPathToKotlinModulesRoot() + moduleId : moduleId;
        Map<String, JsImport> $this$getOrPut$iv = this$0.internalImports;
        boolean $i$f$getOrPut = false;
        JsImport value$iv = $this$getOrPut$iv.get(fullModuleId);
        if (value$iv == null) {
            boolean bl = false;
            JsImport answer$iv = new JsImport(fullModuleId, null, 2, null);
            $this$getOrPut$iv.put(fullModuleId, answer$iv);
            jsImport = answer$iv;
        } else {
            jsImport = value$iv;
        }
        JsImport jsImport2 = jsImport;
        Collection collection = jsImport2.getElements();
        String string2 = this$0.staticNames.getNames().get($declaration);
        Intrinsics.checkNotNull((Object)string2);
        collection.add(new JsImport.Element(importedName, string2));
    }
}

