/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt.classpath;

import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.javacs.kt.LoggerKt;
import org.javacs.kt.classpath.BackupClassPathResolverKt;
import org.javacs.kt.classpath.HomeKt;
import org.javacs.kt.classpath.LocalArtifactDirectoryResolution;
import org.javacs.kt.util.ShellPathUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001H\u0002\u001a\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\rH\u0002\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\rH\u0002\u001a\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001\u001a\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rH\u0002\u001a\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rH\u0002\u001a\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rH\u0002\u001a\"\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0017H\u0002\u001a\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u0001*\u00020\u0001H\u0002\u001a\u001c\u0010\u001c\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001*\u00020\u00012\u0006\u0010\u001d\u001a\u00020\rH\u0002\"#\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001e"}, d2={"gradleCaches", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getGradleCaches", "()Ljava/nio/file/Path;", "gradleCaches$delegate", "Lkotlin/Lazy;", "compareVersions", "", "left", "right", "extractVersion", "", "", "artifactVersionDir", "findAlternativeLibraryLocation", "name", "findKotlinCliCompilerLibrary", "findKotlinStdlib", "findLocalArtifact", "group", "artifact", "findLocalArtifactDirUsingGradle", "Lorg/javacs/kt/classpath/LocalArtifactDirectoryResolution;", "findLocalArtifactDirUsingMaven", "tryFindingLocalArtifactUsing", "artifactDirResolution", "existsOrNull", "resolveStartingWith", "prefix", "shared"})
@SourceDebugExtension(value={"SMAP\nBackupClassPathResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackupClassPathResolver.kt\norg/javacs/kt/classpath/BackupClassPathResolverKt\n+ 2 Utils.kt\norg/javacs/kt/util/UtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n90#2,12:122\n90#2,12:134\n1#3:146\n*S KotlinDebug\n*F\n+ 1 BackupClassPathResolver.kt\norg/javacs/kt/classpath/BackupClassPathResolverKt\n*L\n24#1:122,12\n25#1:134,12\n*E\n"})
public final class BackupClassPathResolverKt {
    @NotNull
    private static final Lazy gradleCaches$delegate = LazyKt.lazy((Function0)gradleCaches.2.INSTANCE);

    @Nullable
    public static final Path findKotlinStdlib() {
        Path path = BackupClassPathResolverKt.findLocalArtifact("org.jetbrains.kotlin", "kotlin-stdlib");
        if (path == null && (path = BackupClassPathResolverKt.findKotlinCliCompilerLibrary("kotlin-stdlib")) == null) {
            path = BackupClassPathResolverKt.findAlternativeLibraryLocation("kotlin-stdlib");
        }
        return path;
    }

    private static final Path findLocalArtifact(String group, String artifact) {
        Path path;
        block8: {
            Path path2;
            Object[] objectArray;
            Path resolved$iv;
            boolean $i$f$tryResolving;
            String what$iv;
            block7: {
                what$iv = artifact + " using Maven";
                $i$f$tryResolving = false;
                try {
                    boolean bl = false;
                    resolved$iv = BackupClassPathResolverKt.tryFindingLocalArtifactUsing(group, artifact, BackupClassPathResolverKt.findLocalArtifactDirUsingMaven(group, artifact));
                    if (resolved$iv != null) {
                        objectArray = new Object[]{what$iv};
                        LoggerKt.getLOG().info("Successfully resolved {}", objectArray);
                        path2 = resolved$iv;
                        break block7;
                    }
                    objectArray = new Object[]{what$iv};
                    LoggerKt.getLOG().info("Could not resolve {} as it is null", objectArray);
                }
                catch (Exception e$iv) {
                    objectArray = new Object[]{what$iv, e$iv.getMessage()};
                    LoggerKt.getLOG().info("Could not resolve {}: {}", objectArray);
                }
                path2 = path = null;
            }
            if (path2 == null) {
                what$iv = artifact + " using Gradle";
                $i$f$tryResolving = false;
                try {
                    boolean bl = false;
                    resolved$iv = BackupClassPathResolverKt.tryFindingLocalArtifactUsing(group, artifact, BackupClassPathResolverKt.findLocalArtifactDirUsingGradle(group, artifact));
                    if (resolved$iv != null) {
                        objectArray = new Object[]{what$iv};
                        LoggerKt.getLOG().info("Successfully resolved {}", objectArray);
                        path = resolved$iv;
                        break block8;
                    }
                    objectArray = new Object[]{what$iv};
                    LoggerKt.getLOG().info("Could not resolve {} as it is null", objectArray);
                }
                catch (Exception e$iv) {
                    objectArray = new Object[]{what$iv, e$iv.getMessage()};
                    LoggerKt.getLOG().info("Could not resolve {}: {}", objectArray);
                }
                path = null;
            }
        }
        return path;
    }

    private static final Path tryFindingLocalArtifactUsing(String group, String artifact, LocalArtifactDirectoryResolution artifactDirResolution) {
        Path path;
        BiPredicate<Path, BasicFileAttributes> isCorrectArtifact = (arg_0, arg_1) -> BackupClassPathResolverKt.tryFindingLocalArtifactUsing$lambda$2(artifactDirResolution, artifact, arg_0, arg_1);
        Path path2 = Files.list(artifactDirResolution.getArtifactDir()).sorted((arg_0, arg_1) -> BackupClassPathResolverKt.tryFindingLocalArtifactUsing$lambda$3(tryFindingLocalArtifactUsing.1.INSTANCE, arg_0, arg_1)).findFirst().orElse(null);
        if (path2 != null) {
            Path it = path2;
            boolean bl = false;
            path = Files.find(artifactDirResolution.getArtifactDir(), 3, isCorrectArtifact, new FileVisitOption[0]).findFirst().orElse(null);
        } else {
            path = null;
        }
        return path;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Path findKotlinCliCompilerLibrary(String name) {
        Path path = ShellPathUtilsKt.findCommandOnPath("kotlinc");
        if (path == null) return null;
        Path path2 = path.toRealPath(new LinkOption[0]);
        if (path2 == null) return null;
        Path path3 = path2.getParent();
        if (path3 == null) return null;
        Path path4 = path3.getParent();
        if (path4 == null) return null;
        Path it = path4;
        boolean bl = false;
        Path possibleLibDir = it.resolve("lib");
        Path path5 = Files.exists(possibleLibDir, new LinkOption[0]) ? possibleLibDir : it.resolve("libexec").resolve("lib");
        if (path5 == null) return null;
        Stream<Path> stream = path5;
        Path it2 = stream;
        boolean bl2 = false;
        if (!Files.exists(it2, new LinkOption[0])) return null;
        Path path6 = stream;
        Path path7 = path6;
        if (path7 == null) return null;
        Path p0 = path7;
        boolean bl3 = false;
        stream = Files.list(p0);
        if (stream == null) return null;
        Stream<Object> stream2 = stream.filter(arg_0 -> BackupClassPathResolverKt.findKotlinCliCompilerLibrary$lambda$7((Function1)new Function1<Path, Boolean>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Path it) {
                return Intrinsics.areEqual((Object)((Object)it.getFileName()).toString(), (Object)(this.$name + ".jar"));
            }
        }, arg_0));
        if (stream2 == null) return null;
        Optional<Object> optional = stream2.findFirst();
        if (optional == null) return null;
        Path path8 = optional.orElse(null);
        return path8;
    }

    private static final Path findAlternativeLibraryLocation(String name) {
        Path path = Paths.get("/snap/kotlin/current/lib/" + name + ".jar", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(\"/snap/kotlin/current/lib/${name}.jar\")");
        return BackupClassPathResolverKt.existsOrNull(path);
    }

    private static final Path existsOrNull(Path $this$existsOrNull) {
        return Files.exists($this$existsOrNull, new LinkOption[0]) ? $this$existsOrNull : null;
    }

    private static final LocalArtifactDirectoryResolution findLocalArtifactDirUsingMaven(String group, String artifact) {
        Path path;
        Path path2;
        Path path3 = HomeKt.getMavenRepository();
        return new LocalArtifactDirectoryResolution(path3 != null && (path2 = path3.resolve(StringsKt.replace$default((String)group, (char)'.', (char)File.separatorChar, (boolean)false, (int)4, null))) != null && (path = path2.resolve(artifact)) != null ? BackupClassPathResolverKt.existsOrNull(path) : null, "Maven");
    }

    private static final LocalArtifactDirectoryResolution findLocalArtifactDirUsingGradle(String group, String artifact) {
        Path path;
        Path path2;
        Path path3 = BackupClassPathResolverKt.getGradleCaches();
        return new LocalArtifactDirectoryResolution(path3 != null && (path2 = path3.resolve(group)) != null && (path = path2.resolve(artifact)) != null ? BackupClassPathResolverKt.existsOrNull(path) : null, "Gradle");
    }

    private static final Path getGradleCaches() {
        Lazy lazy = gradleCaches$delegate;
        return (Path)lazy.getValue();
    }

    private static final Path resolveStartingWith(Path $this$resolveStartingWith, String prefix) {
        return Files.list($this$resolveStartingWith).filter(arg_0 -> BackupClassPathResolverKt.resolveStartingWith$lambda$8((Function1)new Function1<Path, Boolean>(prefix){
            final /* synthetic */ String $prefix;
            {
                this.$prefix = $prefix;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Path it) {
                return StringsKt.startsWith$default((String)((Object)it.getFileName()).toString(), (String)this.$prefix, (boolean)false, (int)2, null);
            }
        }, arg_0)).findFirst().orElse(null);
    }

    private static final int compareVersions(Path left, Path right) {
        List<String> leftVersion = BackupClassPathResolverKt.extractVersion(left);
        List<String> rightVersion = BackupClassPathResolverKt.extractVersion(right);
        int n = Math.min(leftVersion.size(), rightVersion.size());
        for (int i = 0; i < n; ++i) {
            String rightRev;
            String leftRev = ((Object)StringsKt.reversed((CharSequence)leftVersion.get(i))).toString();
            int compare = leftRev.compareTo(rightRev = ((Object)StringsKt.reversed((CharSequence)rightVersion.get(i))).toString());
            if (compare == 0) continue;
            return -compare;
        }
        return -Intrinsics.compare((int)leftVersion.size(), (int)rightVersion.size());
    }

    private static final List<String> extractVersion(Path artifactVersionDir) {
        String[] stringArray = new String[]{"."};
        return StringsKt.split$default((CharSequence)((Object)artifactVersionDir).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
    }

    private static final boolean tryFindingLocalArtifactUsing$lambda$2(LocalArtifactDirectoryResolution $artifactDirResolution, String $artifact, Path file, BasicFileAttributes basicFileAttributes) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$artifactDirResolution, (String)"$artifactDirResolution");
        Intrinsics.checkNotNullParameter((Object)$artifact, (String)"$artifact");
        String name = ((Object)file.getFileName()).toString();
        if (Intrinsics.areEqual((Object)$artifactDirResolution.getBuildTool(), (Object)"Maven")) {
            String version = ((Object)file.getParent().getFileName()).toString();
            String expected = $artifact + "-" + version + ".jar";
            bl = Intrinsics.areEqual((Object)name, (Object)expected);
        } else {
            bl = StringsKt.startsWith$default((String)name, (String)$artifact, (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)name, (String)".jar", (boolean)false, (int)2, null);
        }
        return bl;
    }

    private static final int tryFindingLocalArtifactUsing$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final boolean findKotlinCliCompilerLibrary$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean resolveStartingWith$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ int access$compareVersions(Path left, Path right) {
        return BackupClassPathResolverKt.compareVersions(left, right);
    }

    public static final /* synthetic */ Path access$resolveStartingWith(Path $receiver, String prefix) {
        return BackupClassPathResolverKt.resolveStartingWith($receiver, prefix);
    }
}

