/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.javacs.kt.LoggerKt;
import org.javacs.kt.database.DatabaseService;
import org.javacs.kt.index.ExtractSymbolExtensionReceiverType;
import org.javacs.kt.index.ExtractSymbolKind;
import org.javacs.kt.index.ExtractSymbolVisibility;
import org.javacs.kt.index.Locations;
import org.javacs.kt.index.Positions;
import org.javacs.kt.index.Ranges;
import org.javacs.kt.index.Symbol;
import org.javacs.kt.index.SymbolEntity;
import org.javacs.kt.index.Symbols;
import org.javacs.kt.progress.Progress;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.FieldSet;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.OpKt;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.SQLExpressionBuilderKt;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.SizedIterable;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\"\u0010\u0019\u001a\u00020\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\u0016\u0010\u001c\u001a\u00020\u00132\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u0016\u0010\u001e\u001a\u00020\u00132\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u001e\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020!\u0012\u0006\u0012\u0004\u0018\u00010!0 2\u0006\u0010\"\u001a\u00020\u0018H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020!H\u0002J4\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010)\u001a\u00020*2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010!2\b\b\u0002\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020*J$\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J \u00100\u001a\b\u0012\u0004\u0012\u00020!0\u00172\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u00101\u001a\u00020!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u00062"}, d2={"Lorg/javacs/kt/index/SymbolIndex;", "", "databaseService", "Lorg/javacs/kt/database/DatabaseService;", "<init>", "(Lorg/javacs/kt/database/DatabaseService;)V", "db", "Lorg/jetbrains/exposed/sql/Database;", "getDb", "()Lorg/jetbrains/exposed/sql/Database;", "db$delegate", "Lkotlin/Lazy;", "progressFactory", "Lorg/javacs/kt/progress/Progress$Factory;", "getProgressFactory", "()Lorg/javacs/kt/progress/Progress$Factory;", "setProgressFactory", "(Lorg/javacs/kt/progress/Progress$Factory;)V", "refresh", "", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "exclusions", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "updateIndexes", "remove", "add", "removeDeclarations", "declarations", "addDeclarations", "getFqNames", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/name/FqName;", "declaration", "validFqName", "", "fqName", "query", "", "Lorg/javacs/kt/index/Symbol;", "prefix", "", "receiverType", "limit", "", "suffix", "allDescriptors", "allPackages", "pkgName", "server"})
@SourceDebugExtension(value={"SMAP\nSymbolIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SymbolIndex.kt\norg/javacs/kt/index/SymbolIndex\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,218:1\n1317#2:219\n1318#2:221\n1317#2,2:222\n1251#2,2:228\n1#3:220\n1557#4:224\n1628#4,3:225\n*S KotlinDebug\n*F\n+ 1 SymbolIndex.kt\norg/javacs/kt/index/SymbolIndex\n*L\n146#1:219\n146#1:221\n159#1:222,2\n206#1:228,2\n192#1:224\n192#1:225,3\n*E\n"})
public final class SymbolIndex {
    @NotNull
    private final DatabaseService databaseService;
    @NotNull
    private final Lazy db$delegate;
    @NotNull
    private Progress.Factory progressFactory;

    public SymbolIndex(@NotNull DatabaseService databaseService) {
        Intrinsics.checkNotNullParameter((Object)databaseService, (String)"databaseService");
        this.databaseService = databaseService;
        this.db$delegate = LazyKt.lazy(() -> SymbolIndex.db_delegate$lambda$0(this));
        this.progressFactory = Progress.Factory.None.INSTANCE;
        ThreadLocalTransactionManagerKt.transaction((Database)this.getDb(), SymbolIndex::_init_$lambda$1);
    }

    private final Database getDb() {
        Lazy lazy = this.db$delegate;
        return (Database)lazy.getValue();
    }

    @NotNull
    public final Progress.Factory getProgressFactory() {
        return this.progressFactory;
    }

    public final void setProgressFactory(@NotNull Progress.Factory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"<set-?>");
        this.progressFactory = factory;
    }

    public final void refresh(@NotNull ModuleDescriptor module, @NotNull Sequence<? extends DeclarationDescriptor> exclusions) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(exclusions, (String)"exclusions");
        long started = System.currentTimeMillis();
        LoggerKt.getLOG().info("Updating full symbol index...", new Object[0]);
        this.progressFactory.create("Indexing").thenApplyAsync(arg_0 -> SymbolIndex.refresh$lambda$4(arg_0 -> SymbolIndex.refresh$lambda$3(this, module, exclusions, started, arg_0), arg_0));
    }

    public final void updateIndexes(@NotNull Sequence<? extends DeclarationDescriptor> remove, @NotNull Sequence<? extends DeclarationDescriptor> add) {
        Intrinsics.checkNotNullParameter(remove, (String)"remove");
        Intrinsics.checkNotNullParameter(add, (String)"add");
        long started = System.currentTimeMillis();
        LoggerKt.getLOG().info("Updating symbol index...", new Object[0]);
        try {
            ThreadLocalTransactionManagerKt.transaction((Database)this.getDb(), arg_0 -> SymbolIndex.updateIndexes$lambda$5(this, remove, add, started, arg_0));
        }
        catch (Exception e) {
            LoggerKt.getLOG().error("Error while updating symbol index", new Object[0]);
            LoggerKt.getLOG().printStackTrace((Throwable)e);
        }
    }

    private final void removeDeclarations(Sequence<? extends DeclarationDescriptor> declarations) {
        Sequence<? extends DeclarationDescriptor> $this$forEach$iv = declarations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DeclarationDescriptor declaration = (DeclarationDescriptor)element$iv;
            boolean bl = false;
            Pair<FqName, FqName> pair = this.getFqNames(declaration);
            FqName descriptorFqn = (FqName)pair.component1();
            FqName extensionReceiverFqn = (FqName)pair.component2();
            if (this.validFqName(descriptorFqn)) {
                boolean bl2;
                if (extensionReceiverFqn != null) {
                    FqName it;
                    boolean bl3 = false;
                    bl2 = !this.validFqName(it);
                } else {
                    bl2 = false;
                }
                if (!bl2) {
                    QueriesKt.deleteWhere$default((Table)((Table)Symbols.INSTANCE), null, null, arg_0 -> SymbolIndex.removeDeclarations$lambda$8$lambda$7(descriptorFqn, extensionReceiverFqn, arg_0), (int)3, null);
                    continue;
                }
            }
            Object[] objectArray = new Object[]{descriptorFqn.toString()};
            LoggerKt.getLOG().warn("Excluding symbol {} from index since its name is too long", objectArray);
        }
    }

    private final void addDeclarations(Sequence<? extends DeclarationDescriptor> declarations) {
        Sequence<? extends DeclarationDescriptor> $this$forEach$iv = declarations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DeclarationDescriptor declaration = (DeclarationDescriptor)element$iv;
            boolean bl = false;
            Pair<FqName, FqName> pair = this.getFqNames(declaration);
            FqName descriptorFqn = (FqName)pair.component1();
            FqName extensionReceiverFqn = (FqName)pair.component2();
            if (this.validFqName(descriptorFqn)) {
                boolean bl2;
                if (extensionReceiverFqn != null) {
                    FqName it;
                    boolean bl3 = false;
                    bl2 = !this.validFqName(it);
                } else {
                    bl2 = false;
                }
                if (!bl2) {
                    SymbolEntity.Companion.new(arg_0 -> SymbolIndex.addDeclarations$lambda$11$lambda$10(descriptorFqn, declaration, extensionReceiverFqn, arg_0));
                    continue;
                }
            }
            Object[] objectArray = new Object[]{descriptorFqn.toString()};
            LoggerKt.getLOG().warn("Excluding symbol {} from index since its name is too long", objectArray);
        }
    }

    private final Pair<FqName, FqName> getFqNames(DeclarationDescriptor declaration) {
        Object object;
        FqName descriptorFqn = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)declaration);
        FqName fqName = (FqName)declaration.accept((DeclarationDescriptorVisitor)ExtractSymbolExtensionReceiverType.INSTANCE, (Object)Unit.INSTANCE);
        if (fqName != null) {
            FqName fqName2;
            FqName it = fqName2 = fqName;
            boolean bl = false;
            object = !it.isRoot() ? fqName2 : null;
        } else {
            object = null;
        }
        FqName extensionReceiverFqn = object;
        return new Pair((Object)descriptorFqn, extensionReceiverFqn);
    }

    private final boolean validFqName(FqName fqName) {
        return fqName.toString().length() <= 255 && fqName.shortName().toString().length() <= 80;
    }

    @NotNull
    public final List<Symbol> query(@NotNull String prefix, @Nullable FqName receiverType, int limit, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        return (List)ThreadLocalTransactionManagerKt.transaction((Database)this.getDb(), arg_0 -> SymbolIndex.query$lambda$15(limit, prefix, suffix, receiverType, arg_0));
    }

    public static /* synthetic */ List query$default(SymbolIndex symbolIndex, String string, FqName fqName, int n, String string2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            fqName = null;
        }
        if ((n2 & 4) != 0) {
            n = 20;
        }
        if ((n2 & 8) != 0) {
            string2 = "%";
        }
        return symbolIndex.query(string, fqName, n, string2);
    }

    private final Sequence<DeclarationDescriptor> allDescriptors(ModuleDescriptor module, Sequence<? extends DeclarationDescriptor> exclusions) {
        return SequencesKt.flatMapIterable((Sequence)SequencesKt.map((Sequence)SymbolIndex.allPackages$default(this, module, null, 2, null), (Function1)((Function1)new Function1<FqName, PackageViewDescriptor>((Object)module){

            public final PackageViewDescriptor invoke(FqName p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((ModuleDescriptor)this.receiver).getPackage(p0);
            }
        })), arg_0 -> SymbolIndex.allDescriptors$lambda$18(exclusions, arg_0));
    }

    private final Sequence<FqName> allPackages(ModuleDescriptor module, FqName pkgName) {
        return SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)module.getSubPackagesOf(pkgName, SymbolIndex::allPackages$lambda$19)), arg_0 -> SymbolIndex.allPackages$lambda$20(this, module, arg_0));
    }

    static /* synthetic */ Sequence allPackages$default(SymbolIndex symbolIndex, ModuleDescriptor moduleDescriptor, FqName fqName, int n, Object object) {
        if ((n & 2) != 0) {
            fqName = FqName.ROOT;
        }
        return symbolIndex.allPackages(moduleDescriptor, fqName);
    }

    private static final Database db_delegate$lambda$0(SymbolIndex this$0) {
        Database database = this$0.databaseService.getDb();
        if (database == null) {
            database = Database.Companion.connect$default((Database.Companion)Database.Companion, (String)"jdbc:h2:mem:symbolindex;DB_CLOSE_DELAY=-1", (String)"org.h2.Driver", null, null, null, null, null, (int)124, null);
        }
        return database;
    }

    private static final Unit _init_$lambda$1(Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        Table[] tableArray = new Table[]{Symbols.INSTANCE, Locations.INSTANCE, Ranges.INSTANCE, Positions.INSTANCE};
        SchemaUtils.createMissingTablesAndColumns$default((SchemaUtils)SchemaUtils.INSTANCE, (Table[])tableArray, (boolean)false, (boolean)false, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit refresh$lambda$3$lambda$2(SymbolIndex this$0, ModuleDescriptor $module, Sequence $exclusions, long $started, Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        QueriesKt.deleteAll((Table)((Table)Symbols.INSTANCE));
        this$0.addDeclarations(this$0.allDescriptors($module, (Sequence<? extends DeclarationDescriptor>)$exclusions));
        long finished = System.currentTimeMillis();
        long count = ((Number)((ResultRow)CollectionsKt.first((Iterable)((Iterable)QueriesKt.selectAll((FieldSet)Symbols.INSTANCE.slice((Expression)SQLExpressionBuilderKt.count((ExpressionWithColumnType)((ExpressionWithColumnType)Symbols.INSTANCE.getFqName())), new Expression[0]))))).get((Expression)SQLExpressionBuilderKt.count((ExpressionWithColumnType)((ExpressionWithColumnType)Symbols.INSTANCE.getFqName())))).longValue();
        LoggerKt.getLOG().info("Updated full symbol index in " + (finished - $started) + " ms! (" + count + " symbol(s))", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit refresh$lambda$3(SymbolIndex this$0, ModuleDescriptor $module, Sequence $exclusions, long $started, Progress progress) {
        try {
            ThreadLocalTransactionManagerKt.transaction((Database)this$0.getDb(), arg_0 -> SymbolIndex.refresh$lambda$3$lambda$2(this$0, $module, $exclusions, $started, arg_0));
        }
        catch (Exception e) {
            LoggerKt.getLOG().error("Error while updating symbol index", new Object[0]);
            LoggerKt.getLOG().printStackTrace((Throwable)e);
        }
        progress.close();
        return Unit.INSTANCE;
    }

    private static final Unit refresh$lambda$4(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }

    private static final Unit updateIndexes$lambda$5(SymbolIndex this$0, Sequence $remove, Sequence $add, long $started, Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        this$0.removeDeclarations((Sequence<? extends DeclarationDescriptor>)$remove);
        this$0.addDeclarations((Sequence<? extends DeclarationDescriptor>)$add);
        long finished = System.currentTimeMillis();
        long count = ((Number)((ResultRow)CollectionsKt.first((Iterable)((Iterable)QueriesKt.selectAll((FieldSet)Symbols.INSTANCE.slice((Expression)SQLExpressionBuilderKt.count((ExpressionWithColumnType)((ExpressionWithColumnType)Symbols.INSTANCE.getFqName())), new Expression[0]))))).get((Expression)SQLExpressionBuilderKt.count((ExpressionWithColumnType)((ExpressionWithColumnType)Symbols.INSTANCE.getFqName())))).longValue();
        LoggerKt.getLOG().info("Updated symbol index in " + (finished - $started) + " ms! (" + count + " symbol(s))", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Op removeDeclarations$lambda$8$lambda$7(FqName $descriptorFqn, FqName $extensionReceiverFqn, SqlExpressionBuilder $this$deleteWhere) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteWhere, (String)"$this$deleteWhere");
        FqName fqName = $extensionReceiverFqn;
        return OpKt.and((Expression)((Expression)$this$deleteWhere.eq((ExpressionWithColumnType)Symbols.INSTANCE.getFqName(), (Object)$descriptorFqn.toString())), (Expression)((Expression)$this$deleteWhere.eq((ExpressionWithColumnType)Symbols.INSTANCE.getExtensionReceiverType(), (Object)(fqName != null ? fqName.toString() : null))));
    }

    private static final Unit addDeclarations$lambda$11$lambda$10(FqName $descriptorFqn, DeclarationDescriptor $declaration, FqName $extensionReceiverFqn, SymbolEntity $this$new) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$new), (String)"$this$new");
        $this$new.setFqName($descriptorFqn.toString());
        $this$new.setShortName($descriptorFqn.shortName().toString());
        $this$new.setKind(((Symbol.Kind)((Object)$declaration.accept((DeclarationDescriptorVisitor)ExtractSymbolKind.INSTANCE, (Object)Unit.INSTANCE))).getRawValue());
        $this$new.setVisibility(((Symbol.Visibility)((Object)$declaration.accept((DeclarationDescriptorVisitor)ExtractSymbolVisibility.INSTANCE, (Object)Unit.INSTANCE))).getRawValue());
        FqName fqName = $extensionReceiverFqn;
        $this$new.setExtensionReceiverType(fqName != null ? fqName.toString() : null);
        return Unit.INSTANCE;
    }

    private static final Op query$lambda$15$lambda$13(String $prefix, String $suffix, FqName $receiverType, SqlExpressionBuilder $this$find) {
        Intrinsics.checkNotNullParameter((Object)$this$find, (String)"$this$find");
        FqName fqName = $receiverType;
        return OpKt.and((Expression)((Expression)$this$find.like((Expression)Symbols.INSTANCE.getShortName(), $prefix + $suffix)), (Expression)((Expression)$this$find.eq((ExpressionWithColumnType)Symbols.INSTANCE.getExtensionReceiverType(), (Object)(fqName != null ? fqName.toString() : null))));
    }

    /*
     * WARNING - void declaration
     */
    private static final List query$lambda$15(int $limit, String $prefix, String $suffix, FqName $receiverType, Transaction $this$transaction) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        Iterable iterable = (Iterable)SizedIterable.DefaultImpls.limit$default((SizedIterable)SymbolEntity.Companion.find(arg_0 -> SymbolIndex.query$lambda$15$lambda$13($prefix, $suffix, $receiverType, arg_0)), (int)$limit, (long)0L, (int)2, null);
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FqName fqName;
            void it;
            SymbolEntity symbolEntity = (SymbolEntity)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            FqName fqName2 = new FqName(it.getFqName());
            Symbol.Kind kind = Symbol.Kind.Companion.fromRaw(it.getKind());
            Symbol.Visibility visibility = Symbol.Visibility.Companion.fromRaw(it.getVisibility());
            if (it.getExtensionReceiverType() != null) {
                void p0;
                Symbol.Visibility visibility2 = visibility;
                Symbol.Kind kind2 = kind;
                FqName fqName3 = fqName2;
                boolean bl2 = false;
                FqName fqName4 = new FqName((String)p0);
                fqName2 = fqName3;
                kind = kind2;
                visibility = visibility2;
                fqName = fqName4;
            } else {
                fqName = null;
            }
            FqName fqName5 = fqName;
            Symbol.Visibility visibility3 = visibility;
            Symbol.Kind kind3 = kind;
            FqName fqName6 = fqName2;
            collection.add(new Symbol(fqName6, kind3, visibility3, fqName5));
        }
        return (List)destination$iv$iv;
    }

    private static final boolean allDescriptors$lambda$18$lambda$17(Sequence $exclusions, Name name) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Sequence $this$any$iv = $exclusions;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                DeclarationDescriptor declaration = (DeclarationDescriptor)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)declaration.getName(), (Object)name)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return !bl;
    }

    private static final Iterable allDescriptors$lambda$18(Sequence $exclusions, PackageViewDescriptor it) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            collection = it.getMemberScope().getContributedDescriptors(DescriptorKindFilter.ALL, arg_0 -> SymbolIndex.allDescriptors$lambda$18$lambda$17($exclusions, arg_0));
        }
        catch (IllegalStateException e) {
            LoggerKt.getLOG().warn("Could not query descriptors in package " + it, new Object[0]);
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    private static final boolean allPackages$lambda$19(Name it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it.toString(), (Object)"META-INF");
    }

    private static final Sequence allPackages$lambda$20(SymbolIndex this$0, ModuleDescriptor $module, FqName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new FqName[]{it};
        return SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object[])objectArray), this$0.allPackages($module, it));
    }
}

