(* (c) Microsoft Corporation 2005-2007.  *)

module Microsoft.FSharp.Compatibility.OCaml.Filename
open Microsoft.FSharp.Compatibility.OCaml
open Microsoft.FSharp.Compatibility.OCaml.Pervasives

open System.IO

let current_dir_name = "."
let parent_dir_name =  ".."
let concat (x:string) (y:string) = Path.Combine (x,y)
let is_relative (s:string) = not (Path.IsPathRooted(s))

let check_suffix (x:string) (y:string) = x.EndsWith(y)

let chop_suffix (x:string) (y:string) =
  if not (check_suffix x y) then invalid_arg "chop_suffix";
  x.[0..x.Length-y.Length-1]

let has_extension (s:string) = 
  (s.Length >= 1 && s.[s.Length - 1] = '.') 
  || Path.HasExtension(s)

let chop_extension (s:string) =
  if not (has_extension s) then invalid_arg "chop_extension";
  Path.Combine (Path.GetDirectoryName s,Path.GetFileNameWithoutExtension(s))


let basename (s:string) = 
  Path.GetFileName(s)
let dirname (s:string) = 
  if s = "" then "."
  else 
    match Path.GetDirectoryName(s) with 
    | null -> if Path.IsPathRooted(s) then s else "."
    | res -> if res = "" then "." else res

let is_implicit (s:string) = 
  is_relative s &&
    match Path.GetDirectoryName(s) with 
    | null -> true
    | res -> (res <> current_dir_name && res <> parent_dir_name)


let temp_file (p:string) (s:string) = Path.GetTempFileName()

let quote s = "\'" ^ s ^ "\'"

