// Copyright (c) Microsoft Corporation 2005-2006.
// This sample code is provided "as is" without warranty of any kind. 
// We disclaim all warranties, either express or implied, including the 
// warranties of merchantability and fitness for a particular purpose. 

#light

open System
open System.IO
open System.Windows.Forms
open Printf

// Create a form and set some properties

let form = new Form()

form.Text <- "My First F# Form"
form.Visible <- true

let menu = form.Menu <- new MainMenu()
let mnuFile = form.Menu.MenuItems.Add("&File")

let mnuiOpen = 
  new MenuItem("&Open...", 
               new EventHandler(fun _ _ -> 
                   let d = new OpenFileDialog() in 
                   d.InitialDirectory <- "c:\\";
                   d.Filter <- "txt files (*.txt)|*.txt|All files (*.*)|*.*";
                   d.FilterIndex <- 2;
                   d.RestoreDirectory <- true;
                   if d.ShowDialog() = DialogResult.OK then 
                       match d.OpenFile() with 
                       | null -> printf "Ooops... Could not read the file...\n"
                       | s -> 
                           let r = new StreamReader(s) in 
                           printf "The first line of the file is: %s!\n" (r.ReadLine());
                           s.Close();
               ), 
               Shortcut.CtrlO)

mnuFile.MenuItems.Add(mnuiOpen)

#if COMPILED
// Run the main code. The attribute marks the startup application thread as "Single 
// Thread Apartment" mode, which is necessary for GUI applications. 
[<STAThread>]    
do Application.Run(form)

#endif
