// Copyright (c) Microsoft Corporation 2005-2007.
// This sample code is provided "as is" without warranty of any kind. 
// We disclaim all warranties, either express or implied, including the 
// warranties of merchantability and fitness for a particular purpose. 
//

#light

module Microsoft.FSharp.Xml.Linq

open System
open System.Xml.Linq
open System.Collections.Generic

module SequenceOps = begin

    let elements s (coll :> IEnumerable<_>) = 
        System.Xml.Linq.Extensions.Elements(coll,s)

    let ancestors s (coll :> IEnumerable<_>) = 
        System.Xml.Linq.Extensions.Ancestors(coll,s)

    let descendants s (coll :> IEnumerable<_>) = 
        System.Xml.Linq.Extensions.Descendants(coll,s)

    let AncestrosAndSelf s (coll :> IEnumerable<_>) = 
        System.Xml.Linq.Extensions.AncestorsAndSelf(coll,s)

    let selfAndDescendants s (coll :> IEnumerable<_>) = 
        System.Xml.Linq.Extensions.DescendantsAndSelf(coll,s)

    let xname n = System.Xml.Linq.XName.op_Implicit(n)

    let attribute (s:string) (e: System.Xml.Linq.XElement) = 
        e.Attribute(xname s)

    let attribute_to_string (e: System.Xml.Linq.XAttribute) = 
        (System.Xml.Linq.XAttribute.op_Explicit(e) : string)

    let element_to_string (e: System.Xml.Linq.XElement) = 
        (System.Xml.Linq.XElement.op_Explicit(e) : string)

    let element_to_DateTime (e: System.Xml.Linq.XElement) = 
        (System.Xml.Linq.XElement.op_Explicit(e) : DateTime)

    let element_to_int (e: System.Xml.Linq.XElement) = 
        (System.Xml.Linq.XElement.op_Explicit(e) : int)

    let xargs l = Idioms.ParamArray (List.map box l)
    
end
